<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Extrato de Pagamentos - {{ $user->name }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 10px;
            color: #333;
            line-height: 1.3;
        }

        .header {
            background-color: #667eea;
            color: white;
            padding: 15px;
            margin-bottom: 12px;
        }

        .logo-section {
            text-align: center;
        }

        .school-name {
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 3px;
        }

        .school-info {
            font-size: 9px;
            opacity: 0.95;
        }

        .document-title {
            text-align: center;
            font-size: 13px;
            font-weight: bold;
            margin: 8px 0 6px;
            color: #667eea;
            border-bottom: 2px solid #667eea;
            padding-bottom: 5px;
        }

        .student-info {
            background-color: #f8f9fa;
            padding: 10px 15px;
            margin-bottom: 12px;
        }

        .info-row {
            display: inline-block;
            width: 49%;
            margin-bottom: 5px;
            vertical-align: top;
        }

        .info-label {
            font-weight: bold;
            color: #555;
            font-size: 9px;
        }

        .info-value {
            color: #222;
            font-size: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 12px;
        }

        thead {
            background-color: #667eea !important;
            color: white !important;
        }

        thead th {
            background-color: #667eea !important;
            color: white !important;
        }

        th {
            padding: 6px 4px;
            text-align: left;
            font-weight: bold;
            font-size: 9px;
            text-transform: uppercase;
        }

        td {
            padding: 5px 4px;
            border-bottom: 1px solid #e0e0e0;
            font-size: 9px;
        }

        tbody tr:nth-child(even) {
            background-color: #fafbfc;
        }

        .text-center {
            text-align: center;
        }

        .text-right {
            text-align: right;
        }

        .badge {
            padding: 2px 6px;
            border-radius: 6px;
            font-size: 8px;
            font-weight: bold;
            display: inline-block;
        }

        .badge-success {
            background-color: #d4edda !important;
            color: #155724 !important;
        }

        .badge-warning {
            background-color: #fff3cd !important;
            color: #856404 !important;
        }

        .badge-danger {
            background-color: #f8d7da !important;
            color: #721c24 !important;
        }

        .badge-secondary {
            background-color: #e2e3e5 !important;
            color: #383d41 !important;
        }

        .summary-box {
            background-color: #f8f9fa;
            border-left: 3px solid #667eea;
            padding: 10px 12px;
            margin-top: 12px;
        }

        .summary-row {
            display: inline-block;
            width: 49%;
            margin-bottom: 3px;
            font-size: 9px;
        }

        .summary-label {
            font-weight: bold;
            color: #555;
        }

        .summary-value {
            font-weight: bold;
            color: #222;
            margin-left: 5px;
        }

        .footer {
            margin-top: 15px;
            padding-top: 10px;
            border-top: 1px solid #e0e0e0;
            text-align: center;
            font-size: 9px;
            color: #777;
        }

        .watermark {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 80px;
            color: rgba(102, 126, 234, 0.03);
            font-weight: bold;
            z-index: -1;
        }

        .page-number {
            position: fixed;
            bottom: 20px;
            right: 30px;
            font-size: 9px;
            color: #999;
        }

        .no-data {
            text-align: center;
            padding: 40px;
            color: #999;
            font-style: italic;
        }
    </style>
</head>
<body>
    <!-- Watermark -->
    <div class="watermark">COPMOZ</div>

    <!-- Header -->
    <div class="header">
        <div class="logo-section">
            <div class="school-name">COLÉGIO POLITÉCNICO DE MOÇAMBIQUE</div>
            <div class="school-info">
                NUIT:  | Tel: (+258) <br>
                Email: info@copmoz.ac.mz | Nampula, Moçambique
            </div>
        </div>
    </div>

    <!-- Document Title -->
    <h1 class="document-title">EXTRATO DE PAGAMENTOS</h1>

    <!-- Student Information -->
    <div class="student-info">
        <div class="info-row">
            <span class="info-label">Nome: </span>
            <span class="info-value">{{ $user->name }}</span>
        </div>

        <div class="info-row">
            <span class="info-label">ID: </span>
            <span class="info-value">{{ $user->student_id }}</span>
        </div>

        <div class="info-row">
            <span class="info-label">Classe/Turma: </span>
            <span class="info-value">{{ $classroom->class ?? 'N/A' }}ª {{ $classroom->name ?? '' }}</span>
        </div>

        <div class="info-row">
            <span class="info-label">Ano Letivo: </span>
            <span class="info-value">{{ $academicYear }}</span>
        </div>

        <div class="info-row">
            <span class="info-label">Data Emissão: </span>
            <span class="info-value">{{ $generatedAt }}</span>
        </div>
    </div>

    <!-- Payments Table -->
    <h3 style="margin: 8px 0 6px; color: #667eea; font-size: 11px;">Histórico de Pagamentos - Ano {{ $academicYear }}</h3>

    <table>
        <thead>
            <tr>
                <th width="6%">Mês</th>
                <th width="20%">Descrição</th>
                <th width="12%">Valor</th>
                <th width="12%">Tipo Pag.</th>
                <th width="15%">Ref/Trans ID</th>
                <th width="13%">Data Pag.</th>
                <th width="12%" class="text-center">Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($allMonthsData as $monthData)
            <tr>
                <td class="text-center">{{ str_pad($monthData['month_number'], 2, '0', STR_PAD_LEFT) }}</td>
                <td>{{ $monthData['month_name'] }} / {{ $academicYear }}</td>
                <td>
                    @if($monthData['amount'] > 0)
                        {{ number_format($monthData['amount'], 2, ',', '.') }} MT
                    @else
                        -
                    @endif
                </td>
                <td style="font-size: 8px;">{{ $monthData['payment_type'] ?? '-' }}</td>
                <td style="font-size: 7px;">
                    @if(isset($monthData['transaction_id']) && $monthData['transaction_id'] !== '-')
                        {{ $monthData['transaction_id'] }}
                    @elseif(isset($monthData['reference']) && $monthData['reference'] !== '-')
                        {{ $monthData['reference'] }}
                    @else
                        -
                    @endif
                </td>
                <td style="font-size: 8px;">
                    @if($monthData['paid_at'])
                        {{ \Carbon\Carbon::parse($monthData['paid_at'])->format('d/m/Y') }}
                    @else
                        -
                    @endif
                </td>
                <td class="text-center">
                    @if($monthData['status'] === 'paid')
                        <span class="badge badge-success">Pago</span>
                    @elseif($monthData['status'] === 'expired')
                        <span class="badge badge-danger">Expirado</span>
                    @elseif($monthData['status'] === 'pending')
                        <span class="badge badge-warning">Pendente</span>
                    @elseif($monthData['status'] === 'not_generated')
                        <span class="badge badge-secondary">Não Gerado</span>
                    @else
                        <span class="badge badge-secondary">-</span>
                    @endif
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <!-- Summary -->
    <div class="summary-box">
        <h4 style="margin: 0 0 6px; color: #667eea; font-size: 10px;">Resumo Financeiro</h4>

        <div class="summary-row">
            <span class="summary-label">Total Pago:</span>
            <span class="summary-value" style="color: #28a745;">{{ number_format($totalPaid, 2, ',', '.') }} MT</span>
        </div>

        <div class="summary-row">
            <span class="summary-label">Total Pendente:</span>
            <span class="summary-value" style="color: #ffc107;">{{ number_format($totalPending, 2, ',', '.') }} MT</span>
        </div>

        <div class="summary-row">
            <span class="summary-label">Meses Pagos:</span>
            <span class="summary-value">{{ $countPaid }}</span>
        </div>

        <div class="summary-row" style="width: 100%; margin-bottom: 6px;">
            <span class="summary-label">Situação Acadêmica:</span>
            <span class="summary-value" style="color: {{ $user->is_paid ? '#28a745' : '#dc3545' }};">
                {{ $user->is_paid ? 'REGULAR' : 'BLOQUEADA' }}
            </span>
            <div style="font-size: 8px; color: #666; margin-top: 1px; font-style: italic;">
                {{ $user->is_paid ? '(Acesso liberado a serviços acadêmicos)' : '(Acesso bloqueado por pendências financeiras)' }}
            </div>
        </div>

        <div class="summary-row" style="width: 100%;">
            <span class="summary-label">Situação Financeira:</span>
            <span class="summary-value" style="color: {{ $paymentStatusColor }};">
                {{ $paymentStatus }}
            </span>
            <div style="font-size: 8px; color: #666; margin-top: 1px; font-style: italic;">
                {{ $paymentStatusDetail }}
            </div>
        </div>
    </div>

    <!-- Footer -->
    <div class="footer">
        <p style="margin: 2px 0;"><strong>COLÉGIO POLITÉCNICO DE MOÇAMBIQUE</strong> | Documento gerado automaticamente</p>
        <p style="margin: 2px 0;">© {{ now()->year }} COPMOZ - Desenvolvido por iFix, Lda</p>
    </div>

    <!-- Page Number -->
    <div class="page-number">
        Página 1 de 1
    </div>
</body>
</html>
