<?php

namespace App\Http\Livewire\Admin\Books;

use App\Models\Admin;
use App\Models\Book;
use App\Models\Subject;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;
use App\Http\Controllers\SystemController;
use App\Models\Category;
use Livewire\WithFileUploads;

class AddBook extends Component
{
    use FindGuard, LivewireAlert, WithFileUploads;

    public $title, $description, $category_id, $photo,$pdf,$author,  $validatedData;
    public $updateMode = false;
    public $user;
    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    protected array $rules = [
        'title' => ['required', 'string', 'max:255'],
        'author' => ['required', 'string', 'max:255'],
        'category_id' => ['required', 'string', 'max:255'],
        'description' => ['nullable', 'string', 'max:255'],
        'photo' => ['required', 'mimes:jpeg,png,jpg,gif,svg', 'max:2048'], // 2MB Max
        'pdf' => ['required', 'mimes:pdf'], // 2MB Max
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function submit()
    {
        $this->validatedData = $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {

        $details = SystemController::store_media($this->photo);
        $pdfd = SystemController::store_media($this->pdf);
        Book::query()->create([
            'title' => $this->title,
             'author' => $this->author,
            'category_id' => $this->category_id,
            'description' => $this->description,
            'media_name' => $details[0],
            'media_url' => $details[1],
            'pdf_name' => $pdfd[0],
            'pdf_url' => $pdfd[1],
        ]);
        Note::createSystemNotification(Admin::class, 'Novo livro', ' Novo livro adicionado com sucesso ' . $this->title);
        $this->emit('noteAdded');
        $this->alert('success', 'Novo livro adicionado com sucesso ' . $this->title);
        $this->reset();
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }
    public function render()
    {
        return view('livewire.admin.books.add-book', [
            'subjects' => Category::query()->orderBy('name')->get(),
        ]);
    }
}
