<?php

namespace App\Http\Livewire\Admin\Downloadcenter;

use App\Models\Downloadcenter;
use App\Models\Downloadsetings;
use App\Models\User;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;
use Auth;

class Downloads extends Component
{
    use WithPagination, FindGuard, LivewireAlert;

    public $search = '', $delete, $slug;
    public $filter = '';
    public $selectedIds = []; // Selected IDs
    public $selectAll = false; // Select All state
    public bool $readyToLoad = false;

    protected $queryString = ['search'];
    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = ['confirmed', 'cancelled'];

    public function updatedSelectAll($value)
    {
        if ($value) {
            $this->selectedIds = Downloadsetings::pluck('id')->toArray();
        } else {
            $this->selectedIds = [];
        }
    }

    public function updatedSelectedIds()
    {
        $this->selectAll = count($this->selectedIds) === Downloadsetings::count();
    }

    public function submit($id)
    {
        $this->resetComponentState();

        $this->delete = Downloadcenter::query()->firstWhere('slug', $id);
        $this->slug = $this->delete->slug;

        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => "confirmed",
            'onDismissed' => 'cancelled',
            'slug' => $id,
        ]);
    }

    public function confirmed()
    {
        Downloadcenter::where('slug', $this->slug)->delete();
        Downloadsetings::where('download_id', $this->slug)->delete();

        Note::createSystemNotification(Admin::class, 'Matriz', 'Deletado com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Deletado com sucesso ');
    }

    public function bulkDelete()
    {
        if (empty($this->selectedIds)) {
            $this->emit('error', 'No items selected!');
            return;
        }

        Downloadsetings::whereIn('id', $this->selectedIds)->delete();

        $this->selectedIds = [];
        $this->selectAll = false;
        $this->emit('noteAdded');
        $this->alert('success', 'Itens selecionados deletado com sucesso!');
        $this->emit('success', 'Itens selecionados deletado com sucesso!');
    }

    public function resetComponentState()
    {
        $this->reset(['search', 'delete', 'slug', 'filter', 'page', 'selectedIds', 'selectAll']);
    }

//    public function render()
//    {
//        $user = Auth::user();
//        
//        $models = $this->readyToLoad
//            ? Downloadsetings::query()
//                ->when($user->role == 3 || $user->role == 0, function ($query) {
//                    $query->orderByDesc('created_at');
//                })
//                ->when(!isset($user->role), function ($query) use ($user) {
//                    $userr = User::where("id", $user->id)->first();
//                    $query->orWhere("type", "all")
//                        ->orWhere("class_id", $userr->classroom_id)
//                        ->orderByDesc('created_at');
//                })
//                ->paginate(10)
//            : [];
//
//        return view('livewire.admin.downloadcenter.downloads', compact('models'));
//
//    }
    
    public function render()
    {
        $user = Auth::user();

        $models = $this->readyToLoad
            ? Downloadsetings::with('download') // Aqui carrega a relação
                ->whereHas('download', function ($query) {
                    $query->whereNull('deleted_at'); // Garante que o ficheiro não está deletado
                })
                ->when($user->role == 3 || $user->role == 0, function ($query) {
                    $query->orderByDesc('created_at');
                })
                ->when(!isset($user->role), function ($query) use ($user) {
                    $userr = User::where("id", $user->id)->first();
                    $query->where(function ($subQuery) use ($userr) {
                        $subQuery->where("type", "all")
                            ->orWhere("class_id", $userr->classroom_id);
                    })->orderByDesc('created_at');
                })
                ->paginate(10)
            : [];

        return view('livewire.admin.downloadcenter.downloads', compact('models'));
    }


}
