<?php

namespace App\Http\Livewire\Admin\Fee;

use App\Models\Admin;
use App\Models\FeeGroup;
use App\Models\FeeType;
use App\Models\FeeMaster1;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;
use App\Models\FeeStructure;

class AddFeeMaster extends Component
{
    use FindGuard, LivewireAlert;
    public $fees_group, $fees_type, $due_date, $amount, $percentage, $fixed_amount;
    public $fine_type = 'none';
    public $validatedData;
    public $updateMode = false;

    public $monthly_fee_grade_1_6, $monthly_fee_grade_7_12, $fee_name, $late_penalty_percentage, $payment_start_day, $payment_due_day,$penalty_type;
    public $active = 0;
    // To hold the fee structures for listing
    public $feeStructures;
    public $months = []; // New property to hold selected months
    public $grades = [];
    // List of listeners for confirmation dialogs
    protected $listeners = [
        'confirmed',
        'cancelled'
    ];


    protected $rules = [
        'fee_name' => 'required|string|max:255',
        'monthly_fee_grade_1_6' => 'required|numeric',
        'monthly_fee_grade_7_12' => 'required|numeric',
        'late_penalty_percentage' => 'required|numeric',
        'payment_start_day' => 'required|integer',
        'payment_due_day' => 'required|integer',
        'active' => 'required|boolean',
         'months' => 'required|array', // Validation rule for months
        'grades' => 'required|array', // Validation rule for grades
        'penalty_type' => 'required',
    ];

    /**
     * Perform real-time validation on updated properties
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName); // Validate each property as it is updated
    }

    /**
     * Validate and submit the form data
     */
    public function submit()
    {
        // Validate the form data
        $this->validatedData = $this->validate();

        // If the data is validated successfully, confirm before creating
        if ($this->validatedData) {
            // dd($this->validatedData);
            $this->confirm('Tem certeza de que deseja prosseguir?', [
                'toast' => false,
                'position' => 'center',
                'showConfirmButton' => true,
                'confirmButtonText' => 'Sim, eu tenho certeza!',
                'cancelButtonText' => 'Não, cancelar!',
                'onConfirmed' => 'confirmed',
                'onDismissed' => 'cancelled'
            ]);
        }
    }

    /**
     * Create a new FeeMaster record in the database after confirmation
     */
    public function confirmed()
    {
        // Create a new FeeMaster entry in the database
        FeeMaster1::create([
            'fee_group_id' => $this->fees_group,
            'fee_type_id' => $this->fees_type,
            'due_date' => $this->due_date,
            'amount' => $this->amount,
            'fine_type' => $this->fine_type,
            'percentage' => $this->fine_type === 'percentage' ? $this->percentage : null,
            'fixed_amount' => $this->fine_type === 'amount' ? $this->fixed_amount : null,
        ]);

        // Create a system notification for the Admin model
        Note::createSystemNotification(Admin::class, 'Novo Plano de Taxas', 'Novo plano de taxas criado com sucesso: ' . $this->fees_type);

        // Emit event and alert to notify about the successful creation
        $this->emit('noteAdded');
        $this->alert('success', 'Novo plano de taxas criado com sucesso: ' . $this->fees_type);

        // Reset the form fields after successful submission
        $this->reset();
    }

    public function store()
    {
         $this->alert('success', 'submit click');
        // Validate the inputs
       
        $this->alert('success', 'submit click2');
        // Store the fee structure
        FeeStructure::create([
            'fee_name' => $this->fee_name,
            'grade' => 0,
            'monthly_fee' => $this->monthly_fee_grade_7_12,
            'late_penalty_percentage' => $this->late_penalty_percentage,
            'payment_start_day' => $this->payment_start_day,
            'payment_due_day' => $this->payment_due_day,
            'active' => $this->active,
            'months' => implode(",",$this->months), // Store selected months as JSON
            'grades' => implode(",",$this->grades),
            'penalty_type' => $this->penalty_type,
        ]);
        $this->alert('success', 'submit click3');
        // Reset fields
        $this->reset();

        // Refresh the list
        $this->feeStructures = FeeStructure::active()->get();

        // Show success message
        $this->alert('success', 'Fee Structure Created Successfully!');
    }


    /**
     * Handle cancelled confirmation action
     */
    public function cancelled()
    {
        // Alert the user about the cancellation
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        return view('livewire.admin.fee.add-fee-master', [
            'FeeGroups' => FeeGroup::all(),
            'FeeTypes' => FeeType::all(),
        ]);
    }

}
