<?php

namespace App\Http\Livewire\Admin\Noticeboard;

use App\Models\Admin;
use App\Models\Classroom;
use App\Models\User;
use App\Models\Noticeboard;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;
use App\Http\Controllers\SystemController;
use App\Http\Controllers\PushNotificationController;
use App\Models\Category;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\Auth;
use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;
use Illuminate\Support\Facades\Log;
use Kreait\Firebase\Exception\Messaging\NotFound;

class AddNotice extends Component
{
    use FindGuard, LivewireAlert, WithFileUploads;

    public $title, $description, $category_id, $photo,$pdf,$author,  $validatedData, $type, $class_id, $student_id, $created_by;
    public $updateMode = false;
    public $user;
    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    protected array $rules = [
        'title' => ['required', 'string', 'max:255'],
        //'photo' => ['required'], // 2MB Max
        //'pdf' => ['required', 'mimes:pdf'], // 2MB Max
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);

    }

    public function submit()
    {
    $this->validatedData = $this->validate();
    // Retrieve the currently logged-in user
    $user = Auth::user();
    // Define a mensagem padrão
    $this->message = 'Novo comunicado: "' . $this->title . '" foi lançado.';

    // Ensure the user is not null
    if (!$user) {
        $this->alert('error', 'Usuário não autenticado.');
        return;
    }

        $details = SystemController::store_media($this->photo);
        //$pdfd = SystemController::store_media($this->pdf);
        if(empty($this->type)){
            $this->type = "all";
        }
        $downloadcenter = Noticeboard::query()->create([
            'title' => $this->title,
            'media_name'=> $details[0],
            'media_url'=>$details[1],
            'type'=>$this->type,
            'class_id'=> $this->class_id,
            'student_id'=>$this->student_id,
            'created_by'=>$user->id,
        ]);

        Note::createSystemNotification(Admin::class, 'Novo comunicado', 'Novo comunicado adicionado com sucesso ' . $this->title);       
        $this->emit('noteAdded');
        $this->alert('success', 'Novo comunicado adicionado com sucesso ' . $this->title);

        // Check the type of notification
        if ($this->type == 'all') {
        // Send notification to all users
        $users = User::whereHas('deviceTokens')->get();
        $this->sendNotifications($users);

    
        } elseif ($this->type == 'class') {
        // Send notification to all students in the specified class
        $users = User::where('classroom_id', $this->class_id)->get();
        $this->sendNotifications($users);
    
        } elseif ($this->type == 'student') {
        // Send notification to a specific student
        $user = User::find($this->student_id);

     if ($user) {
        $this->sendNotifications([$user]);
       }
    }
    
     // Reset fields and flash success message
     $this->reset(['title', 'photo', 'type', 'class_id', 'student_id', 'created_by']);
     session()->flash('success', 'Push notification sent successfully.');
    }

    public function confirmed()
    {

        
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }
    public function render()
    {
        if(!empty($this->type)){
            return view('livewire.admin.noticeboard.add-notice', [
                'Classroom' => Classroom::query()->orderBy('class')->get(),
                'students' => User::Where("classroom_id",$this->class_id)->get(),
            ]);
        }else{
            return view('livewire.admin.noticeboard.add-notice', [
                'Classroom' => Classroom::query()->orderBy('class')->get(),
            ]);
        }
    }


    private function sendNotifications($users)
    {
        // Your Firebase credentials (make sure to securely store your private key)
        $firebaseCredentials = [
            "type"=> "service_account",
            "project_id"=> "copmoz-3x",
            "private_key_id"=> "bb9e045f0e2345c069b299a14636203509899ef8",
            "private_key"=> "-----BEGIN PRIVATE KEY-----\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDYfKrqJJyR6/8w\nP0NI75wA0OMzBMq53JD0GX/2G488VD2gE+Wbxt90e/6PUGdrOEwo7C+ilCNKsoX7\nzyy6l6kOt6MgVjO39bc7/qwaKYcA05/48grMrLMUxb6SNAMmKmj3CTQ9dU/zAmqA\n96HleqAkHt22wRSQ8hy4qg44CC1f8faBJxGb68YeMm9TmoYcdUhc7QT13JoMRZjl\nbi5gNDVIFWDyUhXeVpvw13Z3Sfo+EgkiT2Tb2Nr8//rptIabmrhzUsAFTEKnHblh\nY+1nsxBBwImu1NRtr5aQUCNLUZXcbWpuoym6EZtCLe3u6/mL3wI05407q1YqpUOq\nppfDwuHdAgMBAAECggEAMuv0Kfotp/dKgddHpObTm6+G2a/VXa2fnQNIgaPO5+Jq\n0nYLqr43PoeSA7TmdqZ556BSvhu5R29Bq876FvPojLEuWkNci/dsv9xyL/83pb6h\noOWSG729q/OtlWdNnFMaeI0+L/yhrygQ1EArYTacZ5KpFT1KcKO6lMdPa+ekgK4T\nPuwGVD/3VDFG9AWCEm+v3w6bQAhpKbdZiBPpGvTrfFHYov97/Yzv/iC3599VnW+i\no3GweFGaqsOn4PxuyIyYujzgoIc6kBrivUV+ddxZqLufrsQL1uE78SuWjhRNS8/k\n5rUD3Qvaj3BOQzkqCnttclfPZYSmbjMtVyLOMjMcQQKBgQDkE1SnrhY/dZF5QCFg\nIMaf7wkPLLCSStugOeYMGx2oeD0MxaY9L9N1ffRLekngffzANrO/ybE7AlRzgBJB\n2NYFd7fueihmrWuTpMafkBivG+mf+HdTjkxF0aQfYUL+MMW7viBBzGDbwckRSTX5\n5pSqzEHmRvctiLTfHqqgUnDeIQKBgQDy/hzbdteqvgqRok7KoXy3ciij4SQbDOQZ\n19KcmMTFgMiT/xm/3uni924Qw82VVSYQjDbAoSltTl7cpvtkXzSB2LIg00YEhfcE\nj/atYfswDIBYBAGCUZDalOn6s/8TWuTGVfCkQVwHA2Xa3rKqIrI1gHTuu5N4J/P4\niCmL3Vd0PQKBgQC1mirC5Rvz5ZIywHySxSZCfJtzCLuDkLV1zAQ/yWuBFFRQEiS+\n/ZDbMbJOUw32AXs6NZREdr125fEGkoh3A8fOTLgY3A3FS/qncgFxVdRBwfDxHm8t\nCdXzleyfy9sC+STIy6d1nN3WvWNzLx8aX54qrT8fs4vnJr4WFp330Azs4QKBgQCc\nnDj/Hb5sdmWbbW+425HlLfeRf+bkZE+TdG1yrmeMH6+m6zCuYD6AIRbYSUp0J9gL\nrEMRrg1kPLGZJyo5i77svTw5OdIT0j/dueez4cWiNzx0/cf3NRjWOEoBYgdRczCl\nv/gD9XgZsQ/xm7ytOQWAxBUZVN38AEwW77NPSM43xQKBgCgCmFCO57u8Fc6d+4G9\nBy/Vfmy3tZpwGCTGqxkwhFvG+qXZTERJOwRg4jejIM/W6iQlOPmfsis2CWhCZvYL\nSimfvuVeWSVixdnsxVpjVyyT7ci9jMhPXeL7LtMCjNF4hB34qgejqpkwh62Zqg0h\nNuy5ZdoARi0VwY/spf6HK03b\n-----END PRIVATE KEY-----\n",
            "client_email"=>"firebase-adminsdk-as4sm@copmoz-3x.iam.gserviceaccount.com",
            "client_id"=> "112030584520787629755",
            "auth_uri"=> "https://accounts.google.com/o/oauth2/auth",
            "token_uri"=> "https://oauth2.googleapis.com/token",
            "auth_provider_x509_cert_url"=> "https://www.googleapis.com/oauth2/v1/certs",
            "client_x509_cert_url"=> "https://www.googleapis.com/robot/v1/metadata/x509/firebase-adminsdk-as4sm%40copmoz-3x.iam.gserviceaccount.com",
            "universe_domain"=> "googleapis.com"
        ];
        
        $factory = (new Factory)->withServiceAccount($firebaseCredentials);
        $messaging = $factory->createMessaging();
    
        foreach ($users as $user) {
            $tokens = $user->deviceTokens()->pluck('token');
            
            foreach ($tokens as $token) {
                try {
                    if (strlen($token) >= 152) {
                        $notification = Notification::fromArray([
                            'token' => $token,
                            'title' => $this->title,
                            'body' => $this->message,
                            'image' => null,
                        ]);
    
                        $message = CloudMessage::withTarget('token', $token)
                            ->withNotification($notification)
                            ->withHighestPossiblePriority()
                            ->withDefaultSounds();
                        $messaging->send($message);
                    } else {
                        Log::channel('log_notifications')->error("Invalid token for user: {$user->name} - Token: $token. Notification not sent.");
                    }
                } catch (NotFound $e) {
                    Log::channel('log_notifications')->error("{$user->name} - Token not found: {$e->getMessage()}");
                } catch (\Exception $e) {
                    Log::channel('log_notifications')->error("An error occurred: {$e->getMessage()}");
                }
            }
        }
    }
}
