<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BmepsConfig extends Model
{
    protected $table = 'bmeps_configs';

    protected $fillable = [
        'sftp_host',
        'sftp_port',
        'sftp_username',
        'sftp_password',
        'sftp_private_key',
        'sftp_remote_path',
        'sftp_local_path',
        'auto_download_enabled',
        'download_schedule',
        'download_hours_limit',
        'move_processed_files',
        'last_download_at',
        'auto_reconcile_enabled',
        'reconcile_tolerance_amount',
        'email_notifications',
        'notification_emails',
        'notify_on_new_files',
        'notify_on_reconciliation_errors',
        'file_retention_days',
        'auto_cleanup_enabled',
    ];

    protected $casts = [
        'sftp_port' => 'integer',
        'auto_download_enabled' => 'boolean',
        'move_processed_files' => 'boolean',
        'last_download_at' => 'datetime',
        'auto_reconcile_enabled' => 'boolean',
        'reconcile_tolerance_amount' => 'decimal:2',
        'email_notifications' => 'boolean',
        'notify_on_new_files' => 'boolean',
        'notify_on_reconciliation_errors' => 'boolean',
        'file_retention_days' => 'integer',
        'auto_cleanup_enabled' => 'boolean',
    ];
}