# Cleanup Duplicate Exams

### 1. AnalyzeDuplicateExams - For Analysis
- Analyze all duplicates for current year
```bash
php artisan exams:analyze-duplicates
```
- Show detailed analysis with full breakdown
```bash
php artisan exams:analyze-duplicates --show-details
```
- Analyze specific year
```bash
php artisan exams:analyze-duplicates --year=2024
```
- Filter by specific student, subject, or trimester
```bash
php artisan exams:analyze-duplicates --student-id=STUDENT_ID --show-details
php artisan exams:analyze-duplicates --subject-id=SUBJECT_ID --show-details
php artisan exams:analyze-duplicates --trimester-id=1 --show-details
```

### 2. ImprovedCleanupDuplicateExams - For Smart Cleanup

#### Basic Usage
- Dry run to see what would be deleted (recommended first)
```bash
php artisan exams:cleanup-smart --dry-run
```

- Keep the record with most complete marks (default)
```bash
php artisan exams:cleanup-smart --keep-strategy=complete
```

- Keep the latest record
```bash
php artisan exams:cleanup-smart --keep-strategy=latest
```

- Interactive mode for manual review of conflicts
```bash
php artisan exams:cleanup-smart --keep-strategy=ask
```

- Force cleanup without confirmation
```bash
php artisan exams:cleanup-smart --force
```

#### With Filters (NEW)
- Filter by specific student
```bash
php artisan exams:cleanup-smart --student-id=STUDENT_ID --dry-run
```

- Filter by specific subject
```bash
php artisan exams:cleanup-smart --subject-id=SUBJECT_ID --dry-run
```

- Filter by specific trimester
```bash
php artisan exams:cleanup-smart --trimester-id=1 --dry-run
```

- Combine multiple filters
```bash
php artisan exams:cleanup-smart --student-id=STUDENT_ID --subject-id=SUBJECT_ID --trimester-id=1 --dry-run
```

- Filter by specific year with other filters
```bash
php artisan exams:cleanup-smart --year=2024 --student-id=STUDENT_ID --dry-run
```

#### Recommended Workflow
1. First analyze to understand the scope:
```bash
php artisan exams:analyze-duplicates --show-details
```

2. Test cleanup with dry-run (general):
```bash
php artisan exams:cleanup-smart --dry-run
```

3. Test cleanup for specific problematic areas:
```bash
php artisan exams:cleanup-smart --student-id=PROBLEM_STUDENT_ID --dry-run
```

4. Execute actual cleanup (start with specific filters if needed):
```bash
php artisan exams:cleanup-smart --student-id=PROBLEM_STUDENT_ID
```

5. Then do general cleanup:
```bash
php artisan exams:cleanup-smart
```

#### Filter Options Summary
- `--year=YYYY` - Filter by academic year (defaults to current year)
- `--student-id=ID` - Filter by specific student ID
- `--subject-id=ID` - Filter by specific subject ID
- `--trimester-id=N` - Filter by trimester (1, 2, or 3)
- `--dry-run` - Preview changes without executing
- `--force` - Skip confirmation prompt
- `--keep-strategy=STRATEGY` - Strategy for selecting record to keep:
    - `complete` (default) - Keep record with most marks
    - `latest` - Keep most recently updated record
    - `ask` - Manual review for conflicts
