<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Configurações de Pagamento
    |--------------------------------------------------------------------------
    |
    | Configurações para o sistema de pagamentos por referência
    |
    */

    // Entidade para pagamentos por referência (ex: M-Pesa, e-Mola)
    'entity' => env('PAYMENT_ENTITY', '90013'),

    // Dias para expiração da referência
    'reference_ttl_days' => env('PAYMENT_REFERENCE_TTL_DAYS', 3),

    // Configurações do PDF
    'pdf' => [
        'orientation' => 'portrait',
        'paper_size' => 'a4',
        'margin' => [
            'top' => 15,
            'bottom' => 15,
            'left' => 10,
            'right' => 10,
        ],
    ],

    // Modos de pagamento disponíveis
    'payment_modes' => [
        'Reference' => 'Entidade e Referência',
        'MPesa' => 'M-Pesa',
        'eMola' => 'e-Mola',
        'Cash' => 'Dinheiro',
        'Transfer' => 'Transferência Bancária',
        'Card' => 'Cartão',
    ],

    // Configurações de multa
    'late_payment' => [
        'default_due_day' => 5, // Dia do mês para vencimento
        'default_penalty_type' => 'percentage', // 'fixed' ou 'percentage'
        'default_penalty_amount' => 5, // 5% ou valor fixo
    ],
];
