<?php

namespace Database\Factories;

use App\Models\Classroom;
use App\Models\Exam;
use App\Models\Subject;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class ExamFactory extends Factory
{
    protected $model = Exam::class;

    public function definition(): array
    {
        return [
            'student_id' => User::factory(),
            'subject_id' => Subject::factory(),
            'classroom_id' => Classroom::factory(),
            'trimester_id' => $this->faker->numberBetween(1, 3),
            'year' => $this->faker->year(),
            'ACS1a' => $this->faker->randomFloat(2, 0, 20),
            'ACS2a' => $this->faker->randomFloat(2, 0, 20),
            'AT' => $this->faker->randomFloat(2, 0, 20),
            'NE' => $this->faker->randomFloat(2, 0, 20),
            'MACS' => function (array $attributes) {
                return round(($attributes['ACS1a'] + $attributes['ACS2a']) / 2, 2);
            },
            'MT' => function (array $attributes) {
                return round(($attributes['ACS1a'] + $attributes['ACS2a'] + $attributes['AT']) / 3, 2);
            },
        ];
    }
}
