<?php
$class_id = "";
$mfd_count = 0;
$get_class = "";
$subjects_get = array();

// Obter a classe e suas disciplinas
foreach ($models as $model) {
    $classroom = \App\Models\Classroom::query()->where("id", $model->classroom_id)->first();
    if ($classroom) {
        $get_class = $classroom->class ?? 0;

        // Buscar disciplinas atribuídas à classe do estudante
        $query_subjects = \App\Models\TeacherSubject::query()->where("classroom_id", $model->classroom_id)->get();
        foreach ($query_subjects as $subject_relation) {
            $subject = \App\Models\Subject::query()->where("id", $subject_relation->subject_id)->first();
            if ($subject) {
                $subjects_get[$subject->name] = $subject->id;
            }
        }
        $class_id = $get_class;
    }
    if ($class_id != 0) {
        break;
    }
}

// Disciplinas com notas de exame baseadas na classe
$ne_subjects3 = array("Português", "Matemática");
$ne_subjects6 = array("Português", "Matemática", "História", "Geografia", "Física", "Química", "Biologia", "Ciências naturais", "Ciências sociais", "Filosofia");
$ne_subjects = array("Português", "Matemática", "Inglês", "História", "Geografia", "Física", "Química", "Biologia", "Ciências naturais", "Ciências sociais", "Filosofia");

// Determinar quais disciplinas pertencem à classe atual
if ($class_id == 3) {
    $current_ne_subjects = $ne_subjects3;
} elseif ($class_id == 6) {
    $current_ne_subjects = $ne_subjects6;
} elseif (in_array($class_id, [10, 12])) {
    $current_ne_subjects = $ne_subjects;
} else {
    $current_ne_subjects = [];
}

// Determinar se a coluna NE/AF deve ser exibida
$show_ne_column = in_array($class_id, [3, 6, 10, 12]);

// Disciplinas da classe
$subjects = $subjects_get;
$divide = count($subjects);
?>


<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title">Notas do estudante</h5>
                            <div class="row">
                                <div class="col-md-4">
                                    <select wire:model="search" class="form-control">
                                        <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($value); ?>"><?php echo e($label); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="table-responsive">
                                        <?php if(count($models)): ?>
                                            <table class="table table-hover">
                                                <thead>
                                                    <!-- Cabeçalho Principal -->
                                                    <tr>
                                                        <th colspan="5" style="border-right: 2px solid black;"><b>Primeiro Trimestre</b></th>
                                                        <th colspan="4" style="border-right: 2px solid black;"><b>Segundo Trimestre</b></th>
                                                        <th colspan="5" style=""><b>Terceiro Trimestre</b></th>
                                                    </tr>

                                                    <!-- Subcabeçalho -->
                                                    <tr>
                                                        <th scope="col">Disciplina</th>
                                                        <!-- Primeiro Trimestre -->
                                                        <th scope="col">ACS1</th>
                                                        <th scope="col">ACS2</th>
                                                        <th scope="col">AT</th>
                                                        <th scope="col">MT</th>

                                                        <!-- Segundo Trimestre -->
                                                        <th scope="col">ACS1</th>
                                                        <th scope="col">ACS2</th>
                                                        <th scope="col">AT</th>
                                                        <th scope="col">MT</th>

                                                        <!-- Terceiro Trimestre -->
                                                        <th scope="col">ACS1</th>
                                                        <th scope="col">ACS2</th>
                                                        <th scope="col">AT</th>
                                                        <th scope="col" >MT</th>
                                                        <?php if($show_ne_column): ?>
                                                            <th scope="col"><?php echo e($class_id == 3 ? 'AF' : 'NE'); ?></th>
                                                        <?php endif; ?>
                                                    </tr>
                                                </thead>
                                                    <tbody>
                                                        <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <!-- Nome da Disciplina -->
                                                                <td><?php echo e(optional($model->subject)->name ?? 'N/A'); ?></td>
                                                    
                                                                <!-- Primeiro Trimestre -->
                                                                <td><?php echo e(number_format($model->ACS1a ?? 0, 2)); ?></td>
                                                                <td><?php echo e(number_format($model->ACS2a ?? 0, 2)); ?></td>
                                                                <td><?php echo e(number_format($model->AT ?? 0, 2)); ?></td>
                                                                <td><?php echo e(round((($model->ACS1a ?? 0) + ($model->ACS2a ?? 0) + ($model->AT ?? 0)) / 3)); ?></td>
                                                    
                                                                <!-- Segundo Trimestre -->
                                                                <?php ($exam_second = \App\Models\Exam::query()
                                                                    ->where('trimester_id', 2)
                                                                    ->where('classroom_id', $model->classroom_id)
                                                                    ->where('subject_id', $model->subject_id)
                                                                    ->where('student_id', $model->student_id)
                                                                    ->first()); ?>
                                                                <td><?php echo e(number_format($exam_second->ACS1a ?? 0, 2)); ?></td>
                                                                <td><?php echo e(number_format($exam_second->ACS2a ?? 0, 2)); ?></td>
                                                                <td><?php echo e(number_format($exam_second->AT ?? 0, 2)); ?></td>
                                                                <td><?php echo e(round((($exam_second->ACS1a ?? 0) + ($exam_second->ACS2a ?? 0) + ($exam_second->AT ?? 0)) / 3)); ?></td>
                                                    
                                                                <!-- Terceiro Trimestre -->
                                                                <?php ($exam_third = \App\Models\Exam::query()
                                                                    ->where('trimester_id', 3)
                                                                    ->where('classroom_id', $model->classroom_id)
                                                                    ->where('subject_id', $model->subject_id)
                                                                    ->where('student_id', $model->student_id)
                                                                    ->first()); ?>
                                                                <td><?php echo e(number_format($exam_third->ACS1a ?? 0, 2)); ?></td>
                                                                <td><?php echo e(number_format($exam_third->ACS2a ?? 0, 2)); ?></td>
                                                                <td><?php echo e(number_format($exam_third->AT ?? 0, 2)); ?></td>
                                                                <td><?php echo e(round((($exam_third->ACS1a ?? 0) + ($exam_third->ACS2a ?? 0) + ($exam_third->AT ?? 0)) / 3)); ?></td>
                                                                
                                                                <!-- Condição para pintar NE/AF em preto -->
                                                                <!-- NE/AF -->
                                                                    <?php if($show_ne_column): ?>
                                                                        <?php if(in_array(optional($model->subject)->name, $current_ne_subjects)): ?>
                                                                            <td><?php echo e(number_format($exam_third->NE ?? 0, 2)); ?></td>
                                                                        <?php else: ?>
                                                                            <td style="background-color: black; color: white;">N/A</td>
                                                                        <?php endif; ?>
                                                                    <?php endif; ?>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>

                                            </table>

                                            <!-- Exibição do Resultado -->
                                            <h3 style="text-align:center;">RESULTADO</h3>
                                            <?php ($mfd_count = 0); ?>
                                            <?php ($subject_count = 0); ?>
                                            <?php ($reprovado_por_mt = false); ?>

                                            <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php ($mfd_count += round((($model->ACS1a ?? 0) + ($model->ACS2a ?? 0) + ($model->AT ?? 0)) / 3, 2)); ?>
                                                <?php ($subject_count++); ?>
                                            
                                                
                                                <?php if(optional($model->subject)->name === 'Matemática' && optional($model->subject)->name === 'Português'): ?>
                                                    <?php ($mt_value = round((($model->ACS1a ?? 0) + ($model->ACS2a ?? 0) + ($model->AT ?? 0)) / 3, 2)); ?>
                                                    <?php if($mt_value < 10): ?>
                                                        <?php ($reprovado_por_mt = true); ?>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            
                                            <?php ($result = $subject_count > 0 ? round($mfd_count / $subject_count, 2) : 0); ?>
                                            <h3 style="text-align:center;">
                                                <?php if($reprovado_por_mt): ?>
                                                    <span style="color: red;"><?php echo e($class_id == 3 || $class_id == 6 || $class_id == 10 || $class_id == 12 ? 'REPROVADO' : 'NÃO TRANSITA'); ?></span>
                                                <?php elseif($result <= 9): ?>
                                                    <span style="color: red;"><?php echo e($class_id == 3 || $class_id == 6 || $class_id == 10 || $class_id == 12 ? 'REPROVADO' : 'NÃO TRANSITA'); ?></span>
                                                <?php else: ?>
                                                    <span style="color: green;"><?php echo e($class_id == 3 || $class_id == 6 || $class_id == 10 || $class_id == 12 ? 'APROVADO' : 'TRANSITA'); ?></span>
                                                <?php endif; ?>
                                            </h3>
                                            <h3 style="text-align:center;">MF: <?php echo e(round($result)); ?></h3>

                                        <?php else: ?>
                                            <p class="text-center"><b>Nenhum dado foi encontrado no momento.</b></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/livewire/user/exams/student-list-exams.blade.php ENDPATH**/ ?>