<?php
/**
 * -----------------------------------------------------------------
 * NOTE : There is two routes has a name (user & group),
 * any change in these two route's name may cause an issue
 * if not modified in all places that used in (e.g Chatify class,
 * Controllers, chatify javascript file...).
 * -----------------------------------------------------------------
 */

use Illuminate\Support\Facades\Route;

/*
* This is the main app route [Chatify Messenger]
*/
Route::get('/', 'MessagesController@index');

/**
 *  Fetch info for specific id [user/group]
 */
Route::post('/idInfo', 'MessagesController@idFetchData');

/**
 * Send message route
 */
Route::post('/sendMessage', 'MessagesController@send');

/**
 * Fetch messages
 */
Route::post('/fetchMessages', 'MessagesController@fetch');

/**
 * Download attachments route to create a downloadable links
 */
Route::get('/download/{fileName}', 'MessagesController@download');

/**
 * Authentication for pusher private channels
 */
Route::post('/auth', 'MessagesController@pusherAuth');

/**
 * Make messages as seen
 */
Route::post('/makeSeen', 'MessagesController@seen');
/**
 * Get channel_id by user_id
 */
Route::post('/get-channel-id', 'MessagesController@getChannelId');

/**
 * Get contacts
 */
Route::get('/getContacts', 'MessagesController@getContacts');

/**
 * Update contact item data
 */
Route::post('/updateContacts', 'MessagesController@updateContactItem');


/**
 * Star in favorite list
 */
Route::post('/star', 'MessagesController@favorite');

/**
 * get favorites list
 */
Route::post('/favorites', 'MessagesController@getFavorites');

/**
 * Search in messenger
 */
Route::get('/search', 'MessagesController@search');
 
/**
 * Get shared photos
 */
Route::post('/shared', 'MessagesController@sharedPhotos');

/**
 * Delete Conversation
 */
Route::post('/deleteConversation', 'MessagesController@deleteConversation');

/**
 * Delete Message
 */
Route::post('/deleteMessage', 'MessagesController@deleteMessage');

/**
 * Update setting
 */
Route::post('/updateSettings', 'MessagesController@updateSettings');

/**
 * Set active status
 */
Route::post('/setActiveStatus', 'MessagesController@setActiveStatus');

Route::get('/search-users', 'MessagesController@searchUsers');

/**
 * Group Chat
 */
Route::prefix('group-chat')->group(function () {
    Route::post('/create', 'MessagesController@createGroupChat');
    Route::post('/delete', 'MessagesController@deleteGroupChat');
    Route::post('/leave', 'MessagesController@leaveGroupChat');
});


/**
 * Channel id
 */
Route::get('/{channel_id}', 'MessagesController@index')->name('channel_id');

 