<?php

namespace App\Http\Livewire\Admin\Classes;

use App\Jobs\MailJob;
use App\Models\Admin;
use App\Models\Classroom;
use App\Models\Exam;
use App\Models\Student;
use App\Models\Subject;
use App\Models\Trimester;
use App\Models\User;
use Illuminate\Validation\Rule;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;

class ModalExam extends Component
{
    protected $lazy = false;
    use FindGuard, LivewireAlert;

    public  $model, $user;
    public $student_id, $subject_id, $trimester_id, $ASC, $type, $MACS;

    public $validatedData;
    public $updateMode = false;

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    protected array $rules = [
        'subject_id' => ['required', 'string', 'max:255'],
        'trimester_id' => ['required', 'numeric', 'max:255'],
        'MACS' => ['required', 'numeric', 'min:0', 'max:20'],
        'type' => ['required', 'numeric', 'max:255'],
        'year' => ['required', 'numeric', 'max:4'],
    ];
    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }
    public function submit()
    {
        $this->validatedData = $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }
    public function confirmed()
    {
 	$year = date("Y");
        // Check if a record with the same subject_id, trimester_id, and classroom exists
        $existingRecord = Exam::where('subject_id', $this->subject_id)
            ->where('trimester_id', $this->trimester_id)
            ->where('student_id', $this->model->id)
            ->where('classroom_id', $this->model->classroom_id)
            ->first();

        if ($existingRecord) {
             // Only update the year if it's not from the previous year
             if ($existingRecord->year != $year - 1) {
                $existingRecord->year = $year;
            }         

            // Update the existing record based on the selected type
            if ($this->type == 1) {
                if ($existingRecord->ACS1a <= 0) {
                    $existingRecord->ACS1a = $this->MACS;
                } else {
                    // ACS1a has values greater than 0, do not update
                    $this->alert('warning', 'Você não tem o permissão de atualizar o registro ASC1');
                    return back();
                }
            } elseif ($this->type == 2) {
                if ($existingRecord->ACS2a <= 0) {
                    $existingRecord->ACS2a = $this->MACS;
                } else {
                    // ACS1a has values greater than 0, do not update
                    $this->alert('warning', 'Você não tem o permissão de atualizar o registro ASC2');
                    return back();
                }
            } elseif ($this->type == 3) {
                if ($existingRecord->AT <= 0) {
                    $existingRecord->AT = $this->MACS;
                } else {
                    // ACS1a has values greater than 0, do not update
                    $this->alert('warning', 'Você não tem o permissão de atualizar o registro AT');
                    return back();
                }
            }elseif ($this->type == 4) {
                if ($existingRecord->NE <= 0) {
                    $existingRecord->NE = $this->MACS;
                } else {
                    // ACS1a has values greater than 0, do not update
                    $this->alert('warning', 'Você não tem o permissão de atualizar o registro NE');
                    return back();
                }
            }
            $existingRecord->save();
            Note::createSystemNotification(Admin::class, 'Detalhes', $this->model->name . 'Nota atualizada com sucesso ');
            $this->emit('noteAdded');
            $this->alert('success', 'Nota atualizada com sucesso ' . $this->model->name);
            return back();
        } else {
            // Create a new record
            $newRecord = new Exam; // Replace 'YourModel' with your actual model name
            $newRecord->subject_id = $this->subject_id;
            $newRecord->student_id = $this->model->id;
            $newRecord->trimester_id = $this->trimester_id;
            $newRecord->classroom_id = $this->model->classroom_id;
		    $newRecord->year = $year; 
            if ($this->type == 1) {
                $newRecord->ACS1a = $this->MACS;
            } elseif ($this->type == 2) {
                $newRecord->ACS2a = $this->MACS;
            } elseif ($this->type == 3) {
                $newRecord->AT = $this->MACS;
            }elseif ($this->type == 4) {
                $newRecord->NE = $this->MACS;
            }
            $newRecord->save();
            Note::createSystemNotification(Admin::class, 'Detalhes', $this->model->name . 'Nota atualizada com sucesso ');
            $this->emit('noteAdded');
            $this->alert('success', 'Nota atualizada com sucesso' . $this->model->name);
            return back();
        }
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        $this->user = $this->findGuardType()->user();
        return view('livewire.admin.classes.modal-exam', [
            'classes' => Classroom::query()->orderBy('name')->get(),
            'trimesters' => Trimester::query()->orderBy('name')->get(),
            'subjects' => Subject::query()->orderBy('name')->whereRelation('teachersubject', 'teacher_id', '=', $this->user->id)->get(),
            'students' => Student::query()->orderBy('name')->get(),
        ]);
    }
}
