<?php

namespace App\Http\Livewire\Admin\Noticeboard;

use App\Models\Noticeboard;

use App\Models\User;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;
use Auth;

class Notice extends Component
{
    // Disable lazy loading for this component
    protected $lazy = false;
    use WithPagination, FindGuard, LivewireAlert;

    public $search, $delete,$slug;

    protected $queryString = ['search'];

    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function submit($id)
    {
        
        $this->delete = Noticeboard::query()->firstWhere('slug', $id);
        //dd($this->delete);
        //echo $id;echo $this->delete->slug; exit();
        $this->slug = $this->delete->slug;
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => "confirmed",
            'onDismissed' => 'cancelled',
            'slug'=>$id,
        ]);
    }

    public function confirmed()
    {
        //check if already enrolled
        //$check = Downloadcenter::query()->where('slug',  $this->delete->slug)->first();
        /*if (count($check) >= 1) {
            $this->alert('warning', 'Desculpe, este modelo tem subscritores.');
            return back();
        }*/
        //dd($this->delete,$this->slug);
        //echo $this->delete->slug;exit();
        Noticeboard::where('slug', $this->slug)->delete();
        
        Note::createSystemNotification(Admin::class, 'Turma', 'Deletado com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Deletado com sucesso ');
        return back();
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        /*$qq = Downloadcenter::with(['downloadsetings' => function ($query) {
            $query->where('active', "active");
        }])->get();*/
        $qq = Noticeboard::get();
        //dd($qq);
                           
        $user = Auth::user();
        //dd($user);
        
        if(isset($user->role) && $user->role == 0 || $user->role == 3){
            //echo "asd";
            return view('livewire.admin.noticeboard.notice', [
                    'models' => $this->readyToLoad
                        ? Noticeboard::query() ->orderByDesc('created_at')->paginate(10)
                        : []
                ]
            );
        }elseif(!isset($user->role) ){
            $userr = User::where("id",$user->id)->first();
           // echo "asd1";
            return view('livewire.admin.noticeboard.notice', [
                    'models' => $this->readyToLoad
                        ? Noticeboard::query()->orderByDesc('created_at')->orWhere("type","all")->orWhere("class_id",$userr->classroom_id)->paginate(10)
                        : [],
                    'student' => true,    
                ]
            );
        }
        
    }

//     public function render()
// {
//     // Get the current authenticated user
//     $user = Auth::user();

//     // Initialize an array for holding the view data
//     $viewData = [];

//     // Check the user's role
//     if (isset($user->role)) {
//         if ($user->role == 0) {
//             // Admin user, display all notices
//             $viewData['models'] = $this->readyToLoad
//                 ? Noticeboard::paginate(10)
//                 : [];
//         } elseif ($user->role == 3) {
//             // Academic department user, display only notices created by this user
//             $viewData['models'] = $this->readyToLoad
//                 ? Noticeboard::where('created_by', $user->id)
//                     ->paginate(10)
//                 : [];
//             // Optionally set a flag in the view data to identify the academic department user
//             $viewData['academic_department'] = true;
//         }
//     } else {
//         // Assuming the user is a student without a role set
//         $userr = User::where("id", $user->id)->first();
//         $viewData['models'] = $this->readyToLoad
//             ? Noticeboard::query()
//                 ->orWhere("type", "all")
//                 ->orWhere("class_id", $userr->classroom_id)
//                 ->paginate(10)
//             : [];
//         $viewData['student'] = true;
//     }

//     // Render the view with the data
//     return view('livewire.admin.noticeboard.notice', $viewData);
// }

}



