<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Atribuição de disciplina</h5>
                            <form class="row g-3" wire:submit.prevent="submit">
                                <div class="col-md-6">
                                    <label for="teacher_id" class="form-label">Professor</label>
                                    <select class="form-control @error('teacher_id') is-invalid @enderror"
                                            id="teacher_id" wire:model="teacher_id">
                                        <option value="">Selecionar professor</option>
                                        @foreach($teachers as $teacher)
                                            <option value="{{ $teacher->id }}">{{ $teacher->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('teacher_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="class" class="form-label">Classe</label>
                                    <select class="form-control @error('class') is-invalid @enderror" id="class"
                                            wire:model="class">
                                        <option value="">Por favor selecione a classe</option>
                                        @for ($i = 1; $i <= 12; $i++)
                                            <option value="{{ $i }}">{{ $i }}ª Classe</option>
                                        @endfor
                                    </select>
                                    @error('class')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <!-- <div class="col-md-6">
                                    <label for="classroom_id" class="form-label">Turma</label>
                                    <select class="form-control @error('classrooms.*') is-invalid @enderror"
                                            id="classroom_id" wire:model="classrooms" multiple>
                                        <option value="">Selecione a turma</option>
                                        @foreach ($classrooms as $classroom)
                                            <option value="{{ $classroom->id }}">{{ $classroom->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('classrooms.*')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div> -->

                                <div class="col-md-6">
                                    <label for="title" class="form-label">Turma</label>
                                    <select class="form-control @error('classroom_id') is-invalid @enderror"
                                        id="name" wire:model="classroom_id" class="form-control input-lg dynamic" multiple>
                                        <option value="">Selecione a turma</option>
                                        @foreach ($classrooms as $classroom)
                                            <option value="{{ $classroom->id }}"> {{ $classroom->name }} </option>
                                        @endforeach
                                    </select>
                                    @error('classroom_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>




                                <div class="col-md-6">
                                    <label for="subject_id" class="form-label">Disciplina</label>
                                    <select class="form-control @error('selectedSubjects.*') is-invalid @enderror"
                                            id="selectedSubjects" wire:model="selectedSubjects" multiple>
                                        <option value="">Selecione a disciplina</option>
                                        @foreach($subjects as $subject)
                                            <option value="{{ $subject->id }}">{{ $subject->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('selectedSubjects.*')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary btn-lg float-end"
                                            wire:loading.class="disabled"
                                            wire:offline.attr="disabled">
                                        <span wire:target="submit" wire:loading.class="spinner-border spinner-border-lg"></span>
                                        Guardar
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
