<?php

namespace App\Http\Livewire\Admin\Admins;

use App\Models\Admin;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;

class ListAdmins extends Component
{
    use WithPagination, FindGuard, LivewireAlert;

    public $search;
    public $selectedRole = '';
    public $selectedStatus = '';

    protected $queryString = ['search', 'selectedRole', 'selectedStatus'];

    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function updatedSelectedRole()
    {
        $this->resetPage();
    }

    public function updatedSelectedStatus()
    {
        $this->resetPage();
    }

    public function exportPDF()
    {
        return redirect()->route('admin.staff.export.pdf', [
            'search' => $this->search,
            'role' => $this->selectedRole,
            'status' => $this->selectedStatus
        ]);
    }

    public function exportExcel()
    {
        return redirect()->route('admin.staff.export.excel', [
            'search' => $this->search,
            'role' => $this->selectedRole,
            'status' => $this->selectedStatus
        ]);
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    public function render()
    {
        return view('livewire.admin.admins.list-admins', [
            'users' => $this->readyToLoad
                ? Admin::query()
                    ->latest('updated_at')
                    ->when($this->search, function ($query) {
                        $query->where(function ($q) {
                            $q->where('name', 'like', '%' . $this->search . '%')
                                ->orWhere('phone_number', 'like', '%' . $this->search . '%')
                                ->orWhere('email', 'like', '%' . $this->search . '%')
                                ->orWhere('slug', 'like', '%' . $this->search . '%');
                        });
                    })
                    ->when($this->selectedRole !== '', function ($query) {
                        $query->where('role', $this->selectedRole);
                    })
                    ->when($this->selectedStatus !== '', function ($query) {
                        $query->where('is_active', $this->selectedStatus);
                    })
                    ->paginate(10)
                : []
        ]);
    }
}
