<?php

namespace App\Http\Livewire\Admin\Noticeboard;

use App\Models\Noticeboard;

use App\Models\User;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;
use Auth;

class Notice extends Component
{

    use WithPagination, FindGuard, LivewireAlert;

    public $search, $delete, $slug;
    public $selectedType = '';
    public $selectedClass = '';
    public $selectedTurma = '';
    public $turmas = [];

    protected $queryString = ['search', 'selectedType', 'selectedClass', 'selectedTurma'];

    protected string $paginationTheme = 'bootstrap';

    public function exportPDF()
    {
        return redirect()->route('admin.comunicados.export.pdf', [
            'type' => $this->selectedType,
            'class' => $this->selectedClass,
            'turma' => $this->selectedTurma,
            'search' => $this->search
        ]);
    }

    public function exportExcel()
    {
        return redirect()->route('admin.comunicados.export.excel', [
            'type' => $this->selectedType,
            'class' => $this->selectedClass,
            'turma' => $this->selectedTurma,
            'search' => $this->search
        ]);
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function updatedSelectedType()
    {
        $this->resetPage();
    }

    public function updatedSelectedClass($value)
    {
        $this->selectedTurma = '';
        $this->resetPage();

        if ($value) {
            $this->turmas = \App\Models\Classroom::where('class', $value)->get();
        } else {
            $this->turmas = [];
        }
    }

    public function updatedSelectedTurma()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function submit($id)
    {
        
        $this->delete = Noticeboard::query()->firstWhere('slug', $id);
        //dd($this->delete);
        //echo $id;echo $this->delete->slug; exit();
        $this->slug = $this->delete->slug;
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => "confirmed",
            'onDismissed' => 'cancelled',
            'slug'=>$id,
        ]);
    }

    public function confirmed()
    {
        //check if already enrolled
        //$check = Downloadcenter::query()->where('slug',  $this->delete->slug)->first();
        /*if (count($check) >= 1) {
            $this->alert('warning', 'Desculpe, este modelo tem subscritores.');
            return back();
        }*/
        //dd($this->delete,$this->slug);
        //echo $this->delete->slug;exit();
        Noticeboard::where('slug', $this->slug)->delete();
        
        Note::createSystemNotification(Admin::class, 'Turma', 'Deletado com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Deletado com sucesso ');
        return back();
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        $user = Auth::user();

        // Buscar todas as classes para o filtro
        $classes = \App\Models\Classroom::select('class')->distinct()->orderBy('class')->get();

        if(isset($user->role) && ($user->role == 0 || $user->role == 3)){
            // Admin ou Academic Department - vê todos os comunicados
            return view('livewire.admin.noticeboard.notice', [
                    'models' => $this->readyToLoad
                        ? Noticeboard::query()
                            ->when($this->search, function ($query) {
                                $query->where('title', 'like', '%' . $this->search . '%');
                            })
                            // Filtro por Tipo
                            ->when($this->selectedType, function ($query) {
                                $query->where('type', $this->selectedType);
                            })
                            // Filtro por Classe
                            ->when($this->selectedClass, function ($query) {
                                $classroomIds = \App\Models\Classroom::where('class', $this->selectedClass)->pluck('id');
                                $query->whereIn('class_id', $classroomIds);
                            })
                            // Filtro por Turma específica
                            ->when($this->selectedTurma, function ($query) {
                                $query->where('class_id', $this->selectedTurma);
                            })
                            ->orderByDesc('created_at')
                            ->paginate(10)
                        : [],
                    'classes' => $classes
                ]
            );
        }elseif(!isset($user->role)){
            // Estudante - vê apenas comunicados para todos, sua classe, ou específicos para ele
            $userr = User::where("id", $user->id)->first();

            return view('livewire.admin.noticeboard.notice', [
                    'models' => $this->readyToLoad
                        ? Noticeboard::query()
                            ->where(function ($query) use ($userr) {
                                $query->where('type', 'all')
                                      ->orWhere('class_id', $userr->classroom_id)
                                      ->orWhere('student_id', $userr->id);
                            })
                            ->when($this->search, function ($query) {
                                $query->where('title', 'like', '%' . $this->search . '%');
                            })
                            // Filtro por Tipo
                            ->when($this->selectedType, function ($query) {
                                $query->where('type', $this->selectedType);
                            })
                            // Filtro por Classe
                            ->when($this->selectedClass, function ($query) {
                                $classroomIds = \App\Models\Classroom::where('class', $this->selectedClass)->pluck('id');
                                $query->whereIn('class_id', $classroomIds);
                            })
                            // Filtro por Turma específica
                            ->when($this->selectedTurma, function ($query) {
                                $query->where('class_id', $this->selectedTurma);
                            })
                            ->orderByDesc('created_at')
                            ->paginate(10)
                        : [],
                    'student' => true,
                    'classes' => $classes
                ]
            );
        }

    }

//     public function render()
// {
//     // Get the current authenticated user
//     $user = Auth::user();

//     // Initialize an array for holding the view data
//     $viewData = [];

//     // Check the user's role
//     if (isset($user->role)) {
//         if ($user->role == 0) {
//             // Admin user, display all notices
//             $viewData['models'] = $this->readyToLoad
//                 ? Noticeboard::paginate(10)
//                 : [];
//         } elseif ($user->role == 3) {
//             // Academic department user, display only notices created by this user
//             $viewData['models'] = $this->readyToLoad
//                 ? Noticeboard::where('created_by', $user->id)
//                     ->paginate(10)
//                 : [];
//             // Optionally set a flag in the view data to identify the academic department user
//             $viewData['academic_department'] = true;
//         }
//     } else {
//         // Assuming the user is a student without a role set
//         $userr = User::where("id", $user->id)->first();
//         $viewData['models'] = $this->readyToLoad
//             ? Noticeboard::query()
//                 ->orWhere("type", "all")
//                 ->orWhere("class_id", $userr->classroom_id)
//                 ->paginate(10)
//             : [];
//         $viewData['student'] = true;
//     }

//     // Render the view with the data
//     return view('livewire.admin.noticeboard.notice', $viewData);
// }

}



