<?php

namespace App\Http\Livewire\Admin\Sendsms;

use App\Models\SendSms;
use App\Models\User;
use App\Models\Admin;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;
use Auth;

class Sms extends Component
{
    protected $lazy = false;
    use WithPagination, FindGuard, LivewireAlert;

    public $search, $delete, $slug;
    public $selectedType = '';
    public $selectedClass = '';

    protected $queryString = ['search', 'selectedType', 'selectedClass'];
    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function updatedSelectedType()
    {
        $this->resetPage();
    }

    public function updatedSelectedClass()
    {
        $this->resetPage();
    }

    public function exportPDF()
    {
        return redirect()->route('admin.sms.export.pdf', [
            'search' => $this->search,
            'type' => $this->selectedType,
            'class' => $this->selectedClass
        ]);
    }

    public function exportExcel()
    {
        return redirect()->route('admin.sms.export.excel', [
            'search' => $this->search,
            'type' => $this->selectedType,
            'class' => $this->selectedClass
        ]);
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = ['confirmed', 'cancelled'];

    public function submit($id)
    {
        $this->delete = SendSms::query()->firstWhere('slug', $id);
        $this->slug = $this->delete->slug;
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => "confirmed",
            'onDismissed' => 'cancelled',
            'slug' => $id,
        ]);
    }

    public function confirmed()
    {
        SendSms::where('slug', $this->slug)->delete();
        Note::createSystemNotification(Admin::class, 'SMS', 'Deletado com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Deletado com sucesso ');
        return back();
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        $user = Auth::user();
        $viewData = [];

        if (isset($user->role)) {
            if ($user->role == 0) {
                $query = SendSms::query();
                if ($this->search) {
                    $query->where(function($q) {
                        $q->where('title', 'like', '%' . $this->search . '%')
                          ->orWhere('type', 'like', '%' . $this->search . '%');
                    });
                }
                if ($this->selectedType !== '') {
                    $query->where('type', $this->selectedType);
                }
                if ($this->selectedClass) {
                    $query->where('class_id', $this->selectedClass);
                }
                $viewData['models'] = $this->readyToLoad ? $query->latest()->paginate(10) : [];
            } elseif ($user->role == 3) {
                $query = SendSms::where('created_by', $user->id);
                if ($this->search) {
                    $query->where(function($q) {
                        $q->where('title', 'like', '%' . $this->search . '%')
                          ->orWhere('type', 'like', '%' . $this->search . '%');
                    });
                }
                if ($this->selectedType !== '') {
                    $query->where('type', $this->selectedType);
                }
                if ($this->selectedClass) {
                    $query->where('class_id', $this->selectedClass);
                }
                $viewData['models'] = $this->readyToLoad ? $query->latest()->paginate(10) : [];
                $viewData['academic_department'] = true;
            }
        } else {
            $userr = User::where("id", $user->id)->first();
            $query = SendSms::query()->where(function($q) use ($userr) {
                $q->where("type", "all")->orWhere("class_id", $userr->classroom_id);
            });
            if ($this->search) {
                $query->where(function($q) {
                    $q->where('title', 'like', '%' . $this->search . '%');
                });
            }
            $viewData['models'] = $this->readyToLoad ? $query->latest()->paginate(10) : [];
            $viewData['student'] = true;
        }

        $viewData['classes'] = \App\Models\Classroom::select('id', 'name', 'class')->orderBy('class')->get();
        return view('livewire.admin.sendsms.sms', $viewData);
    }
}
