<?php

namespace App\Http\Livewire\Admin\Teachers;

use App\Models\Admin;
use App\Models\Subject;
use App\Models\TeacherSubject;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;
use App\Models\Classroom;

class AssignSubject extends Component
{
    use FindGuard, LivewireAlert;

       public $name, $teacher_id,$subject_id,$classroom_id,$class, $model;
    public $validatedData;
    public $updateMode = false;

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    protected array $rules = [
        'teacher_id' => ['required', 'string', 'max:255'],
        'subject_id' => ['required', 'string', 'max:255'],
        'classroom_id' => ['required', 'string', 'max:255'],
        'class' => ['required', 'string', 'max:255'],
    ];
    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function submit()
    {
        $this->validatedData = $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        //check if the teacher is already there
       $check=TeacherSubject::query()->where('teacher_id', $this->teacher_id)->where('classroom_id', $this->classroom_id)->where('class', $this->class)->where('subject_id',$this->subject_id)->first();
        if($check){
            $this->alert('error', 'Professor tem outra disciplina.'); 
            return back(); 
        }
        TeacherSubject::Create([
            'teacher_id' => $this->teacher_id,
            'subject_id' => $this->subject_id,
            'classroom_id' => $this->classroom_id,
            'class' => $this->class,
        ]);
        Note::createSystemNotification(Admin::class, 'Novo professor - disciplina', 'Disciplina atribuida ao professor com sucesso ' . Admin::find($this->teacher_id)->name);
        $this->emit('noteAdded');
        $this->alert('success', 'Disciplina atribuida ao professor com sucesso ' . Admin::find($this->teacher_id)->name);
        $this->reset();
    }


    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }
    public function render()
    {
        return view('livewire.admin.teachers.assign-subject', [
            'subjects' => Subject::query()->orderBy('name')->get(),
            'teachers' => Admin::query()->orderBy('name')->where('role', 2)->get(),
            'classes' => Classroom::query()->where(function ($query) {
                $query->orWhere('class', $this->class);
            })->get(),
        ]);
    }
}
