<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Note\Models\Notification;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use Laravel\Passport\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, Uuids, HasSlug, SoftDeletes;

    /**
     * stop the auto increment
     */
    public $incrementing = false;

    /**
     * type of auto-increment
     *
     * @string
     */
    protected $keyType = 'string';
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'slug',
        'sex',
        'dob',
        'classroom_id',
        'email',
        'student_id',
	    'is_paid',
	    'phone_number',
        'password',
        'is_active',
        'year_edu',
        'avatar'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];
    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    /**
     * Get the options for generating the slug.
     */
    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('student_id')
            ->saveSlugsTo('slug');
    }

    /**
     * notifications
     * @return MorphMany
     */
    public function notification(): MorphMany
    {
        return $this->morphMany(Notification::class, 'notification');
    }

    public function readingStatuses()
    {
        return $this->hasMany(ReadingStatus::class,'user_id');
    }
    public function bookstatus()
    {
        return $this->hasMany(BookStatus::class,'user_id');
    }
    /**
     * instructor
     * @return BelongsTo
     */
    public function class(): BelongsTo
    {
        return $this->belongsTo(Classroom::class,'classroom_id');
    }
    
    public function classroom()
    {
        return $this->belongsTo(Classroom::class, 'classroom_id', 'id');
    }

    public function exams(): HasMany
    {
        return $this->hasMany(Exam::class, 'student_id')->latest();
    }
    public function examsas1(): HasMany
    {
        return $this->hasMany(Exam::class, 'student_id')->latest()->where('ACS1a', '>', 0);
    }
    public function examsas2(): HasMany
    {
        return $this->hasMany(Exam::class, 'student_id')->latest()->where('ACS2a', '>', 0);
    }
    public function examsat(): HasMany
    {
        return $this->hasMany(Exam::class, 'student_id')->latest()->where('AT', '>', 0);
    }
    public function deviceTokens()
    {
        return $this->hasMany(DeviceToken::class);
    }
    public function setAvatarAttribute($value)
    {
        if ($value instanceof \Illuminate\Http\UploadedFile) {
            // Define the base URL where the avatars will be stored
            $baseUrl = 'https://phplaravel-1165120-4785918.cloudwaysapps.com/avatars/avatars/';
    
            // Generate a unique filename for the avatar image
            $filename = $value->getClientOriginalName(); // Use the original filename
            
            // Set the avatar attribute to the full URL of the stored file
            $this->attributes['avatar'] = $baseUrl . $filename;
        } else {
            // If the value is not an instance of UploadedFile,
            // assume it's already a path to the avatar.
            $this->attributes['avatar'] = $value;
        }
    }


}
