<option value="{{ $k }}" @selected(request('processing_status')===$k)>{{ $v }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            
            <div class="filters-actions">
                <button type="submit" class="btn btn-primary">
                    <svg style="width: 16px; height: 16px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                    </svg>
                    Aplicar Filtros
                </button>
            </div>
        </form>
    </div>

    {{-- Data Tables --}}
    <div class="tables-grid">
        {{-- Files Table --}}
        <div class="table-card">
            <div class="table-header">
                <div class="table-title">
                    <svg style="width: 20px; height: 20px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-5L12 5H5a2 2 0 00-2 2z"/>
                    </svg>
                    <span>Ficheiros Recentes</span>
                </div>
                <a href="{{ route('bmeps.files.index') }}" class="table-action">
                    Ver todos
                    <svg style="width: 16px; height: 16px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                    </svg>
                </a>
            </div>
            
            <div class="table-container">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Ficheiro</th>
                            <th>Data</th>
                            <th>Registos</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse(($files ?? []) as $file)
                            <tr>
                                <td>
                                    <div class="file-info">
                                        <div class="file-icon">
                                            <svg style="width: 16px; height: 16px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                                            </svg>
                                        </div>
                                        <div class="file-details">
                                            <div class="file-name">{{ $file->filename }}</div>
                                            <div class="file-size">{{ number_format(($file->file_size ?? 0) / 1024, 1) }} KB</div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="date-info">
                                        <div class="date-primary">{{ optional($file->file_creation_date)->format('d/m/Y') ?? '—' }}</div>
                                        <div class="date-secondary">{{ optional($file->file_creation_date)->format('H:i') ?? '' }}</div>
                                    </div>
                                </td>
                                <td>
                                    <span class="records-count">{{ number_format($file->total_records ?? 0) }}</span>
                                </td>
                                <td>
                                    @php $status = $file->processing_status; @endphp
                                    @if($status === 'processing')
                                        <span class="status-badge processing">
                                            <svg style="width: 12px; height: 12px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                                            </svg>
                                            Processando
                                        </span>
                                    @elseif($status === 'completed')
                                        <span class="status-badge completed">
                                            <svg style="width: 12px; height: 12px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                            </svg>
                                            Concluído
                                        </span>
                                    @elseif($status === 'failed')
                                        <span class="status-badge failed">
                                            <svg style="width: 12px; height: 12px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                                            </svg>
                                            Falhou
                                        </span>
                                    @else
                                        <span class="status-badge pending">
                                            <svg style="width: 12px; height: 12px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                            </svg>
                                            Pendente
                                        </span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="empty-state">
                                    <div class="empty-content">
                                        <svg style="width: 48px; height: 48px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-5L12 5H5a2 2 0 00-2 2z"/>
                                        </svg>
                                        <div class="empty-title">Nenhum ficheiro encontrado</div>
                                        <div class="empty-description">Não há ficheiros para exibir no momento</div>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        {{-- Transactions Table --}}
        <div class="table-card">
            <div class="table-header">
                <div class="table-title">
                    <svg style="width: 20px; height: 20px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                    </svg>
                    <span>Transações Recentes</span>
                </div>
                <a href="{{ route('bmeps.transactions.index') }}" class="table-action">
                    Ver todas
                    <svg style="width: 16px; height: 16px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                    </svg>
                </a>
            </div>
            
            <div class="table-container">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Referência</th>
                            <th>Valor</th>
                            <th>Data</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse(($transactions ?? []) as $t)
                            <tr>
                                <td>
                                    <div class="transaction-ref">
                                        <div class="ref-number">{{ $t->reference }}</div>
                                        <div class="ref-type">{{ $t->transaction_type ?? 'N/A' }}</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="transaction-amount">
                                        <div class="amount-value">MT {{ number_format($t->amount, 2, ',', '.') }}</div>
                                        @if($t->commission)
                                            <div class="amount-commission">Com: MT {{ number_format($t->commission, 2, ',', '.') }}</div>
                                        @endif
                                    </div>
                                </td>
                                <td>
                                    <div class="date-info">
                                        <div class="date-primary">{{ optional($t->transaction_date)->format('d/m/Y') ?? $t->transaction_date }}</div>
                                        <div class="date-secondary">{{ $t->transaction_time }}</div>
                                    </div>
                                </td>
                                <td>
                                    @php $rs = $t->reconciliation_status; @endphp
                                    @if($rs === 'reconciled')
                                        <span class="status-badge reconciled">
                                            <svg style="width: 12px; height: 12px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                            </svg>
                                            Reconciliado
                                        </span>
                                    @elseif($rs === 'ignored')
                                        <span class="status-badge ignored">
                                            <svg style="width: 12px; height: 12px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728L5.636 5.636"/>
                                            </svg>
                                            Ignorado
                                        </span>
                                    @elseif($rs === 'error')
                                        <span class="status-badge error">
                                            <svg style="width: 12px; height: 12px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 16.5c-.77.833.192 2.5 1.732 2.5z"/>
                                            </svg>
                                            Erro
                                        </span>
                                    @else
                                        <span class="status-badge pending">
                                            <svg style="width: 12px; height: 12px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                            </svg>
                                            Pendente
                                        </span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="empty-state">
                                    <div class="empty-content">
                                        <svg style="width: 48px; height: 48px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                                        </svg>
                                        <div class="empty-title">Nenhuma transação encontrada</div>
                                        <div class="empty-description">Não há transações para exibir no momento</div>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
/* Reset e Base */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

/* Dashboard Principal */
.bmeps-dashboard {
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    min-height: 100vh;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    color: #334155;
    position: relative;
}

/* Background Pattern */
.dashboard-bg {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: radial-gradient(circle at 20% 30%, rgba(59, 130, 246, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 70%, rgba(168, 85, 247, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 40% 80%, rgba(16, 185, 129, 0.1) 0%, transparent 50%);
    pointer-events: none;
    z-index: 0;
}

/* Hero Header */
.hero-header {
    background: rgba(255, 255, 255, 0.8);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 20px;
    margin: 30px;
    padding: 40px;
    position: relative;
    z-index: 1;
    box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
}

.hero-content {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    gap: 40px;
}

.hero-left {
    flex: 1;
}

.breadcrumb {
    display: flex;
    align-items: center;
    gap: 8px;
    margin-bottom: 16px;
    font-size: 14px;
    color: #64748b;
}

.breadcrumb-item.active {
    color: #3b82f6;
    font-weight: 600;
}

.breadcrumb-separator {
    color: #cbd5e1;
}

.hero-title {
    font-size: 48px;
    font-weight: 800;
    background: linear-gradient(135deg, #1e293b, #3b82f6);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    margin-bottom: 16px;
    line-height: 1.1;
}

.hero-description {
    font-size: 18px;
    color: #64748b;
    margin-bottom: 24px;
    max-width: 600px;
    line-height: 1.6;
}

.status-bar {
    display: flex;
    align-items: center;
    gap: 16px;
}

.status-item {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    font-weight: 500;
}

.status-dot {
    width: 8px;
    height: 8px;
    border-radius: 50%;
    animation: pulse 2s infinite;
}

.status-active {
    background: #10b981;
}

.status-inactive {
    background: #ef4444;
}

.status-divider {
    width: 1px;
    height: 16px;
    background: #e2e8f0;
}

/* Hero Actions */
.hero-actions {
    display: flex;
    gap: 12px;
    flex-shrink: 0;
}

/* Botões */
.btn {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 24px;
    border-radius: 12px;
    text-decoration: none;
    color: inherit;
    transition: all 0.3s ease;
}

.quick-action:hover {
    background: rgba(255, 255, 255, 0.9);
    transform: translateX(4px);
    color: inherit;
    text-decoration: none;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.action-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
    box-shadow: 0 4px 14px rgba(0, 0, 0, 0.15);
}

.action-content {
    flex: 1;
}

.action-title {
    font-size: 14px;
    font-weight: 600;
    color: #0f172a;
    margin-bottom: 2px;
}

.action-description {
    font-size: 12px;
    color: #64748b;
}

/* System Health */
.system-health {
    padding: 20px;
    background: linear-gradient(135deg, #f0fdf4, #dcfce7);
    border-radius: 12px;
}

.health-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 16px;
}

.health-title {
    font-size: 16px;
    font-weight: 600;
    color: #065f46;
}

.health-dots {
    display: flex;
    gap: 4px;
}

.dot {
    width: 6px;
    height: 6px;
    background: #10b981;
    border-radius: 50%;
    animation: pulse 1.5s infinite;
}

.dot:nth-child(2) {
    animation-delay: 0.2s;
}

.dot:nth-child(3) {
    animation-delay: 0.4s;
}

.health-metrics {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.health-metric {
    display: flex;
    justify-content: space-between;
    font-size: 14px;
}

.health-label {
    color: #047857;
}

.health-value {
    font-weight: 600;
    color: #064e3b;
}

/* Filters Section */
.filters-section {
    background: rgba(255, 255, 255, 0.9);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 16px;
    margin: 0 30px 30px;
    overflow: hidden;
    position: relative;
    z-index: 1;
}

.filters-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 24px;
    background: linear-gradient(135deg, #f8fafc, #ffffff);
    border-bottom: 1px solid rgba(226, 232, 240, 0.5);
}

.filters-title {
    display: flex;
    align-items: center;
    gap: 12px;
    font-size: 18px;
    font-weight: 700;
    color: #0f172a;
}

.filters-form {
    padding: 24px;
}

.filters-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-bottom: 24px;
}

.filter-group {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.filter-label {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    font-weight: 600;
    color: #374151;
}

.filter-input, .filter-select {
    padding: 12px 16px;
    border: 1px solid #d1d5db;
    border-radius: 8px;
    font-size: 14px;
    background: rgba(255, 255, 255, 0.8);
    backdrop-filter: blur(10px);
    transition: all 0.2s ease;
}

.filter-input:focus, .filter-select:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    background: white;
}

.filter-select {
    appearance: none;
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3e%3cpath stroke='%236b7280' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='m6 8 4 4 4-4'/%3e%3c/svg%3e");
    background-position: right 12px center;
    background-repeat: no-repeat;
    background-size: 16px;
    padding-right: 40px;
}

.filters-actions {
    display: flex;
    justify-content: flex-end;
}

/* Tables Grid */
.tables-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 24px;
    margin: 0 30px 30px;
    position: relative;
    z-index: 1;
}

.table-card {
    background: rgba(255, 255, 255, 0.9);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 16px;
    overflow: hidden;
}

.table-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 24px;
    background: linear-gradient(135deg, #f8fafc, #ffffff);
    border-bottom: 1px solid rgba(226, 232, 240, 0.5);
}

.table-title {
    display: flex;
    align-items: center;
    gap: 12px;
    font-size: 18px;
    font-weight: 700;
    color: #0f172a;
}

.table-action {
    display: flex;
    align-items: center;
    gap: 4px;
    color: #3b82f6;
    text-decoration: none;
    font-size: 14px;
    font-weight: 600;
    transition: all 0.2s ease;
}

.table-action:hover {
    color: #1d4ed8;
    text-decoration: none;
}

.table-container {
    overflow-x: auto;
}

.data-table {
    width: 100%;
    border-collapse: collapse;
}

.data-table thead th {
    padding: 16px;
    background: #f8fafc;
    text-align: left;
    font-size: 12px;
    font-weight: 700;
    color: #374151;
    text-transform: uppercase;
    letter-spacing: 0.05em;
    border-bottom: 1px solid #e2e8f0;
}

.data-table tbody tr {
    transition: all 0.2s ease;
}

.data-table tbody tr:hover {
    background: rgba(248, 250, 252, 0.8);
}

.data-table tbody td {
    padding: 16px;
    border-bottom: 1px solid #f1f5f9;
    font-size: 14px;
    vertical-align: top;
}

/* File Info */
.file-info {
    display: flex;
    align-items: center;
    gap: 12px;
}

.file-icon {
    width: 32px;
    height: 32px;
    background: linear-gradient(135deg, #3b82f6, #1d4ed8);
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    flex-shrink: 0;
}

.file-details {
    flex: 1;
}

.file-name {
    font-weight: 600;
    color: #0f172a;
    margin-bottom: 2px;
}

.file-size {
    font-size: 12px;
    color: #64748b;
}

.date-info {
    display: flex;
    flex-direction: column;
    gap: 2px;
}

.date-primary {
    font-weight: 600;
    color: #0f172a;
}

.date-secondary {
    font-size: 12px;
    color: #64748b;
}

.records-count {
    font-weight: 600;
    color: #0f172a;
    background: #f1f5f9;
    padding: 4px 8px;
    border-radius: 6px;
    font-size: 12px;
}

/* Transaction Info */
.transaction-ref {
    display: flex;
    flex-direction: column;
    gap: 2px;
}

.ref-number {
    font-weight: 600;
    color: #0f172a;
}

.ref-type {
    font-size: 12px;
    color: #64748b;
}

.transaction-amount {
    display: flex;
    flex-direction: column;
    gap: 2px;
}

.amount-value {
    font-weight: 600;
    color: #0f172a;
}

.amount-commission {
    font-size: 12px;
    color: #64748b;
}

/* Status Badges */
.status-badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
    white-space: nowrap;
}

.status-badge.processing {
    background: #fef3c7;
    color: #d97706;
}

.status-badge.completed,
.status-badge.reconciled {
    background: #dcfce7;
    color: #166534;
}

.status-badge.failed,
.status-badge.error {
    background: #fef2f2;
    color: #dc2626;
}

.status-badge.pending {
    background: #f1f5f9;
    color: #475569;
}

.status-badge.ignored {
    background: #fafafa;
    color: #525252;
}

/* Empty State */
.empty-state {
    text-align: center;
    padding: 60px 20px;
}

.empty-content {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 16px;
}

.empty-content svg {
    color: #cbd5e1;
}

.empty-title {
    font-size: 16px;
    font-weight: 600;
    color: #374151;
}

.empty-description {
    color: #64748b;
    font-size: 14px;
}

/* Animations */
@keyframes pulse {
    0%, 100% {
        opacity: 1;
    }
    50% {
        opacity: 0.5;
    }
}

/* Responsive Design */
@media (max-width: 1200px) {
    .financial-kpis,
    .analytics-grid {
        grid-template-columns: 1fr;
    }
    
    .tables-grid {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 768px) {
    .bmeps-dashboard {
        padding: 0;
    }
    
    .hero-header {
        margin: 20px;
        padding: 24px;
    }
    
    .hero-content {
        flex-direction: column;
        gap: 24px;
        text-align: center;
    }
    
    .hero-title {
        font-size: 32px;
    }
    
    .hero-actions {
        width: 100%;
        justify-content: center;
        flex-wrap: wrap;
    }
    
    .metrics-grid,
    .financial-kpis,
    .analytics-grid,
    .filters-section,
    .tables-grid {
        margin: 0 20px 20px;
        grid-template-columns: 1fr;
    }
    
    .kpi-metrics {
        grid-template-columns: 1fr;
    }
    
    .filters-grid {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 480px) {
    .hero-header {
        margin: 15px;
        padding: 20px;
    }
    
    .hero-title {
        font-size: 24px;
    }
    
    .metric-value {
        font-size: 24px;
    }
    
    .kpi-value {
        font-size: 18px;
    }
    
    .btn {
        padding: 10px 16px;
        font-size: 13px;
    }
}
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Dados para o gráfico de status
    const dataStatus = {
        reconciled: {{ (int)($stats['reconciled_count'] ?? 0) }},
        pending: {{ (int)($stats['unreconciled_count'] ?? 0) }},
        ignored: {{ (int)($stats['ignored_count'] ?? 0) }},
        error: {{ (int)($stats['errors_count'] ?? 0) }},
    };
    
    const ctx = document.getElementById('statusChart');
    if (ctx) {
        const gradient1 = ctx.getContext('2d').createLinearGradient(0, 0, 0, 400);
        gradient1.addColorStop(0, '#10b981');
        gradient1.addColorStop(1, '#059669');
        
        const gradient2 = ctx.getContext('2d').createLinearGradient(0, 0, 0, 400);
        gradient2.addColorStop(0, '#f59e0b');
        gradient2.addColorStop(1, '#d97706');
        
        const gradient3 = ctx.getContext('2d').createLinearGradient(0, 0, 0, 400);
        gradient3.addColorStop(0, '#94a3b8');
        gradient3.addColorStop(1, '#64748b');
        
        const gradient4 = ctx.getContext('2d').createLinearGradient(0, 0, 0, 400);
        gradient4.addColorStop(0, '#ef4444');
        gradient4.addColorStop(1, '#dc2626');
        
        new Chart(ctx, {
            type: 'doughnut',
            data: {
                labels: ['Reconciliadas', 'Pendentes', 'Ignoradas', 'Erros'],
                datasets: [{
                    data: [
                        dataStatus.reconciled,
                        dataStatus.pending,
                        dataStatus.ignored,
                        dataStatus.error
                    ],
                    backgroundColor: [gradient1, gradient2, gradient3, gradient4],
                    borderWidth: 0,
                    hoverBorderWidth: 8,
                    hoverBorderColor: '#ffffff',
                    hoverOffset: 15,
                    spacing: 2
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                cutout: '70%',
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        backgroundColor: 'rgba(15, 23, 42, 0.95)',
                        titleColor: '#ffffff',
                        bodyColor: '#ffffff',
                        borderColor: 'rgba(59, 130, 246, 0.5)',
                        borderWidth: 2,
                        cornerRadius: 12,
                        padding: 12,
                        displayColors: true,
                        usePointStyle: true,
                        callbacks: {
                            label: function(context) {
                                const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                const percentage = total > 0 ? ((context.parsed / total) * 100).toFixed(1) : 0;
                                return `${context.label}: ${context.parsed.toLocaleString()} (${percentage}%)`;
                            }
                        }
                    }
                },
                animation: {
                    animateRotate: true,
                    animateScale: true,
                    duration: 1500,
                    easing: 'easeOutQuart'
                },
                interaction: {
                    intersect: false,
                    mode: 'index'
                }
            }
        });
    }
    
    // Animações de entrada
    const observer = new IntersectionObserver((entries) => {
        entries.forEach((entry, index) => {
            if (entry.isIntersecting) {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateY(0)';
                entry.target.style.transitionDelay = `${index * 100}ms`;
            }
        });
    }, { threshold: 0.1 });
    
    document.querySelectorAll('.metric-card, .kpi-card, .chart-card, .actions-card, .table-card').forEach((card) => {
        card.style.opacity = '0';
        card.style.transform = 'translateY(30px)';
        card.style.transition = 'opacity 0.8s ease, transform 0.8s ease';
        observer.observe(card);
    });
    
    // Atualização automática do timestamp
    setInterval(() => {
        const now = new Date();
        const timeElements = document.querySelectorAll('.status-item:last-child span');
        timeElements.forEach(el => {
            if (el.textContent.includes('Última atualização')) {
                el.textContent = `Última atualização: ${now.toLocaleTimeString('pt-PT', {
                    hour: '2-digit',
                    minute: '2-digit'
                })}`;
            }
        });
    }, 60000);
    
    // Performance monitoring
    if ('performance' in window) {
        window.addEventListener('load', function() {
            setTimeout(() => {
                const perfData = performance.getEntriesByType('navigation')[0];
                console.log(`Dashboard carregado em ${Math.round(perfData.loadEventEnd - perfData.loadEventStart)}ms`);
            }, 0);
        });
    }
});
</script>
@endpush
    font-weight: 600;
    font-size: 14px;
    text-decoration: none;
    border: none;
    cursor: pointer;
    transition: all 0.3s ease;
    white-space: nowrap;
}

.btn-primary {
    background: linear-gradient(135deg, #3b82f6, #1d4ed8);
    color: white;
    box-shadow: 0 4px 14px 0 rgba(59, 130, 246, 0.4);
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 25px 0 rgba(59, 130, 246, 0.5);
    color: white;
    text-decoration: none;
}

.btn-secondary {
    background: rgba(255, 255, 255, 0.9);
    color: #475569;
    border: 1px solid rgba(226, 232, 240, 0.8);
    backdrop-filter: blur(10px);
}

.btn-secondary:hover {
    background: rgba(248, 250, 252, 0.95);
    color: #334155;
    text-decoration: none;
}

.btn-success {
    background: linear-gradient(135deg, #10b981, #047857);
    color: white;
    box-shadow: 0 4px 14px 0 rgba(16, 185, 129, 0.4);
}

.btn-success:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 25px 0 rgba(16, 185, 129, 0.5);
    color: white;
    text-decoration: none;
}

/* Metrics Grid */
.metrics-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 24px;
    margin: 0 30px 30px;
    position: relative;
    z-index: 1;
}

.metric-card {
    background: rgba(255, 255, 255, 0.9);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 16px;
    transition: all 0.3s ease;
    overflow: hidden;
}

.metric-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1);
}

.metric-content {
    padding: 24px;
}

.metric-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
}

.metric-info {
    flex: 1;
}

.metric-label {
    font-size: 14px;
    color: #64748b;
    margin-bottom: 8px;
    font-weight: 500;
}

.metric-value {
    font-size: 32px;
    font-weight: 800;
    color: #0f172a;
    margin-bottom: 4px;
    line-height: 1;
}

.metric-subtitle {
    font-size: 14px;
    color: #94a3b8;
    margin-bottom: 12px;
}

.metric-change {
    display: inline-flex;
    align-items: center;
    gap: 4px;
    padding: 4px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
}

.metric-change-up {
    background: #dcfce7;
    color: #166534;
}

.metric-change-down {
    background: #fef2f2;
    color: #dc2626;
}

.metric-change-neutral {
    background: #f1f5f9;
    color: #475569;
}

.metric-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
    box-shadow: 0 4px 14px 0 rgba(0, 0, 0, 0.1);
}

/* Financial KPIs */
.financial-kpis {
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: 24px;
    margin: 0 30px 30px;
    position: relative;
    z-index: 1;
}

.kpi-card {
    background: rgba(255, 255, 255, 0.9);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 16px;
    padding: 32px;
    transition: all 0.3s ease;
}

.kpi-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1);
}

.kpi-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 24px;
}

.kpi-title {
    font-size: 20px;
    font-weight: 700;
    color: #0f172a;
}

.kpi-trend {
    display: flex;
    align-items: center;
    gap: 4px;
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
}

.kpi-trend.positive {
    background: #dcfce7;
    color: #166534;
}

.kpi-metrics {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 24px;
    margin-bottom: 24px;
}

.kpi-metric {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.kpi-label {
    font-size: 14px;
    color: #64748b;
    font-weight: 500;
}

.kpi-value {
    font-size: 24px;
    font-weight: 700;
    color: #0f172a;
}

.kpi-detail {
    font-size: 12px;
    color: #94a3b8;
}

.kpi-projection {
    display: flex;
    align-items: center;
    gap: 16px;
    padding: 20px;
    background: linear-gradient(135deg, #f0fdf4, #dcfce7);
    border-radius: 12px;
}

.projection-icon {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #10b981, #059669);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
}

.projection-content {
    display: flex;
    flex-direction: column;
    gap: 2px;
}

.projection-title {
    font-size: 14px;
    font-weight: 600;
    color: #065f46;
}

.projection-value {
    font-size: 18px;
    font-weight: 700;
    color: #064e3b;
}

.projection-detail {
    font-size: 12px;
    color: #047857;
}

/* Automation Card */
.kpi-automation {
    display: flex;
    flex-direction: column;
}

.automation-status {
    padding: 4px 12px;
    border-radius: 20px;
    font-size: 11px;
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.automation-status.status-active {
    background: #dcfce7;
    color: #166534;
}

.automation-status.status-inactive {
    background: #fef2f2;
    color: #dc2626;
}

.automation-info {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.automation-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 16px;
    background: #f8fafc;
    border-radius: 12px;
}

.automation-time {
    font-size: 12px;
    color: #64748b;
    margin-left: auto;
}

.automation-progress {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.progress-label {
    font-size: 14px;
    color: #64748b;
    font-weight: 500;
}

.progress-bar {
    width: 100%;
    height: 8px;
    background: #e2e8f0;
    border-radius: 4px;
    overflow: hidden;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #10b981, #059669);
    border-radius: 4px;
    transition: width 0.3s ease;
}

.progress-value {
    font-size: 14px;
    font-weight: 600;
    color: #10b981;
}

.automation-result {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.result-label {
    font-size: 14px;
    color: #64748b;
    font-weight: 500;
}

.result-value {
    font-size: 14px;
    font-weight: 600;
}

.result-value.success {
    color: #10b981;
}

.result-value.error {
    color: #ef4444;
}

/* Analytics Grid */
.analytics-grid {
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: 24px;
    margin: 0 30px 30px;
    position: relative;
    z-index: 1;
}

.chart-card, .actions-card {
    background: rgba(255, 255, 255, 0.9);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 16px;
    overflow: hidden;
}

.card-header {
    padding: 24px 24px 0;
}

.card-title {
    font-size: 18px;
    font-weight: 700;
    color: #0f172a;
    margin-bottom: 4px;
}

.card-subtitle {
    font-size: 14px;
    color: #64748b;
}

.card-content {
    padding: 24px;
}

.chart-container {
    height: 300px;
    margin-bottom: 20px;
}

.chart-legend {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
    gap: 12px;
}

.legend-item {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    color: #64748b;
}

.legend-color {
    width: 12px;
    height: 12px;
    border-radius: 3px;
}

/* Quick Actions */
.quick-actions {
    display: flex;
    flex-direction: column;
    gap: 12px;
    margin-bottom: 24px;
}

.quick-action {
    display: flex;
    align-items: center;
    gap: 16px;
    padding: 16px;
    background: rgba(248, 250, 252, 0.8);
    border: 1px solid rgba(226, 232, 240, 0.5);
    border-radius: 12px;
    @php
if (!function_exists('render_bmeps_metric_card')) {
    function render_bmeps_metric_card($title = '', $value = '', $change = null, $icon = 'folder', $trend = 'neutral', $subtitle = '', $color = 'blue') {
        $icons = [
            'folder' => '<svg style="width: 24px; height: 24px;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-5L12 5H5a2 2 0 00-2 2z"/></svg>',
            'receipt' => '<svg style="width: 24px; height: 24px;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/></svg>',
            'check' => '<svg style="width: 24px; height: 24px;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>',
            'alert' => '<svg style="width: 24px; height: 24px;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 16.5c-.77.833.192 2.5 1.732 2.5z"/></svg>',
            'money' => '<svg style="width: 24px; height: 24px;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"/></svg>',
            'trending' => '<svg style="width: 24px; height: 24px;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/></svg>'
        ];
        
        $colors = [
            'blue' => 'background: linear-gradient(135deg, #3b82f6, #1e40af); color: white;',
            'purple' => 'background: linear-gradient(135deg, #8b5cf6, #7c3aed); color: white;',
            'green' => 'background: linear-gradient(135deg, #10b981, #059669); color: white;',
            'orange' => 'background: linear-gradient(135deg, #f59e0b, #d97706); color: white;',
            'indigo' => 'background: linear-gradient(135deg, #6366f1, #4f46e5); color: white;',
            'teal' => 'background: linear-gradient(135deg, #14b8a6, #0d9488); color: white;'
        ];
        
        echo '<div class="metric-card">';
        echo '  <div class="metric-content">';
        echo '    <div class="metric-header">';
        echo '      <div class="metric-info">';
        echo "        <p class=\"metric-label\">$title</p>";
        echo "        <div class=\"metric-value\">$value</div>";
        if ($subtitle) {
            echo "        <p class=\"metric-subtitle\">$subtitle</p>";
        }
        if ($change) {
            echo "        <div class=\"metric-change metric-change-$trend\">$change</div>";
        }
        echo '      </div>';
        echo '      <div class="metric-icon" style="'.$colors[$color].'">'.($icons[$icon] ?? $icons['folder']).'</div>';
        echo '    </div>';
        echo '  </div>';
        echo '</div>';
    }
}
@endphp

<div class="bmeps-dashboard">
    {{-- Background Pattern --}}
    <div class="dashboard-bg"></div>

    {{-- Hero Header --}}
    <div class="hero-header">
        <div class="hero-content">
            <div class="hero-left">
                <div class="breadcrumb">
                    <span class="breadcrumb-item">Sistema</span>
                    <span class="breadcrumb-separator">›</span>
                    <span class="breadcrumb-item active">BMEPS Dashboard</span>
                </div>
                <h1 class="hero-title">Dashboard de Transações</h1>
                <p class="hero-description">
                    Monitoramento inteligente e análise em tempo real do sistema BMEPS com visualizações avançadas
                </p>
                <div class="status-bar">
                    <div class="status-item">
                        <div class="status-dot {{ ($stats['auto_reconcile_enabled'] ?? false) ? 'status-active' : 'status-inactive' }}"></div>
                        <span>{{ ($stats['auto_reconcile_enabled'] ?? false) ? 'Sistema Online' : 'Sistema Offline' }}</span>
                    </div>
                    <div class="status-divider"></div>
                    <div class="status-item">
                        <span>Última atualização: {{ now()->format('H:i') }}</span>
                    </div>
                </div>
            </div>
            <div class="hero-actions">
                <button class="btn btn-secondary" onclick="location.reload()">
                    <svg style="width: 16px; height: 16px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                    </svg>
                    Atualizar
                </button>
                <a href="{{ route('bmeps.download.now') }}" class="btn btn-primary">
                    <svg style="width: 16px; height: 16px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M9 19l3 3m0 0l3-3m-3 3V10"/>
                    </svg>
                    Download
                </a>
                <a href="{{ route('bmeps.process.now') }}" class="btn btn-success">
                    <svg style="width: 16px; height: 16px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                    </svg>
                    Processar
                </a>
            </div>
        </div>
    </div>

    {{-- Metrics Grid --}}
    <div class="metrics-grid">
        @php render_bmeps_metric_card('Total de Ficheiros', number_format($stats['total_files'] ?? 0), '+12% vs mês anterior', 'folder', 'up', 'Processados com sucesso', 'blue'); @endphp
        @php render_bmeps_metric_card('Transações', number_format($stats['total_transactions'] ?? 0), '+8.2% crescimento', 'receipt', 'up', 'Volume acumulado', 'purple'); @endphp
        @php render_bmeps_metric_card('Reconciliadas', number_format($stats['reconciled_count'] ?? 0), '94.5% taxa sucesso', 'check', 'up', 'Aprovadas automaticamente', 'green'); @endphp
        @php render_bmeps_metric_card('Pendentes', number_format($stats['unreconciled_count'] ?? 0), ($stats['unreconciled_count'] ?? 0) > 100 ? 'Requer atenção' : 'Controlado', 'alert', ($stats['unreconciled_count'] ?? 0) > 100 ? 'down' : 'neutral', 'Aguardando processamento', 'orange'); @endphp
    </div>

    {{-- Financial KPIs --}}
    <div class="financial-kpis">
        <div class="kpi-card kpi-revenue">
            <div class="kpi-header">
                <h3 class="kpi-title">Performance Financeira</h3>
                <div class="kpi-trend positive">
                    <svg style="width: 16px; height: 16px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/>
                    </svg>
                    +15.3%
                </div>
            </div>
            <div class="kpi-content">
                <div class="kpi-metrics">
                    <div class="kpi-metric">
                        <span class="kpi-label">Volume Total</span>
                        <span class="kpi-value">MT {{ number_format($stats['total_amount'] ?? 0, 2, ',', '.') }}</span>
                        <span class="kpi-detail">Meta: 85% atingida</span>
                    </div>
                    <div class="kpi-metric">
                        <span class="kpi-label">Receita em Comissões</span>
                        <span class="kpi-value">MT {{ number_format($stats['total_commission'] ?? 0, 2, ',', '.') }}</span>
                        <span class="kpi-detail">Margem: 2.3%</span>
                    </div>
                </div>
                <div class="kpi-projection">
                    <div class="projection-icon">
                        <svg style="width: 20px; height: 20px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                        </svg>
                    </div>
                    <div class="projection-content">
                        <span class="projection-title">Projeção Mensal</span>
                        <span class="projection-value">MT {{ number_format(($stats['total_amount'] ?? 0) * 1.15, 0, ',', '.') }}</span>
                        <span class="projection-detail">+15% estimado</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="kpi-card kpi-automation">
            <div class="kpi-header">
                <h3 class="kpi-title">Auto-reconciliação</h3>
                <div class="automation-status {{ ($stats['auto_reconcile_enabled'] ?? false) ? 'status-active' : 'status-inactive' }}">
                    {{ ($stats['auto_reconcile_enabled'] ?? false) ? 'ATIVA' : 'INATIVA' }}
                </div>
            </div>
            <div class="kpi-content">
                <div class="automation-info">
                    <div class="automation-item">
                        <svg style="width: 16px; height: 16px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        <span>Próxima Execução</span>
                        <span class="automation-time">{{ $stats['next_reconcile_at'] ?? 'Não agendada' }}</span>
                    </div>
                    <div class="automation-progress">
                        <span class="progress-label">Taxa de Sucesso</span>
                        <div class="progress-bar">
                            <div class="progress-fill" style="width: 94.5%"></div>
                        </div>
                        <span class="progress-value">94.5%</span>
                    </div>
                    <div class="automation-result">
                        @php $ok = (int)($stats['last_reconcile_ok_count'] ?? 0); $err = (int)($stats['last_reconcile_error_count'] ?? 0); @endphp
                        <span class="result-label">Último Resultado</span>
                        @if($err > 0)
                            <span class="result-value error">{{ $err }} erros</span>
                        @else
                            <span class="result-value success">{{ $ok }} processadas</span>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Analytics Section --}}
    <div class="analytics-grid">
        {{-- Chart Section --}}
        <div class="chart-card">
            <div class="card-header">
                <h3 class="card-title">Distribuição de Status</h3>
                <p class="card-subtitle">Análise visual das transações</p>
            </div>
            <div class="card-content">
                <div class="chart-container">
                    <canvas id="statusChart"></canvas>
                </div>
                <div class="chart-legend">
                    <div class="legend-item">
                        <div class="legend-color" style="background: #10b981;"></div>
                        <span>{{ $stats['reconciled_count'] ?? 0 }} Reconciliadas</span>
                    </div>
                    <div class="legend-item">
                        <div class="legend-color" style="background: #f59e0b;"></div>
                        <span>{{ $stats['unreconciled_count'] ?? 0 }} Pendentes</span>
                    </div>
                    <div class="legend-item">
                        <div class="legend-color" style="background: #94a3b8;"></div>
                        <span>{{ $stats['ignored_count'] ?? 0 }} Ignoradas</span>
                    </div>
                    <div class="legend-item">
                        <div class="legend-color" style="background: #ef4444;"></div>
                        <span>{{ $stats['errors_count'] ?? 0 }} Erros</span>
                    </div>
                </div>
            </div>
        </div>

        {{-- Quick Actions --}}
        <div class="actions-card">
            <div class="card-header">
                <h3 class="card-title">Ações Rápidas</h3>
                <div class="status-indicator">
                    <div class="status-dot status-active"></div>
                </div>
            </div>
            <div class="card-content">
                <div class="quick-actions">
                    <a href="{{ route('bmeps.files.index') }}" class="quick-action">
                        <div class="action-icon" style="background: linear-gradient(135deg, #3b82f6, #1e40af);">
                            <svg style="width: 20px; height: 20px; color: white;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-5L12 5H5a2 2 0 00-2 2z"/>
                            </svg>
                        </div>
                        <div class="action-content">
                            <div class="action-title">Gerenciar Ficheiros</div>
                            <div class="action-description">Ver e processar ficheiros</div>
                        </div>
                        <svg style="width: 16px; height: 16px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </a>
                    
                    <a href="{{ route('bmeps.transactions.index') }}" class="quick-action">
                        <div class="action-icon" style="background: linear-gradient(135deg, #8b5cf6, #7c3aed);">
                            <svg style="width: 20px; height: 20px; color: white;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                        </div>
                        <div class="action-content">
                            <div class="action-title">Ver Transações</div>
                            <div class="action-description">Histórico completo</div>
                        </div>
                        <svg style="width: 16px; height: 16px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </a>
                    
                    <a href="{{ route('bmeps.config') }}" class="quick-action">
                        <div class="action-icon" style="background: linear-gradient(135deg, #10b981, #059669);">
                            <svg style="width: 20px; height: 20px; color: white;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                            </svg>
                        </div>
                        <div class="action-content">
                            <div class="action-title">Configurações</div>
                            <div class="action-description">Ajustar sistema</div>
                        </div>
                        <svg style="width: 16px; height: 16px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </a>
                    
                    <a href="{{ route('bmeps.logs') }}" class="quick-action">
                        <div class="action-icon" style="background: linear-gradient(135deg, #f59e0b, #d97706);">
                            <svg style="width: 20px; height: 20px; color: white;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                        </div>
                        <div class="action-content">
                            <div class="action-title">Logs do Sistema</div>
                            <div class="action-description">Diagnósticos</div>
                        </div>
                        <svg style="width: 16px; height: 16px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </a>
                </div>
                
                {{-- System Health --}}
                <div class="system-health">
                    <div class="health-header">
                        <h4 class="health-title">Sistema Saudável</h4>
                        <div class="health-dots">
                            <div class="dot"></div>
                            <div class="dot"></div>
                            <div class="dot"></div>
                        </div>
                    </div>
                    <div class="health-metrics">
                        <div class="health-metric">
                            <span class="health-label">Uptime</span>
                            <span class="health-value">99.9%</span>
                        </div>
                        <div class="health-metric">
                            <span class="health-label">Performance</span>
                            <span class="health-value">Excelente</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Advanced Filters --}}
    <div class="filters-section">
        <div class="filters-header">
            <div class="filters-title">
                <svg style="width: 20px; height: 20px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.207A1 1 0 013 6.5V4z"/>
                </svg>
                <span>Filtros Inteligentes</span>
            </div>
            <button type="button" class="btn btn-secondary" onclick="window.location.href='{{ route('bmeps.dashboard') }}'">
                <svg style="width: 16px; height: 16px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                </svg>
                Limpar Filtros
            </button>
        </div>
        
        <form method="GET" action="{{ route('bmeps.dashboard') }}" class="filters-form">
            <div class="filters-grid">
                <div class="filter-group">
                    <label class="filter-label">
                        <svg style="width: 16px; height: 16px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                        </svg>
                        Data de Início
                    </label>
                    <input type="date" name="start_date" value="{{ request('start_date') }}" class="filter-input"/>
                </div>
                
                <div class="filter-group">
                    <label class="filter-label">
                        <svg style="width: 16px; height: 16px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                        </svg>
                        Data de Fim
                    </label>
                    <input type="date" name="end_date" value="{{ request('end_date') }}" class="filter-input"/>
                </div>
                
                <div class="filter-group">
                    <label class="filter-label">
                        <svg style="width: 16px; height: 16px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        Status de Reconciliação
                    </label>
                    <select name="reconciliation_status" class="filter-select">
                        <option value="">Todos os status</option>
                        @foreach(['pending' => 'Pendente','reconciled' => 'Reconciliado','ignored' => 'Ignorado','error' => 'Erro'] as $k=>$v)
                            <option value="{{ $k }}" @selected(request('reconciliation_status')===$k)>{{ $v }}</option>
                        @endforeach
                    </select>
                </div>
                
                <div class="filter-group">
                    <label class="filter-label">
                        <svg style="width: 16px; height: 16px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                        </svg>
                        Status de Processamento
                    </label>
                    <select name="processing_status" class="filter-select">
                        <option value="">Todos os status</option>
                        @foreach(['pending'=>'Pendente','processing'=>'A processar','completed'=>'Concluído','failed'=>'Falhou'] as $k=>$v)
                            <option value="{{ $k }}" @selected(request('processing_status'
