<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title">Lista de matrizes</h5>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <input type="text" wire:model.debounce.300ms="search" placeholder="Pesquisar por..." class="form-control">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <select class="form-control" wire:model="filter">
                                        <option value="">Filtrar por</option>
                                        <option value="class">Titulo/Descrição</option>
                                        <option value="subject">Disciplina</option>
                                        <option value="class">Classe</option>
                                        <option value="year">Ano</option>
                                    </select>
                                </div>
                            </div>

                            <div class="table-responsive" wire:init="loadData">
                                @if(count($models))
                                    <form wire:submit.prevent="bulkDelete">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th><input type="checkbox" wire:model="selectAll"></th>
                                                    <th>#</th>
                                                    @if(!isset($student))
                                                        <th>Para</th>
                                                    @endif
                                                    <th>Classe</th>
                                                    <th>Estudante</th>
                                                    <th>Título</th>
                                                    <th>Descrição</th>
                                                    <th>Ficheiro</th>
                                                    <th>Data de lançamento</th>
                                                    @if(!isset($student))
                                                        <th>Ação</th>
                                                    @endif
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($models as $model)
                                                    @php
                                                        $get_class = $model->class_id ? \App\Models\Classroom::find($model->class_id) : null;
                                                        $get_student = $model->student_id ? \App\Models\User::find($model->student_id) : null;
                                                        $get_download = \App\Models\Downloadcenter::where("slug", $model->download_id)->first();
                                                        $get_files = \App\Models\Downloadfile::where("download_id", $model->download_id)->get();
                                                        $user = Auth::user();

                                                        $title = match($model->type) {
                                                            'all' => 'Todos',
                                                            'student' => 'Estudante',
                                                            'class' => 'Classe',
                                                            default => 'Indefinido'
                                                        };
                                                    @endphp

                                                    @if(isset($student) && (empty($model->student_id) || $model->student_id == $user->id))
                                                        <tr>
                                                            <td><input type="checkbox" wire:model="selectedIds" value="{{ $model->id }}"></td>
                                                            <th scope="row">{{ $loop->iteration }}</th>
                                                            <td>
                                                                @if($get_class)
                                                                    {{ $get_class->class }} Classe - {{ $get_class->name }}
                                                                @endif
                                                            </td>
                                                            <td>
                                                                @if($get_student)
                                                                    {{ $get_student->name }}
                                                                @endif
                                                            </td>
                                                            <td>{{ $get_download->title ?? '-' }}</td>
                                                            <td>{{ $get_download->description ?? '-' }}</td>
                                                            <td>
                                                                @forelse($get_files as $file)
                                                                    <a href="{{ $file->media_url }}" target="_blank">{{ $file->media_name }}</a><br>
                                                                @empty
                                                                    Nenhum arquivo disponível.
                                                                @endforelse
                                                            </td>
                                                            <td>{{ $model->created_at->format('d/m/Y H:i:s') }}</td>
                                                        </tr>
                                                    @elseif(!isset($student))
                                                        <tr>
                                                            <td><input type="checkbox" wire:model="selectedIds" value="{{ $model->id }}"></td>
                                                            <th scope="row">{{ $loop->iteration }}</th>
                                                            <td>{{ $title }}</td>
                                                            <td>
                                                                @if($get_class)
                                                                    {{ $get_class->class }} Classe - {{ $get_class->name }}
                                                                @endif
                                                            </td>
                                                            <td>
                                                                @if($get_student)
                                                                    {{ $get_student->name }}
                                                                @endif
                                                            </td>
                                                            <td>{{ $get_download->title ?? '-' }}</td>
                                                            <td>{{ $get_download->description ?? '-' }}</td>
                                                            <td>
                                                                @forelse($get_files as $file)
                                                                    <a href="{{ $file->media_url }}" target="_blank">{{ $file->media_name }}</a><br>
                                                                @empty
                                                                    Nenhum arquivo disponível.
                                                                @endforelse
                                                            </td>
                                                            <td>{{ $model->created_at->format('d/m/Y H:i:s') }}</td>
                                                            <td>
                                                                <a href="{{ route('admin.edit.Download', $model->download_id) }}" class="btn btn-outline-primary btn-sm">
                                                                    <span class="fa fa-edit"></span>
                                                                </a>
                                                                <a wire:click="submit('{{ $model->download_id }}')" class="btn btn-outline-danger btn-sm">
                                                                    <span class="fa fa-trash"></span>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    @endif
                                                @endforeach
                                            </tbody>
                                        </table>
                                        <button type="submit" class="btn btn-danger mt-3" {{ count($selectedIds) === 0 ? 'disabled' : '' }}>
                                            Apagar
                                        </button>
                                    </form>
                                    <div class="d-flex justify-content-center">
                                        {{ $models->links() }}
                                    </div>
                                @else
                                    <br><br>
                                    <div class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><b>Nenhum dado foi encontrado no momento.</b></p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

