<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <h5 class="card-title mb-0">Lançamento de Notas em Lote</h5>

                                <!-- Import from Excel Button -->
                                <div class="d-flex gap-2">
                                    <a href="{{ route('admin.excel.import.marks') }}" class="btn btn-success">
                                        <i class="fas fa-file-excel"></i> Importar do Excel
                                    </a>
                                    <a href="{{ route('admin.download.marks.template') }}" class="btn btn-outline-info">
                                        <i class="fas fa-download"></i> Baixar Modelo
                                    </a>
                                </div>
                            </div>

                            <!-- Selection Form -->
                            <div class="row mb-4">
                                <!-- Year selection should come first -->
                                <div class="col-md-2">
                                    <label for="year" class="form-label">Ano</label>
                                    <select class="form-control @error('year') is-invalid @enderror"
                                            wire:model="year">
                                        <option value="">Selecione o ano</option>
                                        @php
                                            $currentYear = (int)date('Y');
                                            $startYear = $currentYear;
                                            $endYear = $currentYear + 2;   // 2 years into future
                                        @endphp

                                        @for($year = $startYear; $year <= $endYear; $year++)
                                            <option value="{{ $year }}" {{ $year == $currentYear ? 'selected' : '' }}>{{ $year }}</option>
                                        @endfor
                                    </select>
                                    @error('year')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- Trimester selection -->
                                <div class="col-md-2">
                                    <label for="trimester_id" class="form-label">Trimestre</label>
                                    <select class="form-control @error('trimester_id') is-invalid @enderror"
                                            wire:model="trimester_id"
                                            {{ empty($year) ? 'disabled' : '' }}>
                                        <option value="">Selecione o trimestre</option>
                                        <option value="1">Primeiro trimestre</option>
                                        <option value="2">Segundo trimestre</option>
                                        <option value="3">Terceiro trimestre</option>
                                    </select>
                                    @error('trimester_id')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- Class Level Selection -->
                                <div class="col-md-2">
                                    <label for="class_level" class="form-label">Classe</label>
                                    <select class="form-control @error('class_level') is-invalid @enderror"
                                            wire:model="class_level"
                                            {{ empty($year) || empty($trimester_id) ? 'disabled' : '' }}>
                                        <option value="">Selecione a classe</option>

                                        @if($isTeacher && !empty($availableClassLevels))
                                            @foreach($availableClassLevels as $classLevel)
                                                <option value="{{ $classLevel }}">{{ $classLevel }}ª Classe</option>
                                            @endforeach
                                        @else
                                            <!-- Admin sees all classes -->
                                            <option value="1">1ª Classe</option>
                                            <option value="2">2ª Classe</option>
                                            <option value="3">3ª Classe</option>
                                            <option value="4">4ª Classe</option>
                                            <option value="5">5ª Classe</option>
                                            <option value="6">6ª Classe</option>
                                            <option value="7">7ª Classe</option>
                                            <option value="8">8ª Classe</option>
                                            <option value="9">9ª Classe</option>
                                            <option value="10">10ª Classe</option>
                                            <option value="11">11ª Classe</option>
                                            <option value="12">12ª Classe</option>
                                        @endif
                                    </select>
                                    @error('class_level')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- Classroom Selection -->
                                <div class="col-md-2">
                                    <label for="classroom_id" class="form-label">Turma</label>
                                    <select class="form-control @error('classroom_id') is-invalid @enderror"
                                            wire:model="classroom_id"
                                            {{ empty($class_level) ? 'disabled' : '' }}>
                                        <option value="">Selecione a turma</option>
                                        @foreach ($classrooms as $classroom)
                                            <option value="{{ $classroom->id }}">{{ $classroom->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('classroom_id')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- Subject Selection -->
                                <div class="col-md-2">
                                    <label for="subject_id" class="form-label">Disciplina</label>
                                    <select class="form-control @error('subject_id') is-invalid @enderror"
                                            wire:model="subject_id"
                                            {{ empty($classroom_id) ? 'disabled' : '' }}>
                                        <option value="">Selecione a disciplina</option>
                                        @foreach ($subjects as $subject)
                                            <option value="{{ $subject->id }}">{{ $subject->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('subject_id')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- Test Type Selection -->
                                <div class="col-md-2">
                                    <label for="testType" class="form-label">Tipo de Teste</label>
                                    <select class="form-control @error('testType') is-invalid @enderror"
                                            wire:model="testType"
                                            {{ empty($subject_id) ? 'disabled' : '' }}>
                                        <option value="">Selecione o tipo</option>
                                        <option value="1">ACS1</option>
                                        <option value="2">ACS2</option>
                                        <option value="3">AT</option>
                                        <option value="4">NE</option>
                                    </select>
                                    @error('testType')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <button class="btn btn-primary mb-4" wire:click="loadStudents"
                                            {{ empty($testType) ? 'disabled' : '' }}>
                                        <span wire:loading wire:target="loadStudents" class="spinner-border spinner-border-sm"></span>
                                        Carregar Estudantes
                                    </button>
                                </div>
                            </div>

                            <!-- Students Table -->
                            @if($loadedStudents && count($students) > 0)
                                <div class="table-responsive">
                                    <form wire:submit.prevent="saveMarks">
                                        <div class="alert alert-info mb-3">
                                            <i class="fas fa-info-circle mr-1"></i> As notas devem ser entre 0 e 20. Use ponto (.) ou vírgula (,) para decimais. Exemplo: 15.75 ou 15,75
                                        </div>

                                        @php
                                        $hasPermissionIssues = !empty(array_filter($permissionDenied ?? []));
                                        @endphp

                                        @if($hasPermissionIssues)
                                            <div class="alert alert-warning mb-3">
                                                <i class="fas fa-exclamation-triangle mr-1"></i> <strong>Atenção:</strong> Alguns estudantes já têm notas maiores que 0 para este tipo de teste.
                                                Se tentar atualizar essas notas, você precisará confirmar a substituição ou elas serão ignoradas.
                                                <br>
                                                <small>Campos marcados com <span class="text-warning">⚠</span> já contêm valores.</small>
                                            </div>
                                        @endif

                                        <table class="table table-hover">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Nome do Estudante</th>
                                                <th>ID do Estudante</th>
                                                <th>Nota</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($students as $index => $student)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $student->name }}</td>
                                                    <td>{{ $student->student_id }}</td>
                                                    <td style="width: 150px;">
                                                        <div class="input-group">
                                                            @if(isset($permissionDenied[$student->id]) && $permissionDenied[$student->id])
                                                                <div class="input-group-prepend">
                                                                    <span class="input-group-text text-warning" title="Este estudante já tem uma nota maior que 0 para este tipo de teste">⚠</span>
                                                                </div>
                                                            @endif
                                                            <input type="text"
                                                                class="form-control @error('marks.'.$student->id) is-invalid @enderror @if(isset($permissionDenied[$student->id]) && $permissionDenied[$student->id]) border-warning @endif"
                                                                wire:model.defer="marks.{{ $student->id }}"
                                                                placeholder="0-20"
                                                                pattern="^\d{1,2}([.,]\d{1,2})?$"
                                                                title="Entre com um valor entre 0 e 20 com até 2 casas decimais (ex: 4.75)">
                                                        </div>
                                                        @error('marks.'.$student->id)
                                                        <span class="invalid-feedback">{{ $message }}</span>
                                                        @enderror
                                                    </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>

                                        <div class="d-flex justify-content-end mt-3">
                                            <button type="submit" class="btn btn-success btn-lg" wire:loading.attr="disabled">
                                                <span wire:loading wire:target="saveMarks" class="spinner-border spinner-border-sm"></span>
                                                Salvar Todas as Notas
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            @elseif($loadedStudents && count($students) == 0)
                                <div class="alert alert-warning">
                                    Nenhum estudante encontrado para a turma selecionada.
                                </div>
                            @endif

                            <!-- Loading Indicator -->
                            <div wire:loading wire:target="loadStudents" class="d-flex justify-content-center my-4">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="sr-only">Carregando estudantes...</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
