 {{-- Ficheiro: resources/views/livewire/admin/student-finance-details.blade.php --}}
<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="student-header">
                <div class="student-info-card">
                    <div class="student-avatar">{{ strtoupper(substr(preg_replace('/(\B.|\s)/', '', $student->name), 0, 2)) }}</div>
                    <div class="student-details">
                        <h2>{{ $student->name }}</h2>
                        <p>ID: <strong>{{ $student->student_id }}</strong> | Classe: <strong>{{ $student->class->class ?? 'N/A' }}</strong> | Turma: <strong>{{ $student->class->name ?? 'N/A' }}</strong></p>
                    </div>
                    <div class="year-filter-wrapper">
                        <label for="yearFilter" class="form-label text-white">Ano Letivo</label>
                        <select id="yearFilter" class="form-select" wire:model="selectedYear">
                            @for ($i = now()->year; $i >= now()->year - 3; $i--)
                                <option value="{{ $i }}">{{ $i }}</option>
                            @endfor
                        </select>
                    </div>
                </div>
            </div>

            @php
                // LÓGICA FINANCEIRA COMPLETA PARA ALIMENTAR OS WIDGETS E A TABELA
                $currentYear = $selectedYear ?? now()->year;
                $now = \Carbon\Carbon::now();
                $months = ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'];

               $customOrder = [
    1 => 'Janeiro',
    2 => 'Fevereiro',
    3 => 'Março',
    4 => 'Abril',
    5 => 'Maio',
    6 => 'Junho',
    7 => 'Julho',
    8 => 'Agosto',
    9 => 'Setembro',
    10 => 'Outubro',
    11 => 'Novembro',
    12 => 'Dezembro'
];
                $totalAnnualValue = 0; $totalPaid = 0; $totalDue = 0; $totalOverdueBase = 0;
                $totalPenaltiesDue = 0; $totalFinesPaid = 0; $totalDiscountsGiven = 0;
                $monthsWithFees = 0; $monthsPaidCount = 0;

                $paidFeesLookup = [];
                if (isset($fees)) { foreach ($fees as $paidFee) { $paidFeesLookup[$paidFee->month] = $paidFee; } }

                foreach ($months as $index => $month) {
                    $baseAmount = 0; $paymentDueDate = null;
                    if (isset($feestructures)) {
                        foreach ($feestructures as $feeStructure) {
                            if (in_array($month, explode(',', $feeStructure->months))) {
                                $baseAmount += $feeStructure->monthly_fee;
                                $dueDateDay = $feeStructure->payment_due_day ?? 15;
                                $paymentDueDate = \Carbon\Carbon::createFromDate($currentYear, $index + 1, $dueDateDay)->endOfDay();
                            }
                        }
                    }
                    if ($baseAmount == 0) continue;
                    $monthsWithFees++; $totalAnnualValue += $baseAmount;

                    if (isset($paidFeesLookup[$month])) {
                        $paidFee = $paidFeesLookup[$month];
                        $totalPaid += $paidFee->amount; $totalFinesPaid += $paidFee->fine ?? 0;
                        $totalDiscountsGiven += $paidFee->discount ?? 0; $monthsPaidCount++;
                    } else {
                        if ($paymentDueDate && $now->gt($paymentDueDate) && $currentYear <= $now->year) {
                            $totalOverdueBase += $baseAmount;
                            foreach ($feestructures as $feeStructure) {
                                if (in_array($month, explode(',', $feeStructure->months))) {
                                     if ($feeStructure->penalty_type == 'fixed') $totalPenaltiesDue += $feeStructure->late_penalty_percentage ?? 0;
                                     else $totalPenaltiesDue += ($feeStructure->monthly_fee * ($feeStructure->late_penalty_percentage ?? 0)) / 100;
                                }
                            }
                        } else { $totalDue += $baseAmount; }
                    }
                }
                $paymentRate = ($monthsWithFees > 0) ? round(($monthsPaidCount / $monthsWithFees) * 100) : 0;
            @endphp

            <div class="summary-widgets-grid">
                <div class="summary-widget">
                    <div class="icon-wrapper total"><i class="fas fa-calendar-alt"></i></div>
                    <div class="text-wrapper"><span class="label">Total Anual (Base)</span><span class="value">{{ number_format($totalAnnualValue, 2, ',', '.') }} MT</span></div>
                </div>

                <div class="summary-widget">
                    <div class="icon-wrapper paid"><i class="fas fa-wallet"></i></div>
                    <div class="text-wrapper"><span class="label">Total Arrecadado</span><span class="value">{{ number_format($totalPaid, 2, ',', '.') }} MT</span></div>
                </div>
                <div class="summary-widget">
                    <div class="icon-wrapper due"><i class="fas fa-hourglass-half"></i></div>
                    <div class="text-wrapper"><span class="label">Pendente (no prazo)</span><span class="value">{{ number_format($totalDue, 2, ',', '.') }} MT</span></div>
                </div>
                <div class="summary-widget">
                    <div class="icon-wrapper overdue"><i class="fas fa-clock"></i></div>
                    <div class="text-wrapper"><span class="label">Em Atraso (base)</span><span class="value">{{ number_format($totalOverdueBase, 2, ',', '.') }} MT</span></div>
                </div>
                <div class="summary-widget">
                    <div class="icon-wrapper fines"><i class="fas fa-exclamation-triangle"></i></div>
                    <div class="text-wrapper"><span class="label">Multas Pagas</span><span class="value">{{ number_format($totalFinesPaid, 2, ',', '.') }} MT</span></div>
                </div>
                <div class="summary-widget">
                    <div class="icon-wrapper discounts"><i class="fas fa-tags"></i></div>
                    <div class="text-wrapper"><span class="label">Descontos Concedidos</span><span class="value">{{ number_format($totalDiscountsGiven, 2, ',', '.') }} MT</span></div>
                </div>
                <div class="summary-widget compliance">
                    <span class="label">Taxa de Cumprimento</span>
                    <div class="progress mt-1" style="height: 8px;">
                        <div class="progress-bar" role="progressbar" style="width: {{ $paymentRate }}%;" aria-valuenow="{{ $paymentRate }}">{{ $paymentRate }}%</div>
                    </div>
                    <small class="description">{{ $monthsPaidCount }} de {{ $monthsWithFees }} meses pagos</small>
                </div>
            </div>
            
            <div class="fee-section">
                <div class="section-header">
                    <h2><i class="fas fa-list-alt"></i> Extrato Detalhado de Mensalidades</h2>

                    <!-- Wrapper para todos os controlos (filtros e exportação) -->
                    <div class="header-actions">
                        
                        <!-- Seus filtros existentes -->
                        <div class="fee-filters">
                            <button class="filter-btn active" data-filter="all">Todos</button>
                            <button class="filter-btn" data-filter="paid">Pagos</button>
                            <button class="filter-btn" data-filter="pending">Pendentes</button>
                            <button class="filter-btn" data-filter="overdue">Atrasados</button>
                        </div>

                        <!-- Novos botões de exportação, inspirados no seu guia -->
                        <div class="btn-group" role="group" aria-label="Ações de Exportação">
                            <a href="{{ route('admin.statement.download', ['student_id' => $student->id]) }}"
                               class="btn btn-primary btn-sm"
                               target="_blank">
                                <i class="fas fa-file-pdf me-1"></i>Baixar Extrato (PDF)
                            </a>
                            <button class="btn btn-danger btn-sm" wire:click="exportPdf">
                                <i class="fas fa-file-pdf me-1"></i>Baixar Histórico (PDF)
                            </button>
                            <button class="btn btn-info btn-sm text-white" onclick="window.print()">
                                <i class="fas fa-print me-1"></i>Imprimir Página
                            </button>
                        </div>

                    </div>
                </div>
                <div class="fee-table-container">
                    <table class="table table-hover fee-table">
                        <thead>
                            <tr>
                                <th>Período</th>
                                <th>Taxas</th>
                                <th>Vencimento</th>
                                <th>Estado</th>
                                <th>Valor Base</th>
                                <th>Multa</th>
                                <th>Desconto</th>
                                <th>Valor Pago</th>
                                <th>Data/Hora</th>
                                <th class="text-center">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                             @forelse ($months as $index => $month)
                                @php
                                    $baseAmount = 0; $calculatedFine = 0; $feeNames = []; $paymentDueDate = null;
                                    if(isset($feestructures)) {
                                        foreach ($feestructures as $feeStructure) {
                                            if (in_array($month, explode(',', $feeStructure->months))) {
                                                $baseAmount += $feeStructure->monthly_fee;
                                                $feeNames[] = $feeStructure->fee_name;
                                                $dueDateDay = $feeStructure->payment_due_day ?? 15;
                                                $paymentDueDate = \Carbon\Carbon::createFromDate($currentYear, $index + 1, $dueDateDay)->endOfDay();
                                            }
                                        }
                                    }
                                    if ($baseAmount == 0) continue;

                                    $isPaid = isset($paidFeesLookup[$month]);
                                    $paidFine = 0; 
                                    $givenDiscount = 0;
                                    $isOverdue = !$isPaid && $paymentDueDate && $now->gt($paymentDueDate) && $currentYear <= $now->year;
                                    
                                    if ($isPaid) {
                                        $paidFine = $paidFeesLookup[$month]->fine ?? 0;
                                        $givenDiscount = $paidFeesLookup[$month]->discount ?? 0;
                                    } elseif ($isOverdue) {
                                        foreach ($feestructures as $feeStructure) {
                                            if (in_array($month, explode(',', $feeStructure->months))) {
                                                // Calculate penalty
                                                if ($feeStructure->penalty_type == 'fixed') {
                                                    $calculatedFine += $feeStructure->late_penalty_percentage ?? 0;
                                                } else {
                                                    $calculatedFine += ($feeStructure->monthly_fee * ($feeStructure->late_penalty_percentage ?? 0)) / 100;
                                                }
                                            }

                                            
                                                // Calculate discounts
                                                foreach ($discounts as $discount) {
                                                       
                                                      
                                                        if (in_array($month, explode(',',  $discount->months ))) {

                                                            if ($discount->discount_type == 'fixed') {
                                                                $givenDiscount -= $discount->amount ?? 0;
                                                            } else {
                                                                $givenDiscount += ($feeStructure->monthly_fee * ($discount->percentage ?? 0)) / 100;
                                                            }
                                                        }
                                                    
                                            }
                                        }

                                    }else{

                                         foreach ($feestructures as $feeStructure) {
                                          
                                            
                                                // Calculate discounts
                                                foreach ($discounts as $discount) {
                                                       
                                                      
                                                        if (in_array($month, explode(',',  $discount->months ))) {

                                                            if ($discount->discount_type == 'fixed') {
                                                                $givenDiscount -= $discount->amount ?? 0;
                                                            } else {
                                                                $givenDiscount += ($feeStructure->monthly_fee * ($discount->percentage ?? 0)) / 100;
                                                            }
                                                        }
                                                    
                                            }
                                        }

                                    }
                                    $statusClass = $isPaid ? 'paid' : ($isOverdue ? 'overdue' : 'pending');

                                    // Mês já está em português
                                    $monthPt = $month;
                                @endphp
                                <tr class="table-row row-{{$statusClass}}" data-status="{{$statusClass}}">
                                    <td data-label="Período"><strong>{{ $monthPt }}</strong><br><small>{{ $currentYear }}</small></td>
                                    <td data-label="Taxas">@forelse($feeNames as $name)<span class="fee-badge">{{$name}}</span>@empty - @endforelse</td>
                                    <td data-label="Vencimento">{{ $paymentDueDate ? $paymentDueDate->format('d/m/Y') : 'N/A' }}</td>
                                    <td data-label="Estado">
                                        @if($isPaid) <span class="status-badge status-paid"><i class="fas fa-check-circle me-1"></i>Pago</span>
                                        @elseif($isOverdue) <span class="status-badge status-overdue"><i class="fas fa-exclamation-triangle me-1"></i>Em Atraso</span>
                                        @else <span class="status-badge status-pending"><i class="fas fa-clock me-1"></i>Pendente</span>
                                        @endif
                                    </td>
                                    <td data-label="Valor Base">{{ number_format($baseAmount, 2, ',', '.') }}</td>
                                    <td data-label="Multa" class="text-danger fw-bold">{{ number_format($isPaid ? $paidFine : $calculatedFine, 2, ',', '.') }}</td>
                                    <td data-label="Desconto" class="text-success fw-bold">{{ number_format($givenDiscount, 2, ',', '.') }}</td>
                                        @php
                                            $displayPaid = '0,00';
                                            $isReference = false;

                                            if ($isPaid) {
                                                $p = $paidFeesLookup[$month];

                                                // detecta pagamentos via entidade/referência
                                                $isReference = (($p->pay_type ?? null) === 'reference')
                                                               || (($p->paymentMode ?? null) === 'Reference');

                                                // SEMPRE mostra total efetivo: base + multa - desconto
                                                $totalPaid = ($p->amount ?? 0) + ($p->fine ?? 0) - ($p->discount ?? 0);
                                                $displayPaid = number_format($totalPaid, 2, ',', '.');
                                            }
                                        @endphp

                                        <td data-label="Valor Pago">
                                            <strong>{{ $displayPaid }}</strong>
                                            @if($isPaid && $isReference)
                                                <br>
                                                <small class="text-muted">
                                                    {{ number_format(($paidFeesLookup[$month]->amount ?? 0), 2, ',', '.') }}
                                                    + {{ number_format(($paidFeesLookup[$month]->fine ?? 0), 2, ',', '.') }}
                                                    @if(($paidFeesLookup[$month]->discount ?? 0) > 0)
                                                        − {{ number_format(($paidFeesLookup[$month]->discount ?? 0), 2, ',', '.') }}
                                                    @endif
                                                </small>
                                            @endif
                                        </td>

                                    <td data-label="Data de Pagamento">
                                        @if($isPaid && !empty($paidFeesLookup[$month]->created_at))
                                        {{ \Carbon\Carbon::parse($paidFeesLookup[$month]->created_at)->format('d/m/Y H:i') }}
                                        @else
                                        --
                                        @endif
                                    </td>
                                    <td data-label="Ações" class="text-center">
                                        @if(!$isPaid)
                                            <button onclick="openPaymentModal('{{ $month }}', {{ $currentYear }}, {{ $baseAmount }}, {{ $calculatedFine }} , {{   $givenDiscount }})" class="btn btn-primary btn-sm btn-pay">
                                                <i class="fas fa-plus-circle me-1"></i>Pagar
                                            </button>
                                        @else
                                            <div class="d-flex align-items-center justify-content-center gap-2">
                                                <span class="badge bg-success" style="font-size: 0.9rem; padding: 0.5rem 0.8rem;">
                                                    <i class="fas fa-check-circle me-1"></i>PAGO
                                                </span>
                                                @php
                                                    // Busca o pagamento (Fee_assign) para este mês
                                                    $payment = isset($paidFeesLookup[$month]) ? $paidFeesLookup[$month] : null;
                                                @endphp
                                                @if($payment)
                                                    <button
                                                        wire:click="downloadPaymentReceipt('{{ $payment->id }}')"
                                                        class="btn btn-success btn-sm"
                                                        title="Baixar recibo de pagamento">
                                                        <i class="fas fa-receipt me-1"></i>Recibo
                                                    </button>
                                                @endif
                                            </div>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr><td colspan="9" class="text-center p-4">Nenhuma estrutura de taxas encontrada para o ano de {{ $currentYear }}.</td></tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <div class="modal fade" id="collectFeeModal" tabindex="-1" role="dialog" aria-labelledby="collectFeeModalLabel" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content payment-modal">
                <form wire:submit.prevent="collectFee">
                    <div class="modal-header payment-header">
                        <div class="header-content">
                            <div class="header-icon"><i class="fas fa-credit-card"></i></div>
                            <div class="header-text"><h5 class="modal-title" id="collectFeeModalLabel">Processar Pagamento de Taxa</h5><p class="modal-subtitle">Sistema seguro de cobrança académica</p></div>
                        </div>
                        <button type="button" class="btn-close-custom" data-bs-dismiss="modal" aria-label="Close"><i class="fas fa-times"></i></button>
                    </div>
                    <div class="modal-body payment-body">
                        <input type="hidden" wire:model.defer="month" id="hidden_month">
                        <input type="hidden" wire:model.defer="year" id="hidden_year">
                        <div class="payment-overview">
                            <div class="overview-card student-card">
                                <div class="card-header"><h6><i class="fas fa-user-graduate me-2"></i>Informações do Estudante</h6></div>
                                <div class="card-content"><div class="row">
                                    <div class="col-md-6"><div class="info-group"><label>Nome Completo</label><span>{{ $student->name }}</span></div></div>
                                    <div class="col-md-6"><div class="info-group"><label>ID do Estudante</label><span>{{ $student->student_id }}</span></div></div>
                                    <div class="col-md-6"><div class="info-group"><label>Classe</label><span>{{ $student->class->class ?? 'N/A' }}</span></div></div>
                                    <div class="col-md-6"><div class="info-group"><label>Turma</label><span>{{ $student->class->name ?? 'N/A' }}</span></div></div>
                                </div>
                                </div>
                            </div>
                        </div>
                        <div class="payment-form-section">
                            <div class="section-header"><h6><i class="fas fa-calculator me-2"></i>Cálculo de Pagamento</h6></div>
                            <div class="row">
                                <div class="col-md-6"><div class="form-group-enhanced"><label class="form-label-enhanced"><i class="fas fa-money-bill-wave text-primary me-2"></i>Montante Base</label><div class="input-group-enhanced"><input type="number" class="form-control-enhanced" id="modal_amount_base" readonly></div></div></div>
                                <div class="col-md-6"><div class="form-group-enhanced"><label for="modal_fine" class="form-label-enhanced"><i class="fas fa-exclamation-triangle text-warning me-2"></i>Multa/Juros</label><div class="input-group-enhanced"><input type="number" step="0.01" class="form-control-enhanced" id="modal_fine" readonly></div></div></div>
                                <div class="col-md-6"><div class="form-group-enhanced"><label for="modal_discount" class="form-label-enhanced"><i class="fas fa-percentage text-success me-2"></i>Desconto a Aplicar</label><div class="input-group-enhanced"><input type="number" step="0.01" class="form-control-enhanced" id="modal_discount" wire:model.defer="discount" min="0"></div></div></div>
                                <div class="col-md-6">
                                    <div class="form-group-enhanced">
                                        <label class="form-label-enhanced">
                                            <i class="fas fa-credit-card text-info me-2"></i>Método de Pagamento
                                        </label>
                                        <div class="select-enhanced">
                                            <select class="form-control-enhanced" wire:model.live="paymentMode" required>
                                                <option value="Cash">Dinheiro</option>
                                                <option value="POS">POS</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                @if($paymentMode === 'POS')
                                <div class="col-md-6">
                                    <div class="form-group-enhanced">
                                        <label for="transaction_id" class="form-label-enhanced">
                                            <i class="fas fa-hashtag text-primary me-2"></i>Transaction ID (POS) *
                                        </label>
                                        <div class="input-group-enhanced">
                                            <input type="text" class="form-control-enhanced" wire:model.defer="transactionId" placeholder="Digite o ID da transação POS" required>
                                        </div>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                        <div class="payment-summary-section">
                             <div class="total-display"><div class="total-label">Total a Pagar</div><div class="total-amount" id="total-amount-display">0,00 MT</div><input type="hidden" wire:model.defer="amount" id="hidden_total_amount"></div>
                        </div>
                    </div>
                    <div class="modal-footer payment-footer">
                        <button type="button" class="btn btn-cancel" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-confirm" wire:loading.attr="disabled"><span wire:loading.remove>Confirmar Pagamento</span><span wire:loading><i class="fas fa-spinner fa-spin"></i> Processando...</span></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap');
    :root { --primary-color: #667eea; --success-color: #28a745; --warning-color: #ffc107; --danger-color: #dc3545; --info-color: #0dcaf0; }
    .page-content { background: #f4f7f6; font-family: 'Poppins', sans-serif; }
    .main-wrapper { max-width: 1600px; margin: 0 auto; }
    .student-header { background: linear-gradient(135deg, var(--primary-color) 0%, #764ba2 100%); color: #fff; padding: 25px; border-radius: 18px; margin-bottom: 30px; box-shadow: 0 10px 30px rgba(0,0,0,.1); }
    .student-info-card { display: flex; align-items: center; gap: 20px; flex-wrap: wrap; }
    .student-avatar { width: 70px; height: 70px; border-radius: 50%; background: #fff; color: var(--primary-color); display: flex; align-items: center; justify-content: center; font-size: 28px; font-weight: 700; flex-shrink: 0; }
    .student-details { flex-grow: 1; } .student-details h2 { margin: 0 0 5px; font-size: 26px; font-weight: 600; }
    .year-filter-wrapper { margin-left: auto; background: rgba(255, 255, 255, 0.1); padding: 8px 12px; border-radius: 12px; }
    .year-filter-wrapper .form-select { background-color: transparent; color: white; border: 1px solid rgba(255, 255, 255, 0.3); font-weight: 600; padding: 5px 10px; }
    .year-filter-wrapper .form-select option { color: #333; }
    
    .summary-widgets-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-bottom: 30px; }
    .summary-widget { background: #fff; border-radius: 15px; padding: 20px; box-shadow: 0 8px 25px rgba(0,0,0,.05); display: flex; align-items: center; gap: 15px; }
    .summary-widget .icon-wrapper { font-size: 24px; width: 50px; height: 50px; border-radius: 50%; display: flex; align-items: center; justify-content: center; color: #fff; flex-shrink: 0; }
    .summary-widget .icon-wrapper.total { background: #6c757d; } .summary-widget .icon-wrapper.paid { background: var(--success-color); }
    .summary-widget .icon-wrapper.due { background: var(--primary-color); } .summary-widget .icon-wrapper.overdue { background: var(--warning-color); }
    .summary-widget .icon-wrapper.fines { background: var(--danger-color); } .summary-widget .icon-wrapper.discounts { background: var(--info-color); }
    .summary-widget .text-wrapper { flex-grow: 1; }
    .summary-widget .label { font-size: 13px; color: #666; margin-bottom: 2px; display: block; }
    .summary-widget .value { font-size: 22px; font-weight: 700; color: #333; }
    .summary-widget.compliance { display: block; }
    .summary-widget.compliance .progress-bar { background-color: var(--primary-color); }
    .summary-widget.compliance .description { font-size: 12px; color: #888; margin-top: 5px; }

    .fee-section { background: #fff; border-radius: 18px; padding: 25px; box-shadow: 0 5px 20px rgba(0,0,0,.08); }
    .section-header { display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px; margin-bottom: 25px; padding-bottom: 15px; border-bottom: 1px solid #eee; }
    .section-header h2 { font-size: 20px; font-weight: 600; }
    .fee-filters { display: flex; gap: 10px; }
    .filter-btn { padding: 8px 16px; border: 1px solid #ddd; border-radius: 20px; background: #fff; cursor: pointer; transition: all .3s ease; font-size: 14px; font-weight: 500; }
    .filter-btn.active, .filter-btn:hover { background: var(--primary-color); color: #fff; border-color: var(--primary-color); }
    .fee-table-container { overflow-x: auto; } .fee-table { width: 100%; border-collapse: collapse; }
    .fee-table thead th { text-align: left; padding: 15px 12px; font-size: 12px; font-weight: 600; color: #666; border-bottom: 2px solid #f0f2f5; text-transform: uppercase; }
    .fee-table tbody tr { transition: background-color 0.2s ease; } .fee-table tbody tr:hover { background-color: #f8f9fa; }
    .fee-table tbody td { padding: 12px; border-bottom: 1px solid #f0f2f5; vertical-align: middle; font-size: 14px; }
    .fee-badge { background: #e3f2fd; color: #1565c0; padding: 4px 8px; border-radius: 12px; font-size: 11px; }
    .status-badge { padding: 6px 12px; border-radius: 20px; font-size: 11px; font-weight: 600; display: inline-flex; align-items: center; gap: 5px;}
    .status-paid { background: #e8f5e9; color: #2e7d32; } .status-pending { background: #e3f2fd; color: #1565c0; }
    .status-overdue { background: #fff3e0; color: #f57c00; }
    .gap-2 { gap: 0.5rem; }
    .badge.bg-success { background-color: #28a745 !important; color: white; padding: 6px 12px; font-size: 12px; font-weight: 600; }
    /* Estilos do Modal (completos) */
    .payment-modal { border-radius: 15px; box-shadow: 0 20px 60px rgba(0,0,0,0.3); }
    .payment-header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 25px 30px; border: none; }
    .header-content { display: flex; align-items: center; }
    .header-icon { width: 50px; height: 50px; background: rgba(255,255,255,0.2); border-radius: 12px; display: flex; align-items: center; justify-content: center; margin-right: 15px; font-size: 20px; }
    .header-text h5 { font-size: 22px; font-weight: 700; margin: 0; } .modal-subtitle { opacity: 0.9; margin: 3px 0 0 0; font-size: 14px; }
    .btn-close-custom { background: rgba(255,255,255,0.2); border: none; width: 35px; height: 35px; border-radius: 50%; color: white; font-size: 16px; transition: all 0.3s ease; }
    .btn-close-custom:hover { background: rgba(255,255,255,0.3); transform: rotate(90deg); }
    .payment-body { padding: 30px; background: #f8f9fa; } .payment-overview { margin-bottom: 20px; }
    .overview-card { background: white; border-radius: 12px; box-shadow: 0 4px 15px rgba(0,0,0,0.08); }
    .overview-card .card-header { background: #f8f9fa; padding: 15px 20px; border-bottom: 1px solid #e0e0e0; }
    .overview-card .card-header h6 { margin: 0; font-weight: 600; font-size: 14px; }
    .overview-card .card-content { padding: 20px; }
    .info-group label { display: block; font-size: 11px; color: #666; text-transform: uppercase; font-weight: 600; }
    .info-group span { font-size: 15px; font-weight: 600; color: #333; }
    .payment-form-section { background: white; border-radius: 12px; padding: 25px; margin-bottom: 25px; box-shadow: 0 4px 15px rgba(0,0,0,0.08); }
    .form-group-enhanced { margin-bottom: 20px; }
    .form-label-enhanced { display: flex; align-items: center; font-weight: 600; color: #333; margin-bottom: 8px; font-size: 14px; }
    .input-group-enhanced { display: flex; }
    .form-control-enhanced { border: 1px solid #e0e0e0; padding: 10px 15px; font-size: 15px; flex: 1; outline: none; transition: all 0.3s ease; border-radius: 8px; }
    .form-control-enhanced:focus { border-color: #667eea; box-shadow: 0 0 0 2px rgba(102, 126, 234, 0.2); }
    .form-control-enhanced[readonly] { background-color: #e9ecef; cursor: not-allowed; }
    .payment-summary-section { background: white; border-radius: 12px; padding: 25px; box-shadow: 0 4px 15px rgba(0,0,0,0.08); border: 2px solid #e3f2fd; text-align: center; }
    .total-display .total-label { font-size: 14px; margin-bottom: 8px; text-transform: uppercase; font-weight: 600; }
    .total-display .total-amount { font-size: 36px; font-weight: 900; }
    .payment-footer { background: #f8f9fa; padding: 20px 30px; border-top: 1px solid #e0e0e0; display: flex; justify-content: flex-end; gap: 15px; }
    .btn-cancel, .btn-confirm { padding: 12px 25px; border-radius: 8px; font-weight: 600; border: none; }
    .btn-cancel { background: #6c757d; color: white; }
    .btn-confirm { background: linear-gradient(45deg, #4caf50, #8bc34a); color: white; }
    .section-header { display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 20px; }
    .header-actions { display: flex; align-items: center; flex-wrap: wrap; gap: 20px; }
    .btn-group .btn-sm { font-size: 14px; padding: 8px 16px; }
    @media (max-width: 992px) {
        .fee-table thead { display: none; }
        .fee-table tbody tr { display: block; margin-bottom: 15px; border: 1px solid #e9ecef; border-radius: 10px; padding: 15px; }
        .fee-table tbody td { display: flex; justify-content: space-between; align-items: center; padding: 10px 0; border-bottom: 1px solid #f1f3f4; }
        .fee-table tbody td:last-child { border-bottom: none; }
        .fee-table tbody td::before { content: attr(data-label); font-weight: 600; color: #495057; min-width: 100px; }
    }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
                          
    const filterButtons = document.querySelectorAll('.filter-btn');
    const paymentModalEl = document.getElementById('collectFeeModal');
                          
    if (filterButtons.length > 0) {
        const tableRows = document.querySelectorAll('.fee-table tbody tr[data-status]');
        filterButtons.forEach(button => {
            button.addEventListener('click', function() {
                filterButtons.forEach(btn => btn.classList.remove('active'));
                this.classList.add('active');
                const filterValue = this.getAttribute('data-filter');
                tableRows.forEach(row => {
                    const displayStyle = (filterValue === 'all' || row.getAttribute('data-status') === filterValue)
                        ? (window.innerWidth <= 992 ? 'block' : 'table-row')
                        : 'none';
                    row.style.display = displayStyle;
                });
            });
        });
    }

    
    if (paymentModalEl) {
        const paymentModal = new bootstrap.Modal(paymentModalEl);
        const modalElements = {
            amountBase: document.getElementById('modal_amount_base'),
            fine: document.getElementById('modal_fine'),
            discount: document.getElementById('modal_discount'),
            totalDisplay: document.getElementById('total-amount-display'),
            hiddenTotalAmount: document.getElementById('hidden_total_amount'),
        };

        const updateModalTotal = () => {
            const base = parseFloat(modalElements.amountBase.value) || 0;
            const fine = parseFloat(modalElements.fine.value) || 0;
            const discount = parseFloat(modalElements.discount.value) || 0;
            const maxDiscount = base + fine;
            const validDiscount = Math.max(0, Math.min(discount, maxDiscount));
            if (discount !== validDiscount) modalElements.discount.value = validDiscount.toFixed(2);
            const total = base + fine - validDiscount;
            modalElements.totalDisplay.textContent = total.toLocaleString('pt-MZ', { style: 'currency', currency: 'MZN' });
            if (window.Livewire) {
                @this.set('amount', total.toFixed(2), true);
                @this.set('fine', fine.toFixed(2), true);
                @this.set('discount', validDiscount.toFixed(2), true);
            }
        };

        // Apenas desconto é editável, multa é calculada automaticamente
        ['input', 'change'].forEach(evt => {
            modalElements.discount.addEventListener(evt, updateModalTotal);
        });

        // Listener para mudança de método de pagamento (Livewire)
        window.addEventListener('paymentModeChanged', () => {
            console.log('Método de pagamento mudou - recalculando total');
            updateModalTotal();
        });

        window.openPaymentModal = function(month, year, baseAmount, fine, discount) {
            modalElements.amountBase.value = baseAmount.toFixed(2);
            modalElements.fine.value = fine.toFixed(2);
            modalElements.discount.value =  discount.toFixed(2);
            if (window.Livewire) {
                @this.set('month', month, true);
                @this.set('year', year, true);
                @this.set('fine', fine.toFixed(2), true);
                @this.set('discount', discount.toFixed(2), true);
            }
            updateModalTotal();
            paymentModal.show();
        };
    }

    if (window.Livewire) {
        // Fechar modal após salvar pagamento
        window.addEventListener('closeModal', () => {
            const modalInstance = bootstrap.Modal.getInstance(paymentModalEl);
            if (modalInstance) {
                modalInstance.hide();
            }
            // Recarregar página para mostrar dados atualizados
            setTimeout(() => {
                window.location.reload();
            }, 500);
        });

        window.addEventListener('paymentSuccess', event => {
            const modalInstance = bootstrap.Modal.getInstance(paymentModalEl);
            if(modalInstance) modalInstance.hide();
            Swal.fire({ icon: 'success', title: 'Sucesso!', text: event.detail.message, timer: 2500, showConfirmButton: false })
               .then(() => { window.location.reload(); });
        });
        window.addEventListener('paymentError', event => {
            Swal.fire({ icon: 'error', title: 'Erro!', text: event.detail.message });
        });

        // Event listeners para download de comprovativo e recibo
        window.addEventListener('download-receipt', event => {
            const data = event.detail;
            if (data.url) {
                window.open(data.url, '_blank');
                if (data.message) {
                    Swal.fire({ icon: 'success', title: 'Sucesso!', text: data.message, timer: 2000, showConfirmButton: false });
                }
            }
        });

        window.addEventListener('error', event => {
            const data = event.detail;
            if (data.message) {
                Swal.fire({ icon: 'error', title: 'Erro!', text: data.message });
            }
        });
    }
});
</script>
