<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <div>
                                    <h5 class="card-title mb-1">Configuração de Prazos de Pagamento</h5>
                                    <p class="text-muted small mb-0">
                                        Configure datas limite para gerar referências de pagamento por mês.
                                        <strong>Sem data = permite gerar a qualquer momento</strong>
                                    </p>
                                </div>
                                <div class="d-flex align-items-center">
                                    <label class="mb-0 me-2 fw-bold">Ano:</label>
                                    <select wire:model="year" class="form-select form-select-sm" style="width: 120px;">
                                        @php
                                            $currentYear = date('Y');
                                            $startYear = $currentYear - 2;
                                            $endYear = $currentYear + 5;
                                        @endphp
                                        @for($y = $startYear; $y <= $endYear; $y++)
                                            <option value="{{ $y }}">{{ $y }}</option>
                                        @endfor
                                    </select>
                                </div>
                            </div>

                            @if (session()->has('message'))
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    <i class="fas fa-check-circle me-2"></i>{{ session('message') }}
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                </div>
                            @endif

                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th style="width: 15%;">Mês</th>
                                            <th style="width: 15%;">Prazo Limite</th>
                                            <th style="width: 12%;">Permite Atraso</th>
                                            <th style="width: 12%;">Status</th>
                                            <th style="width: 26%;">Ações Rápidas</th>
                                            <th style="width: 20%;">Opções</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($months as $month)
                                            <tr>
                                                <td>
                                                    <strong>{{ $month }}</strong>
                                                    @if($deadlines[$month]['notes'] ?? false)
                                                        <br><small class="text-muted">{{ Str::limit($deadlines[$month]['notes'], 30) }}</small>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($deadlines[$month]['deadline'] ?? false)
                                                        <span class="badge bg-primary">
                                                            <i class="far fa-calendar me-1"></i>
                                                            {{ \Carbon\Carbon::parse($deadlines[$month]['deadline'])->format('d/m/Y') }}
                                                        </span>
                                                    @else
                                                        <span class="badge bg-secondary">Sem prazo</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($deadlines[$month]['allow_late_payment'] ?? true)
                                                        <span class="badge bg-success">
                                                            <i class="fas fa-check me-1"></i>Sim
                                                        </span>
                                                    @else
                                                        <span class="badge bg-danger">
                                                            <i class="fas fa-times me-1"></i>Não
                                                        </span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($deadlines[$month]['is_expired'] ?? false)
                                                        <span class="badge bg-warning text-dark">
                                                            <i class="fas fa-exclamation-triangle me-1"></i>Expirado
                                                        </span>
                                                    @elseif($deadlines[$month]['exists'] ?? false)
                                                        <span class="badge bg-info">
                                                            <i class="fas fa-cog me-1"></i>Configurado
                                                        </span>
                                                    @else
                                                        <span class="badge bg-secondary">
                                                            <i class="fas fa-clock me-1"></i>Padrão (3 dias)
                                                        </span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <div class="btn-group btn-group-sm" role="group">
                                                        <button wire:click="setQuickDeadline('{{ $month }}', 'day_5')"
                                                                class="btn btn-outline-primary"
                                                                title="Dia 5 do mês">
                                                            <i class="far fa-calendar-check me-1"></i>Dia 5
                                                        </button>
                                                        <button wire:click="setQuickDeadline('{{ $month }}', 'day_10')"
                                                                class="btn btn-outline-primary"
                                                                title="Dia 10 do mês">
                                                            <i class="far fa-calendar-check me-1"></i>Dia 10
                                                        </button>
                                                        <button wire:click="setQuickDeadline('{{ $month }}', 'end_of_month')"
                                                                class="btn btn-outline-primary"
                                                                title="Último dia do mês">
                                                            <i class="far fa-calendar-times me-1"></i>Fim
                                                        </button>
                                                        <button wire:click="setQuickDeadline('{{ $month }}', 'no_deadline')"
                                                                class="btn btn-outline-secondary"
                                                                title="Sem prazo limite">
                                                            <i class="fas fa-infinity me-1"></i>Sem Prazo
                                                        </button>
                                                    </div>
                                                </td>
                                                <td>
                                                    <button wire:click="editMonth('{{ $month }}')"
                                                            class="btn btn-sm btn-primary me-1"
                                                            title="Editar configuração">
                                                        <i class="fas fa-edit me-1"></i>Editar
                                                    </button>
                                                    @if($deadlines[$month]['exists'] ?? false)
                                                        <button wire:click="removeDeadline('{{ $month }}')"
                                                                class="btn btn-sm btn-danger"
                                                                onclick="return confirm('Tem certeza que deseja remover este prazo?')"
                                                                title="Remover configuração">
                                                            <i class="far fa-trash-alt me-1"></i>Remover
                                                        </button>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            {{-- Legenda --}}
                            <div class="card bg-light mt-4">
                                <div class="card-body">
                                    <h6 class="card-title">
                                        <i class="fas fa-info-circle me-2"></i>Como funciona:
                                    </h6>
                                    <ul class="mb-0">
                                        <li class="mb-2">
                                            <strong>Sem prazo configurado:</strong> Sistema usa prazo padrão de 3 dias a partir da geração da referência
                                        </li>
                                        <li class="mb-2">
                                            <strong>Com prazo configurado:</strong> Referências expiram na data especificada às 23:59:59
                                        </li>
                                        <li class="mb-2">
                                            <strong>Permite Atraso = SIM:</strong> Estudante pode gerar referência mesmo após prazo (com multa aplicada automaticamente)
                                        </li>
                                        <li class="mb-2">
                                            <strong>Permite Atraso = NÃO:</strong> Sistema bloqueia completamente a geração de referências após o prazo
                                        </li>
                                        <li>
                                            <strong>Ações Rápidas:</strong> Use os botões para configurar prazos comuns rapidamente (Dia 5, Dia 10, Fim do mês, Sem Prazo)
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Modal de Edição --}}
    @if($editingMonth)
        <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title">
                            <i class="fas fa-calendar-alt me-2"></i>Configurar Prazo - {{ $editingMonth }} {{ $year }}
                        </h5>
                        <button type="button" class="btn-close btn-close-white" wire:click="cancelEdit"></button>
                    </div>
                    <div class="modal-body">
                        <form>
                            <div class="mb-3">
                                <label class="form-label fw-bold">
                                    <i class="far fa-calendar me-1"></i>Data Limite
                                </label>
                                <input type="date"
                                       wire:model="deadline"
                                       class="form-control @error('deadline') is-invalid @enderror">
                                <small class="form-text text-muted">
                                    Deixe vazio para sem limite (usa prazo padrão de 3 dias)
                                </small>
                                @error('deadline')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input @error('allowLatePayment') is-invalid @enderror"
                                           type="checkbox"
                                           wire:model="allowLatePayment"
                                           id="allowLatePayment">
                                    <label class="form-check-label fw-bold" for="allowLatePayment">
                                        <i class="fas fa-clock me-1"></i>Permitir pagamento após prazo
                                    </label>
                                </div>
                                <small class="form-text text-muted">
                                    Se ativado, estudantes podem gerar referências mesmo após o prazo (com multa aplicada)
                                </small>
                                @error('allowLatePayment')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-bold">
                                    <i class="fas fa-sticky-note me-1"></i>Observações (opcional)
                                </label>
                                <textarea wire:model="notes"
                                          class="form-control @error('notes') is-invalid @enderror"
                                          rows="3"
                                          maxlength="500"
                                          placeholder="Notas administrativas internas..."></textarea>
                                <small class="form-text text-muted">
                                    Máximo 500 caracteres
                                </small>
                                @error('notes')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="cancelEdit">
                            <i class="fas fa-times me-1"></i>Cancelar
                        </button>
                        <button type="button" class="btn btn-primary" wire:click="saveDeadline">
                            <i class="fas fa-save me-1"></i>Salvar Configuração
                        </button>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
