<div class="fee-management-container">
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <!-- Main Card Container -->
                    <div class="card border-0 shadow-sm">
                        <div class="card-body p-3 p-md-4" wire:init="loadData">
                            <!-- Header Section with Search and Add Button -->
                            <div class="row mb-4">
                                <div class="col-12 col-lg-6 mb-3 mb-lg-0">
                                    <h5 class="card-title mb-1">
                                        <i class="fas fa-money-bill-wave me-2 text-primary"></i>
                                        <span class="d-none d-sm-inline">Gestão de Planos de Taxas</span>
                                        <span class="d-inline d-sm-none">Planos de Taxas</span>
                                    </h5>
                                    <p class="text-muted small mb-0 d-none d-md-block">Visualize e gerencie todas as estruturas de taxas</p>
                                </div>
                                <div class="col-12 col-lg-6">
                                    <div class="d-flex flex-column flex-sm-row gap-2">
                                        <div class="input-group flex-grow-1">
                                            <span class="input-group-text bg-light border-end-0">
                                                <i class="fas fa-search"></i>
                                            </span>
                                            <input type="search" wire:model="search"
                                                   class="form-control border-start-0"
                                                   placeholder="Pesquisar...">
                                        </div>
                                        <a href="{{ route('admin.add.feemaster') }}"
                                           class="btn btn-primary">
                                            <i class="fas fa-plus me-2"></i>
                                            <span class="d-none d-sm-inline">Adicionar</span>
                                            <span class="d-inline d-sm-none">Adicionar</span>
                                        </a>
                                    </div>
                                </div>
                            </div>

                            <!-- Fee Structures Table -->
                            <div class="card border-0 shadow-sm">
                                <div class="card-header bg-light py-3">
                                    <h6 class="mb-0">
                                        <i class="fas fa-list-alt me-2"></i>
                                        Estruturas de Taxas
                                    </h6>
                                </div>
                                <div class="card-body p-0">
                                    @if(count($feeStructures))
                                    <!-- Desktop Table View -->
                                    <div class="d-none d-md-block">
                                        <div class="table-responsive">
                                            <table class="table table-hover align-middle mb-0">
                                                <thead class="table-light">
                                                    <tr>
                                                        <th class="ps-4">Nome</th>
                                                        <th>Classes</th>
                                                        <th>Meses</th>
                                                        <th>Valor</th>
                                                        <th>Multa</th>
                                                        <th>Estado</th>
                                                        <th class="text-end pe-4">Ações</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($feeStructures as $feeStructure)
                                                    <tr>
                                                        <td class="ps-4 fw-semibold">
                                                            <i class="fas fa-file-invoice-dollar text-primary me-2"></i>
                                                            {{ $feeStructure->fee_name }}
                                                        </td>
                                                        
                                                        <td>
                                                            <div class="d-flex flex-wrap gap-1" style="max-width: 150px;">
                                                                @foreach(explode(',', $feeStructure->grades) as $grade)
                                                                    <span class="badge bg-info">{{ $grade }}ª</span>
                                                                @endforeach
                                                            </div>
                                                        </td>
                                                        
                                                        <td>
                                                            <div class="d-flex flex-wrap gap-1" style="max-width: 200px;">
                                                                @foreach(explode(',', $feeStructure->months) as $month)
                                                                    <span class="badge bg-light text-dark">{{ $month }}</span>
                                                                @endforeach
                                                            </div>
                                                        </td>
                                                        
                                                        <td class="fw-bold">
                                                            {{ number_format($feeStructure->monthly_fee, 2, ',', '.') }} MT
                                                        </td>
                                                        
                                                        <td>
                                                            <span class="badge bg-warning text-dark">
                                                                {{ $feeStructure->late_penalty_percentage }}%
                                                            </span>
                                                        </td>
                                                        
                                                        <td>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch"
                                                                       wire:change="toggleActiveStatus({{ $feeStructure->id }})"
                                                                       id="status_{{ $feeStructure->id }}"
                                                                       @checked($feeStructure->active)>
                                                                <label class="form-check-label ms-2" for="status_{{ $feeStructure->id }}">
                                                                    {{ $feeStructure->active ? ' Ativo ' : ' Inativo ' }}
                                                                </label>
                                                            </div>
                                                        </td>
                                                        
                                                        <td class="text-end pe-4">
                                                            <button class="btn btn-sm btn-outline-primary me-2"
                                                                    wire:click="edit({{ $feeStructure->id }})"
                                                                    title="Editar">
                                                                <i class="fas fa-edit"></i>
                                                            </button>
                                                            <button wire:click="submit({{ $feeStructure->id }}, 'structure')"
                                                                    class="btn btn-sm btn-danger"
                                                                    title="Excluir">
                                                                <i class="fas fa-trash"></i> Excluir
                                                            </button>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                    <!-- Mobile Card View -->
                                    <div class="d-block d-md-none">
                                        @foreach($feeStructures as $feeStructure)
                                        <div class="fee-card p-3 border-bottom">
                                            <div class="d-flex justify-content-between align-items-start mb-2">
                                                <div>
                                                    <h6 class="mb-1 fw-semibold">
                                                        <i class="fas fa-file-invoice-dollar text-primary me-2"></i>
                                                        {{ $feeStructure->fee_name }}
                                                    </h6>
                                                    <div class="text-primary fw-bold">
                                                        {{ number_format($feeStructure->monthly_fee, 2, ',', '.') }} MT
                                                    </div>
                                                </div>
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" role="switch"
                                                           wire:change="toggleActiveStatus({{ $feeStructure->id }})"
                                                           id="mobile_status_{{ $feeStructure->id }}"
                                                           @checked($feeStructure->active)>
                                                </div>
                                            </div>

                                            <div class="mb-2">
                                                <small class="text-muted d-block mb-1">Classes:</small>
                                                <div class="d-flex flex-wrap gap-1">
                                                    @foreach(explode(',', $feeStructure->grades) as $grade)
                                                        <span class="badge bg-info">{{ $grade }}ª</span>
                                                    @endforeach
                                                </div>
                                            </div>

                                            <div class="mb-2">
                                                <small class="text-muted d-block mb-1">Meses:</small>
                                                <div class="d-flex flex-wrap gap-1">
                                                    @foreach(explode(',', $feeStructure->months) as $month)
                                                        <span class="badge bg-light text-dark">{{ substr($month, 0, 3) }}</span>
                                                    @endforeach
                                                </div>
                                            </div>

                                            <div class="d-flex justify-content-between align-items-center">
                                                <span class="badge bg-warning text-dark">
                                                    Multa: {{ $feeStructure->late_penalty_percentage }}%
                                                </span>
                                                <div class="btn-group btn-group-sm" role="group">
                                                    <button class="btn btn-outline-primary"
                                                            wire:click="edit({{ $feeStructure->id }})"
                                                            title="Editar">
                                                        <i class="fas fa-edit"></i>
                                                    </button>
                                                    <button wire:click="submit({{ $feeStructure->id }}, 'structure')"
                                                            class="btn btn-outline-danger"
                                                            title="Excluir">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                    @else
                                    <div class="text-center py-5">
                                        <i class="fas fa-file-alt fa-3x text-muted mb-3"></i>
                                        <h5 class="text-muted">Nenhuma estrutura de taxas encontrada</h5>
                                        <p class="text-muted">Crie novas estruturas para começar</p>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .fee-management-container {
        max-width: 1400px;
        margin: 0 auto;
    }
    
    .card {
        border-radius: 0.5rem;
        overflow: hidden;
    }
    
    .card-header {
        font-weight: 600;
    }
    
    .table {
        font-size: 0.875rem;
    }
    
    .table th {
        font-weight: 600;
        text-transform: uppercase;
        font-size: 0.75rem;
        letter-spacing: 0.5px;
        background-color: #f8f9fa;
    }
    
    .badge {
        font-weight: 500;
        padding: 0.35em 0.65em;
        border-radius: 0.25rem;
    }
    
    .form-switch .form-check-input {
        width: 2.5em;
        height: 1.5em;
        cursor: pointer;
    }
    
    .table-hover tbody tr:hover {
        background-color: rgba(13, 110, 253, 0.03);
    }
    
    .btn-group-sm > .btn {
        padding: 0.25rem 0.5rem;
        font-size: 0.75rem;
    }
    
    .pagination {
        font-size: 0.875rem;
    }
    
    .input-group-text {
        background-color: #f8f9fa;
    }
    
    .text-muted {
        color: #6c757d !important;
    }

    /* Mobile specific styles */
    .fee-card {
        transition: background-color 0.2s;
    }
    
    .fee-card:last-child {
        border-bottom: none !important;
    }
    
    .fee-card:hover {
        background-color: rgba(13, 110, 253, 0.03);
    }

    @media (max-width: 576px) {
        .card-body {
            padding: 1rem !important;
        }
        
        .card-title {
            font-size: 1.125rem;
        }
        
        .btn {
            font-size: 0.875rem;
        }
        
        .badge {
            font-size: 0.7rem;
            padding: 0.25em 0.5em;
        }
        
        /* Prevent horizontal scroll */
        .page-content {
            overflow-x: hidden;
        }
        
        .main-wrapper {
            padding: 0;
        }
        
        /* Smaller switch on mobile */
        .form-switch .form-check-input {
            width: 2em;
            height: 1.25em;
        }
    }

    /* Tablet adjustments */
    @media (min-width: 577px) and (max-width: 991px) {
        .input-group {
            max-width: 100%;
        }
    }
</style>
</body>
