<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="card border-0 shadow">
                <div class="card-header bg-primary text-white py-3 d-flex justify-content-between align-items-center">
                    <h2 class="h5 mb-0">
                        <i class="fas fa-bullhorn me-2"></i>
                        Adicionar Comunicado
                    </h2>
                    <a href="{{ route('admin.notice') }}" class="btn btn-sm btn-light">
                        <i class="fas fa-list me-1"></i>Ver Todos os Comunicados
                    </a>
                </div>

                <div class="card-body">
                    <div class="row justify-content-center">
                        <div class="col-12 col-lg-10">
                            <form wire:submit.prevent="submit" class="needs-validation" novalidate>
                                <div class="row g-3">
                                    <!-- Enviar Para -->
                                    <div class="col-md-6">
                                        <label for="type" class="form-label fw-semibold">Enviar Para <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-users"></i></span>
                                            <select id="type"
                                                    wire:model="type"
                                                    class="form-select"
                                                    required>
                                                <option value="all">Todos</option>
                                                <option value="class">Classe Ou Turma</option>
                                                <option value="student">Estudante</option>
                                            </select>
                                        </div>
                                    </div>

                                    <!-- Descrição -->
                                    <div class="col-md-6">
                                        <label for="title" class="form-label fw-semibold">Descrição <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-heading"></i></span>
                                            <input type="text"
                                                   id="title"
                                                   wire:model="title"
                                                   class="form-control @error('title') is-invalid @enderror"
                                                   placeholder="Ex: Comunicado Importante"
                                                   required>
                                        </div>
                                        @error('title') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Turma (condicional) -->
                                    @if($type == "class" || $type == "student")
                                    <div class="col-md-6">
                                        <label for="class_id" class="form-label fw-semibold">Turma <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-door-open"></i></span>
                                            <select id="class_id"
                                                    wire:model="class_id"
                                                    class="form-select @error('class_id') is-invalid @enderror"
                                                    required>
                                                <option value="">Selecione a turma...</option>
                                                @foreach($Classroom as $class)
                                                    <option value="{{ $class->id }}">{{ $class->class }}ª - {{ $class->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @error('class_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>
                                    @endif

                                    <!-- Estudante (condicional) -->
                                    @if($type == "student")
                                    <div class="col-md-6">
                                        <label for="student_id" class="form-label fw-semibold">Estudante <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-user-graduate"></i></span>
                                            <select id="student_id"
                                                    wire:model="student_id"
                                                    class="form-select @error('student_id') is-invalid @enderror"
                                                    required>
                                                <option value="">Selecione o estudante...</option>
                                                @foreach($students as $student)
                                                    <option value="{{ $student->id }}">{{ $student->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @error('student_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>
                                    @endif

                                    <!-- Ficheiro -->
                                    <div class="col-12">
                                        <label for="photo" class="form-label fw-semibold">Ficheiro <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-file-upload"></i></span>
                                            <input type="file"
                                                   id="photo"
                                                   wire:model="photo"
                                                   class="form-control @error('photo') is-invalid @enderror"
                                                   required>
                                        </div>
                                        @error('photo') <span class="text-danger small">{{ $message }}</span> @enderror
                                        <div wire:loading wire:target="photo" class="mt-2">
                                            <small class="text-primary">
                                                <span class="spinner-border spinner-border-sm me-1"></span>
                                                Carregando ficheiro...
                                            </small>
                                        </div>
                                    </div>
                                </div>

                                <!-- Botões -->
                                <div class="d-grid gap-2 mt-4">
                                    <button type="submit"
                                            class="btn btn-primary btn-lg"
                                            wire:loading.attr="disabled"
                                            wire:offline.attr="disabled">
                                        <span wire:loading.remove wire:target="submit">
                                            <i class="fas fa-paper-plane me-2"></i>Publicar Comunicado
                                        </span>
                                        <span wire:loading wire:target="submit">
                                            <span class="spinner-border spinner-border-sm me-2"></span>
                                            Publicando...
                                        </span>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .form-label.fw-semibold {
            font-weight: 600;
            color: #495057;
        }

        .input-group-text {
            background-color: #f8f9fa;
            border-right: none;
        }

        .input-group .form-control,
        .input-group .form-select {
            border-left: none;
        }

        .input-group .form-control:focus,
        .input-group .form-select:focus {
            border-color: #ced4da;
            box-shadow: none;
        }

        .input-group:focus-within .input-group-text {
            border-color: #80bdff;
        }
    </style>
</div>
