<div class="page-content">
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="row mb-4 mt-3">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="pt-3">
                        <h1 class="h3 mb-1 text-primary">
                            <i class="fas fa-chalkboard-teacher me-2"></i>Lista de Professores
                        </h1>
                        <p class="text-muted mb-0">
                            Gerencie os professores e suas atribuições de disciplinas
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters Card -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h5 class="card-title mb-0 text-primary">
                        <i class="fas fa-filter me-2"></i>Filtros de Pesquisa
                        @php
                            $activeFilters = 0;
                            if($selectedClass) $activeFilters++;
                            if($selectedTurma) $activeFilters++;
                            if($selectedSubject) $activeFilters++;
                            if($selectedStatus !== '') $activeFilters++;
                            if($search) $activeFilters++;
                        @endphp
                        @if($activeFilters > 0)
                            <span class="badge bg-info ms-2">{{ $activeFilters }} ativo{{ $activeFilters > 1 ? 's' : '' }}</span>
                        @endif
                    </h5>
                    <div class="d-flex gap-2">
                        <div class="btn-group" role="group">
                            <button type="button" wire:click="exportPDF" class="btn btn-danger btn-sm">
                                <i class="fa fa-file-pdf me-1"></i>PDF
                            </button>
                            <button type="button" wire:click="exportExcel" class="btn btn-success btn-sm">
                                <i class="fa fa-file-excel me-1"></i>Excel
                            </button>
                        </div>
                        @if($activeFilters > 0)
                        <button wire:click="$set('selectedClass', ''); $set('selectedTurma', ''); $set('selectedSubject', ''); $set('selectedStatus', ''); $set('search', '')"
                                class="btn btn-sm btn-outline-secondary">
                            <i class="fas fa-times me-1"></i>Limpar Filtros
                        </button>
                        @endif
                    </div>
                </div>

                <div class="row g-3">
                    <!-- Classe -->
                    <div class="col-md-2">
                        <label for="selectedClass" class="form-label">Classe</label>
                        <select class="form-select" wire:model="selectedClass">
                            <option value="">Todas</option>
                            @foreach($classes as $class)
                                <option value="{{ $class->class }}">{{ $class->class }}ª</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Turma -->
                    <div class="col-md-2">
                        <label for="selectedTurma" class="form-label">Turma</label>
                        <select class="form-select" wire:model="selectedTurma" {{ !$selectedClass ? 'disabled' : '' }}>
                            <option value="">Todas</option>
                            @foreach($turmas as $turma)
                                <option value="{{ $turma->id }}">{{ $turma->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Disciplina -->
                    <div class="col-md-3">
                        <label for="selectedSubject" class="form-label">
                            Disciplina
                            @if($selectedClass)
                                <span class="text-muted small">(da {{ $selectedClass }}ª classe)</span>
                            @endif
                        </label>
                        <select class="form-select" wire:model="selectedSubject">
                            <option value="">
                                @if($selectedClass)
                                    Todas (da {{ $selectedClass }}ª classe)
                                @else
                                    Todas as Disciplinas
                                @endif
                            </option>
                            @foreach($subjects as $subject)
                                <option value="{{ $subject->id }}">{{ $subject->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Estado -->
                    <div class="col-md-2">
                        <label for="selectedStatus" class="form-label">Estado</label>
                        <select class="form-select" wire:model="selectedStatus">
                            <option value="">Todos</option>
                            <option value="1">Ativo</option>
                            <option value="0">Suspenso</option>
                        </select>
                    </div>

                    <!-- Pesquisar -->
                    <div class="col-md-3">
                        <label for="search" class="form-label">Pesquisar</label>
                        <div class="input-group">
                            <input type="search"
                                   class="form-control"
                                   wire:model.debounce.300ms="search"
                                   placeholder="Nome, email, telefone...">
                            <span class="input-group-text">
                                <i class="fas fa-search"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Teachers Card -->
        <div class="card border-0 shadow-sm">
            <div class="card-body p-0">
                <div class="d-flex justify-content-between align-items-center p-4 border-bottom">
                    <h5 class="card-title mb-0 text-primary">
                        <i class="fas fa-users me-2"></i>Professores
                        @if(count($users))
                            <span class="badge bg-primary ms-2">{{ $users->total() }}</span>
                        @endif
                    </h5>
                </div>

                <div class="table-responsive" wire:init="loadData">
                    @if(count($users))
                        <table class="table table-hover align-middle mb-0 teachers-table table-sm">
                            <thead class="bg-light">
                                <tr>
                                    <th class="th-number">#</th>
                                    <th class="th-name">Nome</th>
                                    <th class="th-contact">Contacto</th>
                                    <th class="th-subject">Disciplina</th>
                                    <th class="th-class">Classe</th>
                                    <th class="th-turma">Turma</th>
                                    <th class="th-status">Estado</th>
                                    <th class="th-actions text-center">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $count = ($users->currentPage() - 1) * $users->perPage() + 1;
                                @endphp
                                @foreach($users as $user)
                                    <tr>
                                        <td class="text-muted small">{{ $count++ }}</td>
                                        <td class="td-name">
                                            <div class="fw-semibold text-truncate" title="{{ $user->teacher->name }}">
                                                {{ $user->teacher->name }}
                                            </div>
                                        </td>
                                        <td class="td-contact small">
                                            <div class="text-muted text-truncate" title="{{ $user->teacher->email }}">
                                                <i class="fas fa-envelope me-1"></i>{{ $user->teacher->email }}
                                            </div>
                                            @if($user->teacher->phone_number)
                                            <div class="text-muted text-truncate" title="{{ $user->teacher->phone_number }}">
                                                <i class="fas fa-phone me-1"></i>{{ $user->teacher->phone_number }}
                                            </div>
                                            @endif
                                        </td>
                                        <td class="td-subject small">
                                            @if($user->subject)
                                                <span class="text-info">{{ $user->subject->name }}</span>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td class="text-center">
                                            @if($user->classroom)
                                                <span class="badge bg-info badge-sm">{{ $user->classroom->class }}ª</span>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td class="td-turma small text-muted">
                                            @if($user->classroom)
                                                <div class="text-truncate" title="{{ $user->classroom->name }}">
                                                    {{ $user->classroom->name }}
                                                </div>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td class="text-center">
                                            @if($user->teacher->is_active)
                                                <span class="badge bg-success badge-sm">Ativo</span>
                                            @else
                                                <span class="badge bg-danger badge-sm">Inativo</span>
                                            @endif
                                        </td>
                                        <td class="text-center">
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="{{ route('admin.edit.teacher.subject', $user->id) }}"
                                                   class="btn btn-outline-primary"
                                                   title="Editar">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button"
                                                        wire:click="submit('{{ $user->id }}')"
                                                        class="btn btn-outline-danger"
                                                        title="Deletar">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center p-4 border-top">
                            {{ $users->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <div wire:loading class="mb-3">
                                <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                                    <span class="visually-hidden">Carregando...</span>
                                </div>
                                <p class="mt-3 mb-0">Processando...</p>
                            </div>
                            <div wire:loading.remove>
                                <i class="fas fa-user-slash text-muted" style="font-size: 3rem;"></i>
                                <h5 class="mt-3">Nenhum professor encontrado</h5>
                                <p class="text-muted">Ajuste os filtros ou adicione novos professores</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .teachers-table {
        font-size: 13px;
        table-layout: auto;
        width: 100%;
    }

    .teachers-table thead th {
        font-weight: 600;
        text-transform: uppercase;
        font-size: 11px;
        letter-spacing: 0.5px;
        color: #495057;
        border-bottom: 2px solid #dee2e6;
        padding: 0.5rem 0.75rem;
        white-space: nowrap;
    }

    .teachers-table tbody td {
        padding: 0.5rem 0.75rem;
        vertical-align: middle;
    }

    .teachers-table tbody tr:hover {
        background-color: #f8f9fa;
    }

    /* Larguras dinâmicas das colunas */
    .th-number { width: 3%; min-width: 40px; }
    .th-name { width: 18%; min-width: 150px; }
    .th-contact { width: 20%; min-width: 160px; }
    .th-subject { width: auto; min-width: 120px; } /* Coluna que expande */
    .th-class { width: 8%; min-width: 70px; }
    .th-turma { width: 12%; min-width: 90px; }
    .th-status { width: 8%; min-width: 70px; }
    .th-actions { width: 10%; min-width: 85px; }

    /* Células com text-truncate dinâmico */
    .td-name .text-truncate { max-width: none; }
    .td-contact .text-truncate { max-width: none; }
    .td-subject { word-wrap: break-word; }
    .td-turma .text-truncate { max-width: none; }

    .badge-sm {
        font-size: 0.7rem;
        padding: 0.25em 0.5em;
    }

    .text-truncate {
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }

    /* Responsividade para telas menores */
    @media (max-width: 1400px) {
        .th-contact { width: 18%; }
        .th-name { width: 16%; }
    }

    @media (max-width: 1200px) {
        .teachers-table { font-size: 12px; }
        .teachers-table thead th { font-size: 10px; }
    }

    .avatar-circle {
        width: 36px;
        height: 36px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
        font-size: 14px;
    }

    .badge {
        padding: 0.35rem 0.65rem;
        font-weight: 500;
        font-size: 11px;
    }

    .card {
        transition: box-shadow 0.3s ease;
    }

    .card:hover {
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1) !important;
    }

    .input-group-text {
        background-color: #f8f9fa;
        border-left: none;
    }

    .input-group .form-control {
        border-right: none;
    }

    .input-group .form-control:focus {
        border-color: #ced4da;
        box-shadow: none;
    }

    .input-group .form-control:focus + .input-group-text {
        border-color: #80bdff;
    }

    /* Disabled select styling */
    .form-select:disabled {
        background-color: #e9ecef;
        cursor: not-allowed;
        opacity: 0.6;
    }

    /* Badge info color adjustment */
    .badge.bg-info {
        font-size: 0.75rem;
        padding: 0.25rem 0.5rem;
    }

    @media (max-width: 768px) {
        .teachers-table {
            font-size: 12px;
        }

        .teachers-table thead {
            display: none;
        }

        .teachers-table tbody tr {
            display: block;
            margin-bottom: 1rem;
            border: 1px solid #dee2e6;
            border-radius: 0.25rem;
        }

        .teachers-table tbody td {
            display: block;
            text-align: right;
            padding: 0.75rem 1rem;
            border-bottom: 1px solid #f0f0f0;
        }

        .teachers-table tbody td:last-child {
            border-bottom: none;
        }

        .action-cell {
            justify-content: flex-end !important;
        }
    }
</style>
