<?php
$class_id = "";
$mfd_count = 0;
$get_class = "";
$subjects_get = array();

// Obter a classe e suas disciplinas
foreach ($models as $model) {
    $classroom = \App\Models\Classroom::query()->where("id", $model->classroom_id)->first();
    if ($classroom) {
        $get_class = $classroom->class ?? 0;

        // Buscar disciplinas atribuídas à classe do estudante
        $query_subjects = \App\Models\TeacherSubject::query()->where("classroom_id", $model->classroom_id)->get();
        foreach ($query_subjects as $subject_relation) {
            $subject = \App\Models\Subject::query()->where("id", $subject_relation->subject_id)->first();
            if ($subject) {
                $subjects_get[$subject->name] = $subject->id;
            }
        }
        $class_id = $get_class;
    }
    if ($class_id != 0) {
        break;
    }
}

// Disciplinas com notas de exame baseadas na classe
$ne_subjects3 = array("Português", "Matemática");
$ne_subjects6 = array("Português", "Matemática", "História", "Geografia", "Física", "Química", "Biologia", "Ciências naturais", "Ciências sociais", "Filosofia");
$ne_subjects = array("Português", "Matemática", "Inglês", "História", "Geografia", "Física", "Química", "Biologia", "Ciências naturais", "Ciências sociais", "Filosofia");

// Determinar quais disciplinas pertencem à classe atual
if ($class_id == 3) {
    $current_ne_subjects = $ne_subjects3;
} elseif ($class_id == 6) {
    $current_ne_subjects = $ne_subjects6;
} elseif (in_array($class_id, [10, 12])) {
    $current_ne_subjects = $ne_subjects;
} else {
    $current_ne_subjects = [];
}

// Determinar se a coluna NE/AF deve ser exibida
$show_ne_column = in_array($class_id, [3, 6, 10, 12]);

// Disciplinas da classe
$subjects = $subjects_get;
$divide = count($subjects);
?>


<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card" style="border: 1px solid #e2e8f0; border-radius: 0;">
                        <div class="card-body" wire:init="loadData" style="padding: 2rem;">
                            <h5 class="card-title" style="color: #1e293b; font-weight: 600; font-size: 1.25rem; letter-spacing: -0.025em;">Notas do estudante</h5>
                            <div class="row mb-4">
                                <div class="col-md-4">
                                    <label for="year-select" class="form-label" style="color: #475569; font-size: 0.875rem; font-weight: 500; margin-bottom: 0.5rem;">Ano Lectivo</label>
                                    <select wire:model="search" id="year-select" class="form-select" style="border: 1px solid #cbd5e1; border-radius: 0; padding: 0.625rem 0.875rem; font-size: 0.9375rem;">
                                        @foreach($years as $value => $label)
                                            <option value="{{ $value }}">{{ $label }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="table-responsive">
                                        @if (count($models))
                                            <table class="table table-sm mb-0" style="font-size: 0.875rem;">
                                                <thead style="background-color: #f1f5f9;">
                                                    <!-- Cabeçalho Principal -->
                                                    <tr>
                                                        <th colspan="5" style="border-right: 2px solid #e2e8f0;"><b>Primeiro Trimestre</b></th>
                                                        <th colspan="4" style="border-right: 2px solid #e2e8f0;"><b>Segundo Trimestre</b></th>
                                                        <th colspan="5"><b>Terceiro Trimestre</b></th>
                                                    </tr>

                                                    <!-- Subcabeçalho -->
                                                    <tr>
                                                        <th style="color: #64748b; font-weight: 600; padding: 0.625rem 0.75rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">Disciplina</th>
                                                        <!-- Primeiro Trimestre -->
                                                        <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">ACS1</th>
                                                        <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">ACS2</th>
                                                        <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">AT</th>
                                                        <th class="text-center" style="color: #1e293b; font-weight: 700; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0; background-color: #e0e7ff;">MT</th>

                                                        <!-- Segundo Trimestre -->
                                                        <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">ACS1</th>
                                                        <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">ACS2</th>
                                                        <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">AT</th>
                                                        <th class="text-center" style="color: #1e293b; font-weight: 700; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0; background-color: #e0e7ff;">MT</th>

                                                        <!-- Terceiro Trimestre -->
                                                        <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">ACS1</th>
                                                        <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">ACS2</th>
                                                        <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">AT</th>
                                                        <th class="text-center" style="color: #1e293b; font-weight: 700; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0; background-color: #e0e7ff;">MT</th>
                                                        @if ($show_ne_column)
                                                            <th class="text-center" style="color: #991b1b; font-weight: 700; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0; background-color: #fee2e2;">{{ $class_id == 3 ? 'AF' : 'NE' }}</th>
                                                        @endif
                                                    </tr>
                                                </thead>
                                                    <tbody>
                                                        @foreach ($models as $model)
                                                            <tr>
                                                                <!-- Nome da Disciplina -->
                                                                <td>{{ optional($model->subject)->name ?? 'N/A' }}</td>
                                                    
                                                                <!-- Primeiro Trimestre -->
                                                                <td>{{ number_format($model->ACS1a ?? 0, 2) }}</td>
                                                                <td>{{ number_format($model->ACS2a ?? 0, 2) }}</td>
                                                                <td>{{ number_format($model->AT ?? 0, 2) }}</td>
                                                                <td>{{ round((($model->ACS1a ?? 0) + ($model->ACS2a ?? 0) + ($model->AT ?? 0)) / 3) }}</td>
                                                    
                                                                <!-- Segundo Trimestre -->
                                                                @php($exam_second = \App\Models\Exam::query()
                                                                    ->where('trimester_id', 2)
                                                                    ->where('classroom_id', $model->classroom_id)
                                                                    ->where('subject_id', $model->subject_id)
                                                                    ->where('student_id', $model->student_id)
                                                                    ->first())
                                                                <td>{{ number_format($exam_second->ACS1a ?? 0, 2) }}</td>
                                                                <td>{{ number_format($exam_second->ACS2a ?? 0, 2) }}</td>
                                                                <td>{{ number_format($exam_second->AT ?? 0, 2) }}</td>
                                                                <td>{{ round((($exam_second->ACS1a ?? 0) + ($exam_second->ACS2a ?? 0) + ($exam_second->AT ?? 0)) / 3) }}</td>
                                                    
                                                                <!-- Terceiro Trimestre -->
                                                                @php($exam_third = \App\Models\Exam::query()
                                                                    ->where('trimester_id', 3)
                                                                    ->where('classroom_id', $model->classroom_id)
                                                                    ->where('subject_id', $model->subject_id)
                                                                    ->where('student_id', $model->student_id)
                                                                    ->first())
                                                                <td>{{ number_format($exam_third->ACS1a ?? 0, 2) }}</td>
                                                                <td>{{ number_format($exam_third->ACS2a ?? 0, 2) }}</td>
                                                                <td>{{ number_format($exam_third->AT ?? 0, 2) }}</td>
                                                                <td>{{ round((($exam_third->ACS1a ?? 0) + ($exam_third->ACS2a ?? 0) + ($exam_third->AT ?? 0)) / 3) }}</td>
                                                                
                                                                <!-- Condição para pintar NE/AF em preto -->
                                                                <!-- NE/AF -->
                                                                    @if ($show_ne_column)
                                                                        @if(in_array(optional($model->subject)->name, $current_ne_subjects))
                                                                            <td>{{ number_format($exam_third->NE ?? 0, 2) }}</td>
                                                                        @else
                                                                            <td style="background-color: black; color: white;">N/A</td>
                                                                        @endif
                                                                    @endif
                                                            </tr>
                                                        @endforeach
                                                    </tbody>

                                            </table>

                                            <!-- Exibição do Resultado -->
                                            <h3 style="text-align:center;">RESULTADO</h3>
                                            @php ($mfd_count = 0)
                                            @php ($subject_count = 0)
                                            @php ($reprovado_por_mt = false)

                                            @foreach ($models as $model)
                                                @php ($mfd_count += round((($model->ACS1a ?? 0) + ($model->ACS2a ?? 0) + ($model->AT ?? 0)) / 3, 2))
                                                @php ($subject_count++)
                                            
                                                
                                                @if (optional($model->subject)->name === 'Matemática' && optional($model->subject)->name === 'Português')
                                                    @php ($mt_value = round((($model->ACS1a ?? 0) + ($model->ACS2a ?? 0) + ($model->AT ?? 0)) / 3, 2))
                                                    @if ($mt_value < 10)
                                                        @php ($reprovado_por_mt = true)
                                                    @endif
                                                @endif
                                            @endforeach
                                            
                                            @php ($result = $subject_count > 0 ? round($mfd_count / $subject_count, 2) : 0)
                                            <h3 style="text-align:center;">
                                                @if ($reprovado_por_mt)
                                                    <span style="color: red;">{{ $class_id == 3 || $class_id == 6 || $class_id == 10 || $class_id == 12 ? 'REPROVADO' : 'NÃO TRANSITA' }}</span>
                                                @elseif($result <= 9)
                                                    <span style="color: red;">{{ $class_id == 3 || $class_id == 6 || $class_id == 10 || $class_id == 12 ? 'REPROVADO' : 'NÃO TRANSITA' }}</span>
                                                @else
                                                    <span style="color: green;">{{ $class_id == 3 || $class_id == 6 || $class_id == 10 || $class_id == 12 ? 'APROVADO' : 'TRANSITA' }}</span>
                                                @endif
                                            </h3>
                                            <h3 style="text-align:center;">MF: {{ round($result) }}</h3>

                                        @else
                                            <p class="text-center"><b>Nenhum dado foi encontrado no momento.</b></p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


