<?php

use App\Http\Controllers\Controller;
use App\Http\Controllers\ExcelTemplateController;
use App\Http\Controllers\FlipController;
use App\Http\Livewire\Admin\Account\AdminPassword;
use App\Http\Livewire\Admin\Account\AdminProfile;
use App\Http\Livewire\Admin\AdminHome;
use App\Http\Livewire\Admin\Admins\AddAdmin;
use App\Http\Livewire\Admin\Admins\EditAdmin;
use App\Http\Livewire\Admin\Admins\ListAdmins;
use App\Http\Livewire\Admin\Books\AddBook;
use App\Http\Livewire\Admin\Books\AdminListBooks;
use App\Http\Livewire\Admin\Books\EditBook;
use App\Http\Livewire\Admin\Books\ShowBookChapters;
use App\Http\Livewire\Admin\Books\ShowBookDetail;
use App\Http\Livewire\Admin\Books\ShowChapterDetails;
use App\Http\Livewire\Admin\Category\AddCategory;
use App\Http\Livewire\Admin\Category\EditCategory;
use App\Http\Livewire\Admin\Category\ListCategories;
use App\Http\Livewire\Admin\Chapters\AddBookChapter;
use App\Http\Livewire\Admin\Chapters\EditBookChapter;
use App\Http\Livewire\Admin\Chapters\ListBookChapters;
use App\Http\Livewire\Admin\Classes\AcademicEditResults;
use App\Http\Livewire\Admin\Classes\AcademicViewResults;
use App\Http\Livewire\Admin\Classes\AddClass;
use App\Http\Livewire\Admin\Classes\ClassesModalTest;
use App\Http\Livewire\Admin\Classes\EditClass;
use App\Http\Livewire\Admin\Classes\ListClasses;
use App\Http\Livewire\Admin\Classes\ListClassPassedStudents;
use App\Http\Livewire\Admin\Classes\ListClassStudents;
use App\Http\Livewire\Admin\Classes\ListClassUpdateStudents;
use App\Http\Livewire\Admin\Classes\TeacherListClasses;
use App\Http\Livewire\Admin\Classes\TeacherListClassStudents;
use App\Http\Livewire\Admin\Classes\TeacherViewMarksStudent;
use App\Http\Livewire\Admin\Downloadcenter\AddDownload;
use App\Http\Livewire\Admin\Downloadcenter\Downloads;
use App\Http\Livewire\Admin\Downloadcenter\EditDownload;
use App\Http\Livewire\Admin\Exams\AddExam1a;
use App\Http\Livewire\Admin\Exams\AddExam2a;
use App\Http\Livewire\Admin\Exams\AddExam;
use App\Http\Livewire\Admin\Exams\BatchMarksEntry;
use App\Http\Livewire\Admin\Exams\EditExam;
use App\Http\Livewire\Admin\Exams\ExcelImportMarks;
use App\Http\Livewire\Admin\Exams\ListExams;
use App\Http\Livewire\Admin\Grades\AddGrade;
use App\Http\Livewire\Admin\Grades\EditGrade;
use App\Http\Livewire\Admin\Grades\ListGrades;
use App\Http\Livewire\Admin\Noticeboard\AddNotice;
use App\Http\Livewire\Admin\Noticeboard\EditNotice;
use App\Http\Livewire\Admin\Noticeboard\Notice;
use App\Http\Livewire\Admin\Notifications\AddPushNotification;
use App\Http\Livewire\Admin\Paymentconformation\AddPayment;
use App\Http\Livewire\Admin\Paymentconformation\EditPayment;
use App\Http\Livewire\Admin\Paymentconformation\Payments;
use App\Http\Livewire\Admin\Reports\GenerateCombine;
use App\Http\Livewire\Admin\Reports\GeneratePermission;
use App\Http\Livewire\Admin\Reports\GenerateReports;
use App\Http\Livewire\Admin\Reports\GenerateSubjectCombine;
use App\Http\Livewire\Admin\Sendsms\AddSms;
use App\Http\Livewire\Admin\Sendsms\EditSms;
use App\Http\Livewire\Admin\Sendsms\Sms;
use App\Http\Livewire\Admin\Students\AddStudent;
use App\Http\Livewire\Admin\Students\EditStudent;
use App\Http\Livewire\Admin\Students\ListPaidStudents;
use App\Http\Livewire\Admin\Students\ListStudents;
use App\Http\Livewire\Admin\Students\ListUnpaidStudents;
use App\Http\Livewire\Admin\Subjects\AddSubject;
use App\Http\Livewire\Admin\Subjects\EditSubject;
use App\Http\Livewire\Admin\Subjects\ListSubjects;
use App\Http\Livewire\Admin\Teachers\AddTeacher;
use App\Http\Livewire\Admin\Teachers\AssignMultipleSubject;
use App\Http\Livewire\Admin\Teachers\ViewTeacherAssignments;
use App\Http\Livewire\Admin\Teachers\AssignSubject;
use App\Http\Livewire\Admin\Teachers\EditAssignSubject;
use App\Http\Livewire\Admin\Teachers\ListTeachers;
use App\Http\Livewire\Admin\Trimesters\AddTrimester;
use App\Http\Livewire\Admin\Trimesters\EditTrimester;
use App\Http\Livewire\Admin\Trimesters\ListTrimesters;
use App\Http\Livewire\Admin\Fee\FeesDiscount;
use App\Http\Livewire\Admin\Fee\AddFeeType;
use App\Http\Livewire\Admin\Fee\ListFeeTypes;
use App\Http\Livewire\Admin\Fee\EditFeeType;
use App\Http\Livewire\Admin\Fee\AddFeeGroup;
use App\Http\Livewire\Admin\Fee\ListFeeGroup;
use App\Http\Livewire\Admin\Fee\EditFeeGroup;
use App\Http\Livewire\Admin\Fee\AddFeeMaster;
use App\Http\Livewire\Admin\Fee\ListFeeMaster;
use App\Http\Livewire\Admin\Fee\EditFeeMaster;
use App\Http\Livewire\Admin\Fee\FeeAssign;
use App\Http\Livewire\Admin\Fee\FeeCollect;
use App\Http\Livewire\Admin\Fee\FeeCollection;
use App\Http\Livewire\Admin\Fee\PaymentReconciliationDashboard;
use App\Http\Livewire\Admin\Reports\PaymentReports;

use App\Http\Livewire\User\Fee\FeeCollectionUser;
use App\Http\Livewire\Admin\Reports\FeeReportController;
use App\Http\Controllers\StudentStatementController;


use App\Http\Livewire\Auth\Admin\AdminForgot;
use App\Http\Livewire\Auth\Admin\AdminLogin;
use App\Http\Livewire\Auth\Admin\AdminReset;
use App\Http\Livewire\Auth\Forgot;
use App\Http\Livewire\Auth\Login;
use App\Http\Livewire\Auth\Register;
use App\Http\Livewire\Auth\Reset;
use App\Http\Livewire\Auth\Verify;
use App\Http\Livewire\PdfViewer;
use App\Http\Livewire\User\Account\UserPassword;
use App\Http\Livewire\User\Account\UserProfile;
use App\Http\Livewire\User\Books\ListBooks;
use App\Http\Livewire\User\Books\UserShowBookChapterDetail;
use App\Http\Livewire\User\Books\UserShowBookChapters;
use App\Http\Livewire\User\Books\UserShowBookDetail;
use App\Http\Livewire\User\Books\UserShowCompletedBooks;
use App\Http\Livewire\User\Books\UserShowPrefferedBooks;
use App\Http\Livewire\User\Exams\StudentListExams;
use App\Http\Livewire\User\Plans\ModalPlan;
use App\Http\Livewire\User\Reports\UserGenerateReport;
use App\Http\Livewire\User\UserHome;
use App\Http\Livewire\Welcome;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
 */

Route::get( '/', Welcome::class )->name( 'index' );

Route::get( '/clear', function () {
    Artisan::call( 'cache:clear' );
    Artisan::call( 'config:clear' );
    Artisan::call( 'config:cache' );
    Artisan::call( 'view:clear' );
    return "Cleared!";
} );


Route::get('/storage/references/{any}', function (string $any) {
    $path = 'references/' . $any;

    if (!Storage::disk('public')->exists($path)) {
        abort(404);
    }

    return Storage::disk('public')->response($path, null, [
        'Content-Type'  => 'application/pdf',
        'Cache-Control' => 'public, max-age=86400',
    ]);
})->where('any', '.*');



// User Routes
Route::group( [
    'prefix' => '/',
], function () {
    Route::get( 'login', Login::class )->name( 'login' );
    Route::get( 'forgot', Forgot::class )->name( 'forgot' );
    Route::get( 'register', Register::class )->name( 'register' );
    Route::get( 'reset/{token}', Reset::class )->name( 'reset' );
    Route::get( 'verify/{slug}', Verify::class )->name( 'verify' );

    Route::group( [
        'middleware' => ['auth'],
    ], function () {
        Route::get( 'home', UserHome::class )->name( 'user.home' );

        Route::group( [
            'prefix' => 'account',
        ], function () {
            Route::get( 'profile', UserProfile::class )->name( 'user.profile' );
            Route::get( 'credentials', UserPassword::class )->name( 'user.credentials' );
        } );
        Route::group( [
            'prefix' => 'books',
        ], function () {
            Route::get( '/user-pdf-viewer/{slug}', [FlipController::class, 'index'] )->name( 'user.pd' );
            Route::get( 'e-completed-books', UserShowPrefferedBooks::class )->name( 'user.preffered.books' );
            Route::get( 'e-completed-books', UserShowCompletedBooks::class )->name( 'user.complete.books' );
            Route::get( 'e-books', ListBooks::class )->name( 'user.books' );
            Route::get( 'show/{slug}', UserShowBookDetail::class )->name( 'user.show.book' );
            Route::get( 'show-chapter/{slug}', UserShowBookChapterDetail::class )->name( 'user.show.chapter.info' );
            Route::get( 'book-chapter/{slug}', UserShowBookChapters::class )->name( 'user.show.book.chapter' );
        } );
        Route::group( [
            'prefix' => 'exams',
        ], function () {
            Route::get( 'exam-grades', StudentListExams::class )->name( 'user.exams' );
            Route::get( 'exam-report', UserGenerateReport::class )->name( 'user.report' );
            Route::get( '/pdf', [Controller::class, 'create'] )->name( 'pdf' );
            Route::get( '/exel', [Controller::class, 'generateExcel'] )->name( 'exel' );
        } );
        Route::group( [
            'prefix' => 'matrizes',
        ], function () {
            //Route::get('/pdf-viewer/{slug}', [FlipController::class, 'index'])->name('pd');
            //Route::get('add/', AddDownload::class)->name('admin.add.download');
            Route::get( 'matriz', Downloads::class )->name( 'admin.user.downloads' );
            /*Route::get('edit/{slug}', EditBook::class)->name('admin.edit.book');
            Route::get('show/{slug}', ShowBookDetail::class)->name('admin.show.book');
            Route::get('/viewer/{slug}', PdfViewer::class)->name('pdf-reader');*/
        } );
        Route::group( [
            'prefix' => 'paymentconfirmation',
        ], function () {
            Route::get( 'payments', Payments::class )->name( 'admin.user.payments' );
        } );
        Route::group( [
            'prefix' => 'fee',
        ], function () {
            Route::get( 'submit', FeeCollectionUser::class )->name( 'admin.user.fee' );
            Route::get( 'statement/download', [StudentStatementController::class, 'downloadStatement'] )->name( 'user.statement.download' );
        } );
        Route::group( [
            'prefix' => 'noticeboard',
        ], function () {
            //Route::get('add/', AddNotice::class)->name('admin.add.notice');
            Route::get( 'notice', Notice::class )->name( 'admin.user.notice' );
            //Route::get('edit/{slug}', EditNotice::class)->name('admin.edit.notice');
        } );
    } );
} );





// Admin Routes
Route::group( [
    'prefix' => 'admin',
], function () {
    Route::get( 'login', AdminLogin::class )->name( 'admin.login' );
    Route::get( 'forgot', AdminForgot::class )->name( 'admin.forgot' );
    Route::get( 'reset/{token}', AdminReset::class )->name( 'admin.reset' );

    Route::group( [
        'middleware' => ['auth:admin'],
    ], function () {
        Route::get( 'home', AdminHome::class )->name( 'admin.home' );
        Route::get( 'permission/', GeneratePermission::class )->name( 'admin.permission' );

        Route::group( [
            'prefix' => 'account',
        ], function () {
            Route::get( 'profile', AdminProfile::class )->name( 'admin.profile' );
            Route::get( 'credentials', AdminPassword::class )->name( 'admin.credentials' );
        } );
        Route::group( [
            'prefix' => 'admins',
        ], function () {
            Route::get( 'add/', AddAdmin::class )->name( 'admin.add.admin' );
            Route::get( 'edit/{slug}', EditAdmin::class )->name( 'admin.edit.admin' );
            Route::get( 'admins', ListAdmins::class )->name( 'admin.list.admins' );
            Route::get( 'export/pdf', [\App\Http\Controllers\Admin\ExportController::class, 'staffPDF'] )->name( 'admin.staff.export.pdf' );
            Route::get( 'export/excel', [\App\Http\Controllers\Admin\ExportController::class, 'staffExcel'] )->name( 'admin.staff.export.excel' );
        } );
        Route::group( [
            'prefix' => 'subjects',
        ], function () {
            Route::get( 'add/', AddSubject::class )->name( 'admin.add.subject' );
            Route::get( 'edit/{slug}', EditSubject::class )->name( 'admin.edit.subject' );
            Route::get( 'subjects', ListSubjects::class )->name( 'admin.list.subjects' );
            Route::get( 'export/pdf', [\App\Http\Controllers\Admin\ExportController::class, 'disciplinasPDF'] )->name( 'admin.subjects.export.pdf' );
            Route::get( 'export/excel', [\App\Http\Controllers\Admin\ExportController::class, 'disciplinasExcel'] )->name( 'admin.subjects.export.excel' );
        } );
        Route::group( [
            'prefix' => 'books',
        ], function () {
            Route::get( '/pdf-viewer/{slug}', [FlipController::class, 'index'] )->name( 'pd' );
            Route::get( 'add/', AddBook::class )->name( 'admin.add.book' );
            Route::get( 'edit/{slug}', EditBook::class )->name( 'admin.edit.book' );
            Route::get( 'show/{slug}', ShowBookDetail::class )->name( 'admin.show.book' );
            Route::get( 'books', AdminListBooks::class )->name( 'admin.list.books' );
            Route::get( '/viewer/{slug}', PdfViewer::class )->name( 'pdf-reader' );
        } );

        /*Route::group([
        'prefix' => 'books'
        ], function () {
        Route::get('/pdf-viewer/{slug}', [FlipController::class, 'index'])->name('pd');
        Route::get('add/', AddBook::class)->name('admin.add.book');
        Route::get('edit/{slug}', EditBook::class)->name('admin.edit.book');
        Route::get('show/{slug}', ShowBookDetail::class)->name('admin.show.book');
        Route::get('books', AdminListBooks::class)->name('admin.list.books');
        Route::get('/viewer/{slug}', PdfViewer::class)->name('pdf-reader');
        });*/


        Route::prefix('reports')->group(function() {
            //Route::get('fees-collection-report', [FeeReportController::class, 'feesCollectionReport'])->name('reports.feesCollection');
            Route::get('fees-collection-report', FeeReportController::class)->name('reports.feesCollection');
            Route::get('daily-collection-report', [FeeReportController::class, 'dailyCollectionReport'])->name('reports.dailyCollection');
            Route::get('balance-fees-report', [FeeReportController::class, 'balanceFeesReport'])->name('reports.balanceFees');
            Route::get('online-fees-collection-report', [FeeReportController::class, 'onlineFeesCollectionReport'])->name('reports.onlineFees');
            Route::get('fees-statement/{studentId}', [FeeReportController::class, 'feesStatement'])->name('reports.feesStatement');
            Route::get('income-report', [FeeReportController::class, 'incomeReport'])->name('reports.income');
            Route::get('expense-report', [FeeReportController::class, 'expenseReport'])->name('reports.expenses');
            Route::get('income-expense-balance-report', [FeeReportController::class, 'incomeExpenseBalanceReport'])->name('reports.incomeExpenseBalance');
        });

        Route::group( [
            'prefix' => 'matrizes',
        ], function () {
            //Route::get('/pdf-viewer/{slug}', [FlipController::class, 'index'])->name('pd');
            Route::get( 'add/', AddDownload::class )->name( 'admin.add.download' );
            Route::get( 'matriz', Downloads::class )->name( 'admin.downloads' );
            Route::get( 'edit/{slug}', EditDownload::class )->name( 'admin.edit.Download' );
            Route::get( 'export/pdf', [\App\Http\Controllers\Admin\ExportController::class, 'matrizesPDF'] )->name( 'admin.matrizes.export.pdf' );
            Route::get( 'export/excel', [\App\Http\Controllers\Admin\ExportController::class, 'matrizesExcel'] )->name( 'admin.matrizes.export.excel' );
            /*Route::get('show/{slug}', ShowBookDetail::class)->name('admin.show.book');
            Route::get('/viewer/{slug}', PdfViewer::class)->name('pdf-reader');*/
        } );

        Route::group( [
            'prefix' => 'paymentconfirmation',
        ], function () {

            Route::get( 'add/', AddPayment::class )->name( 'admin.add.payment' );
            Route::get( 'payments', Payments::class )->name( 'admin.payments' );
            Route::get( 'edit/{slug}', EditPayment::class )->name( 'admin.edit.payment' );

        } );

        Route::group( [
            'prefix' => 'sendsms',
        ], function () {
            Route::get( 'add/', AddSms::class )->name( 'admin.add.sms' );
            Route::get( 'sms', Sms::class )->name( 'admin.sms' );
            Route::get( 'edit/{slug}', EditSms::class )->name( 'admin.edit.sms' );
            Route::get( 'export/pdf', [\App\Http\Controllers\Admin\ExportController::class, 'smsPDF'] )->name( 'admin.sms.export.pdf' );
            Route::get( 'export/excel', [\App\Http\Controllers\Admin\ExportController::class, 'smsExcel'] )->name( 'admin.sms.export.excel' );
        } );

        Route::group( [
            'prefix' => 'notifications',
        ], function () {
            Route::get( 'add/', AddPushNotification::class )->name( 'admin.add.notification' );
            // Add more routes for notifications as needed
        } );

        Route::group( [
            'prefix' => 'noticeboard',
        ], function () {

            Route::get( 'add/', AddNotice::class )->name( 'admin.add.notice' );
            Route::get( 'notice', Notice::class )->name( 'admin.notice' );
            Route::get( 'edit/{slug}', EditNotice::class)->name('admin.edit.notice');
            Route::get( 'export/pdf', [\App\Http\Controllers\Admin\ExportController::class, 'comunicadosPDF'] )->name( 'admin.comunicados.export.pdf' );
            Route::get( 'export/excel', [\App\Http\Controllers\Admin\ExportController::class, 'comunicadosExcel'] )->name( 'admin.comunicados.export.excel' );

        } );

        Route::group( [
            'prefix' => 'chapters',
        ], function () {
            Route::get( 'add/', AddBookChapter::class )->name( 'admin.add.chapter' );
            Route::get( 'edit/{slug}', EditBookChapter::class )->name( 'admin.edit.chapter' );
            Route::get( 'show/{slug}', ShowChapterDetails::class )->name( 'admin.show.book.chapter' );
            Route::get( 'chapters', ListBookChapters::class )->name( 'admin.list.chapters' );
            Route::get( 'book-chapters/{slug}', ShowBookChapters::class )->name( 'admin.list.book.chapter' );
        } );

        Route::group( [
            'prefix' => 'classes',
        ], function () {
            Route::get( 'add/', AddClass::class )->name( 'admin.add.class' );
            Route::get( 'add-student-grade/{slug}', ModalPlan::class )->name( 'admin.add.student.grade' );
            Route::get( 'academic-edit-results/{slug}', AcademicEditResults::class )->name( 'admin.edit.class.students.academic' );
            Route::get( 'academic-students/{slug}', AcademicViewResults::class )->name( 'admin.list.class.students.academic' );
            Route::get( 'edit/{slug}', EditClass::class )->name( 'admin.edit.class' );
            Route::get( 'student-marks/{slug}', TeacherViewMarksStudent::class )->name( 'admin.list.students.marks' );
            Route::get( 'teacher-students/{slug}', TeacherListClassStudents::class )->name( 'admin.list.class.students.teacher' );
            Route::get( 'class-students/{slug}', ListClassStudents::class )->name( 'admin.list.class.students' );
            Route::get( 'class-update-students/{slug}', ListClassUpdateStudents::class )->name( 'admin.list.class.update.students' );
            Route::get( 'class-passed-students/', ListClassPassedStudents::class )->name( 'admin.list.class.passed.students' );
            Route::get( 'classes', ListClasses::class )->name( 'admin.list.classes' );
            Route::get( 'teacher-classes', TeacherListClasses::class )->name( 'admin.list.classes.teacher' );
            Route::get( 'export/pdf', [\App\Http\Controllers\Admin\ExportController::class, 'turmasPDF'] )->name( 'admin.classes.export.pdf' );
            Route::get( 'export/excel', [\App\Http\Controllers\Admin\ExportController::class, 'turmasExcel'] )->name( 'admin.classes.export.excel' );
        } );
        Route::group( [
            'prefix' => 'grades',
        ], function () {
            Route::get( 'add/', AddGrade::class )->name( 'admin.add.grade' );
            Route::get( 'edit/{slug}', EditGrade::class )->name( 'admin.edit.grade' );
            Route::get( 'grades', ListGrades::class )->name( 'admin.list.grades' );
            Route::get( 'edit-grades/{id}', ClassesModalTest::class )->name( 'admin.edit.student.exam' );
        } );
        Route::group( [
            'prefix' => 'categories',
        ], function () {
            Route::get( 'add/', AddCategory::class )->name( 'admin.add.category' );
            Route::get( 'edit/{slug}', EditCategory::class )->name( 'admin.edit.category' );
            Route::get( 'categories', ListCategories::class )->name( 'admin.list.categories' );
        } );
        Route::group( [
            'prefix' => 'trimesters',
        ], function () {
            Route::get( 'add/', AddTrimester::class )->name( 'admin.add.trimester' );
            Route::get( 'edit/{slug}', EditTrimester::class )->name( 'admin.edit.trimester' );
            Route::get( 'trimesters', ListTrimesters::class )->name( 'admin.list.trimesters' );
        } );
        Route::group( [
            'prefix' => 'exams-grades',
        ], function () {
            Route::get( 'add/', AddExam::class )->name( 'admin.add.exam' );
            Route::get( 'add/1a', AddExam1a::class )->name( 'admin.add.exam1' );
            Route::get( 'add/2a', AddExam2a::class )->name( 'admin.add.exam2' );
            Route::get( 'edit/{id}', EditExam::class )->name( 'admin.edit.exam' );
            Route::get( 'exam-grades', ListExams::class )->name( 'admin.list.exams' );
            Route::get('batch-marks', BatchMarksEntry::class)->name('admin.batch.marks');
            Route::get('excel-import', ExcelImportMarks::class)->name('admin.excel.import.marks');
            Route::get('download-template', [ExcelTemplateController::class, 'downloadMarksTemplate'])
                ->name('admin.download.marks.template');
        } );
        Route::group( [
            'prefix' => 'students',
        ], function () {
            Route::get( 'add/', AddStudent::class )->name( 'admin.add.student' );
            Route::get( 'edit/{slug}', EditStudent::class )->name( 'admin.edit.student' );
            Route::get( 'students', ListStudents::class )->name( 'admin.list.students' );
            Route::get( 'unpaid-students', ListUnpaidStudents::class )->name( 'admin.list.unpaid.students' );
            Route::get( 'paid-students', ListPaidStudents::class )->name( 'admin.list.paid.students' );
            Route::get( 'export/pdf', [\App\Http\Controllers\Admin\ExportController::class, 'estudantesPDF'] )->name( 'admin.students.export.pdf' );
            Route::get( 'export/excel', [\App\Http\Controllers\Admin\ExportController::class, 'estudantesExcel'] )->name( 'admin.students.export.excel' );
            Route::get( 'paid-students/export/pdf', [\App\Http\Controllers\Admin\ExportController::class, 'paidStudentsPDF'] )->name( 'admin.paid.students.export.pdf' );
            Route::get( 'paid-students/export/excel', [\App\Http\Controllers\Admin\ExportController::class, 'paidStudentsExcel'] )->name( 'admin.paid.students.export.excel' );
            Route::get( 'unpaid-students/export/pdf', [\App\Http\Controllers\Admin\ExportController::class, 'unpaidStudentsPDF'] )->name( 'admin.unpaid.students.export.pdf' );
            Route::get( 'unpaid-students/export/excel', [\App\Http\Controllers\Admin\ExportController::class, 'unpaidStudentsExcel'] )->name( 'admin.unpaid.students.export.excel' );
        } );
        Route::group( [
            'prefix' => 'reports',
        ], function () {
            Route::get( 'trimester-report/', GenerateReports::class )->name( 'admin.report' );
            Route::get( 'subject-report/', GenerateSubjectCombine::class )->name( 'admin.subject.report' );
            Route::get( 'combine-report/', GenerateCombine::class )->name( 'admin.combine.report' );
            // Route::get('/display-reports/{subject_id}/{class_id}/{trimester_id}', PaymentDisplay::class)->name('display.reports');
        } );
        Route::group( [
            'prefix' => 'teachers',
        ], function () {
            Route::get( 'add/', AssignSubject::class )->name( 'admin.add.teacher.subject' );
            Route::get( 'add-multiple/', AssignMultipleSubject::class )->name( 'admin.add.teacher.subject' );
            Route::get( 'edit/{id}', EditAssignSubject::class )->name( 'admin.edit.teacher.subject' );
            Route::get( 'add-teacher/', AddTeacher::class )->name( 'admin.add.teacher' );
            Route::get( 'teachers', ListTeachers::class )->name( 'admin.list.teachers' );
            Route::get( 'view-assign/', ViewTeacherAssignments::class )->name('teachers.assignments.view');
            Route::get( 'export/pdf', [\App\Http\Controllers\Admin\ExportController::class, 'professoresPDF'] )->name( 'admin.teachers.export.pdf' );
            Route::get( 'export/excel', [\App\Http\Controllers\Admin\ExportController::class, 'professoresExcel'] )->name( 'admin.teachers.export.excel' );
        } );


        Route::group([
            'prefix' => 'fee',
        ], function () {
            Route::get( 'fees-discount/', FeesDiscount::class)->name('admin.fee.feesdiscount');
            Route::get( 'add/', AddFeeType::class)->name('admin.fee.addtype');
            Route::get( 'edit/{id}', EditFeeType::class )->name( 'admin.edit.feetype' );
            Route::get( 'fee-types', ListFeeTypes::class )->name( 'admin.list.feetypes' );
            Route::get( 'add-group', AddFeeGroup::class )->name( 'admin.add.feegroup' );
            Route::get( 'fee-groups', ListFeeGroup::class )->name( 'admin.list.feegroups' );
            Route::get( 'group-edit/{id}', EditFeeGroup::class )->name( 'admin.edit.feegroup' );
            Route::get( 'add-master/{id?}', AddFeeMaster::class )->name( 'admin.add.feemaster' );
            Route::get( 'fee-masters', ListFeeMaster::class )->name( 'admin.list.feemaster' );
            Route::get( 'master-edit/{id}', EditFeeMaster::class )->name( 'admin.edit.feemaster' );
            Route::get( 'fee-assign/{id}', FeeAssign::class )->name( 'admin.fee.assign' );
            Route::get( 'addfee/{studentId}', FeeCollection::class)->name( 'admin.fee.collect' );
            Route::get( 'collectfee/{studentId}', FeeCollection::class)->name( 'admin.fee.collectfee' );
            Route::get( 'feecollect', FeeCollect::class)->name( 'admin.fee.collectfee' );
            Route::get( 'dashboard', PaymentReconciliationDashboard::class)->name('admin.fee.dashboard');
            Route::get( 'reports', PaymentReports::class)->name('admin.fee.reports');
            Route::get( 'reports/export/excel', [\App\Http\Controllers\Admin\ExportController::class, 'paymentReportsExcel'])->name('admin.fee.reports.export.excel');
            Route::get( 'reports/export/pdf', [\App\Http\Controllers\Admin\ExportController::class, 'paymentReportsPDF'])->name('admin.fee.reports.export.pdf');
            Route::get( 'statement/download', [StudentStatementController::class, 'downloadStatement'])->name('admin.statement.download');
            Route::get( 'deadlines', \App\Http\Livewire\Admin\Fee\FeeMonthDeadlineManager::class)->name('admin.fee.deadlines');


        });


    } );

} );
