<?php

namespace App\Http\Livewire\Admin\Classes;

use App\Models\Classroom;
use App\Models\Exam;
use App\Models\Project;
use App\Models\User;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;
use Carbon\Carbon;

class AcademicEditResults extends Component
{
    use FindGuard, LivewireAlert;
    use WithPagination;

    public $search;
    public $model, $name;
    public $selectedYear = ''; // Add property to hold the selected year
    protected $queryString = ['search'];

    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    public function mount($slug)
    {
        $this->model = User::query()->where('slug', $slug)->first();
    }

    public function render()
    {
        $currentYear = Carbon::now()->year;

        // Apply filter by selected year if it's not empty
        $query = Exam::query()
                    ->latest('updated_at')
                    ->where('student_id', $this->model->id)
                    ->where(function ($query) {
                        $query->orWhere('ACS1a', 'like', '%' . $this->search . '%')
                            ->orWhere('ACS2a', 'like', '%' . $this->search . '%')
                            ->orWhere('MACS', 'like', '%' . $this->search . '%');
                            
                    });

        if (!empty($this->selectedYear)) {
            $query->whereYear('updated_at', $this->selectedYear);
        } else {
            // If no year is selected, default to current year
            $query->whereYear('updated_at', $currentYear);
        }

        // Paginate the results
        $models = $this->readyToLoad ? $query->paginate(100) : [];

        return view('livewire.admin.classes.academic-edit-results', [
            'models' => $models,
            'currentYear' => $currentYear, // Pass the current year to the view
        ]);
    }
}
