<?php

namespace App\Http\Livewire\Admin\Downloadcenter;

use App\Models\Admin;
use App\Models\Downloadcenter;
use App\Models\Classroom;
use App\Models\User;
use App\Models\Downloadfile;
use App\Models\Downloadsetings;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;
use App\Http\Controllers\SystemController;
use App\Models\Category;
use Livewire\WithFileUploads;

class AddDownload extends Component
{
    use FindGuard, LivewireAlert, WithFileUploads;

    
    public $media_details; 
    public $title, $description, $category_id, $photo, $photos = [], $pdf, $author,  $validatedData, $type, $class_id, $student_id;
    public $updateMode = false;
    public $user;
    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    protected array $rules = [
        'title' => ['required', 'string', 'max:255'],
        'author' => ['required', 'string', 'max:255'],
        'description' => ['nullable', 'string', 'max:255'],
        'photos.*' => ['required', 'mimes:pdf,doc,docx,xls,xlsx,png,jpeg,jpg,gif', 'max:5048'],
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);

    }

//     public function submit()
//     {
//         //$this->validatedData = $this->validate();

//         $details = SystemController::store_media($this->photo);
        
//         $downloadcenter = Downloadcenter::query()->create([
//             'title' => $this->title,
//              'author' => $this->author,
//             'description' => $this->description,
//         ]);

// Downloadfile::query()->create([
//     'download_id'=>$downloadcenter->slug,
//     'media_name'=> $details[0],
//     'media_url'=>$details[1],
// ]);
// if(empty($this->type)){
//     $this->type = "all";
// }
// Downloadsetings::query()->create([
//     'type'=>$this->type,
//     'class_id'=> $this->class_id,
//     'student_id'=>$this->student_id,
//     "download_id"=>$downloadcenter->slug,
//     "active"=>"active",
// ]);
//         Note::createSystemNotification(Admin::class, 'Nova matriz', 'Nova matriz adicionada com sucesso ' . $this->title);
//         $this->emit('noteAdded');
//         $this->alert('success', 'Nova matriz adicionada com sucesso ' . $this->title . $downloadcenter->slug);
//         $this->reset();

//     }

public function submit()
{
    $this->validate(); // Validate all fields including multiple files
    
    foreach ($this->photos as $photo) {
        $details = SystemController::store_media($photo);
        
        $downloadcenter = Downloadcenter::create([
            'title' => $this->title,
            'author' => $this->author,
            'description' => $this->description,
        ]);

        Downloadfile::create([
            'download_id' => $downloadcenter->slug,
            'media_name' => $details[0],
            'media_url' => $details[1],
        ]);

        if (empty($this->type)) {
            $this->type = "all";
        }

        Downloadsetings::create([
            'type' => $this->type,
            'class_id' => $this->class_id,
            'student_id' => $this->student_id,
            "download_id" => $downloadcenter->slug,
            "active" => "active",
        ]);
        
        Note::createSystemNotification(Admin::class, 'Nova matriz', 'Nova matriz adicionada com sucesso ' . $this->title);
        $this->emit('noteAdded');
        $this->alert('success', 'Nova matriz adicionada com sucesso ' . $this->title . $downloadcenter->slug);
    }

    $this->reset();
}

    public function confirmed()
    {

        
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        if(!empty($this->type)){
            return view('livewire.admin.downloadcenter.add-download', [
                'Classroom' => Classroom::query()->orderBy('class')->get(),
                'students' => User::Where("classroom_id",$this->class_id)->get(),
            ]);
        }else{
            return view('livewire.admin.downloadcenter.add-download', [
                'Classroom' => Classroom::query()->orderBy('class')->get(),
            ]);
        }
    }
}
