<?php

namespace App\Http\Livewire\Admin\Downloadcenter;

use App\Models\Downloadcenter;
use App\Models\Downloadsetings;
use App\Models\User;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;
use Auth;

class Downloads extends Component
{
    // Disable lazy loading for this component
    protected $lazy = false;
    use WithPagination, FindGuard, LivewireAlert;

    public $search = '', $delete,$slug;
    public $filter = '';


    protected $queryString = ['search'];

    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function submit($id)
    {
        
        $this->delete = Downloadcenter::query()->firstWhere('slug', $id);
        //dd($this->delete);
        //echo $id;echo $this->delete->slug; exit();
        $this->slug = $this->delete->slug;
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => "confirmed",
            'onDismissed' => 'cancelled',
            'slug'=>$id,
        ]);
    }

    public function confirmed()
    {
        Downloadcenter::where('slug', $this->slug)->delete();
        Downloadsetings::where('download_id', $this->slug)->delete();
        Note::createSystemNotification(Admin::class, 'Matriz', 'Deletado com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Deletado com sucesso ');
        return back();
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {

        $qq = Downloadsetings::get();
        
                       
        $user = Auth::user();

        
        if(isset($user->role) && $user->role == 0 || $user->role == 3 ){

            return view('livewire.admin.downloadcenter.downloads', [
                    'models' => $this->readyToLoad
                        ? Downloadsetings::query() ->orderByDesc('created_at')->paginate(10)
                        : []
                ]
            );
        }elseif(!isset($user->role) ){
            $userr = User::where("id",$user->id)->first();

            return view('livewire.admin.downloadcenter.downloads', [
                    'models' => $this->readyToLoad
                        ? Downloadsetings::query()->orderByDesc('created_at')->orWhere("type","all")->orWhere("class_id",$userr->classroom_id)->paginate(10)
                        : [],
                    'student' => true,    
                ]
            );
        }
    }
}



