<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title"> Detalhes de livro</h5>
                            <form class="row g-3" wire:submit.prevent="submit">
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Titulo</label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror"
                                        id="title" readonly required placeholder="Insira o titulo..."  name="title" wire:model="title" >
                                    @error('title')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Disciplina/Categoria </label>
                                    <select readonly class="form-control @error('category_id') is-invalid @enderror"
                                            id="name" wire:model="category_id"
                                            class="form-control input-lg dynamic">
                                        <option value="">Por favor selecione a disciplina/categoria</option>
                                        @foreach($subjects as $subject)
                                            <option value="{{ $subject->id }}"> {{ $subject->name }} </option>
                                        @endforeach
                                    </select>
                                    @error('category_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-12">
                                    <img src="{{ $model->media_url }}" style="height:200px; widht:200px">
                                </div>
                                <div class="col-md-12" wire:model.debounce.365ms="description" wire:ignore>
                                    <label for="description" class="form-label"><b> Descrição</b></label>
                                    <p>{!! $description !!}</p>
                                    @error('description')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div wire:loading wire:target="photo"><span
                                    class="spinner-border spinner-border-sm"></span> Carregando
                            </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
