<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
    <META NAME="ROBOTS" CONTENT="INDEX, FOLLOW">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(config('app.name', '')); ?></title>
    <link rel="icon" type="image/png" href="<?php echo e(asset('assets/images/logo.png')); ?>">
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/logo.png')); ?>" type="image/x-icon">

    <meta name="author" content="">
    <meta property="og:type" content="website" />
    <meta property="og:title" content="<?php echo e(config('app.name')); ?>" />
    <meta property="og:image" content="<?php echo e(asset('assets/images/logo.png')); ?>" />
    <meta property="og:description" content="" />

    <!-- Styles -->
    <link href="https://fonts.googleapis.com/css?family=Poppins:400,500,700,800&display=swap" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/font-awesome/css/all.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/perfectscroll/perfect-scrollbar.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/apexcharts/apexcharts.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/DataTables/datatables.min.css')); ?>" rel="stylesheet">

    <!-- Theme Styles -->
    <link href="<?php echo e(asset('assets/css/main.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/custom.css')); ?>" rel="stylesheet">
    <?php echo \Livewire\Livewire::styles(); ?>

    <?php echo view('laravel-trix::trixassets')->render(); ?>
    <style>
        .footer-text-left {
            font-size: 15px;
            padding-left: 500px;
            float: center;
            word-spacing: 20px;
        }
    </style>
</head>

<body>
    <div class='loader' wire:loading>
        <div class='spinner-grow text-primary' role='status'>
            <span class='sr-only'>Processando...</span>
        </div>
    </div>



    <div class="page-container">
        <?php if(request()->is('admin/*')): ?>
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('admin.inc.header', [])->html();
} elseif ($_instance->childHasBeenRendered('vpSJ2nY')) {
    $componentId = $_instance->getRenderedChildComponentId('vpSJ2nY');
    $componentTag = $_instance->getRenderedChildComponentTagName('vpSJ2nY');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('vpSJ2nY');
} else {
    $response = \Livewire\Livewire::mount('admin.inc.header', []);
    $html = $response->html();
    $_instance->logRenderedChild('vpSJ2nY', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('admin.inc.sidebar', [])->html();
} elseif ($_instance->childHasBeenRendered('3C8DkpN')) {
    $componentId = $_instance->getRenderedChildComponentId('3C8DkpN');
    $componentTag = $_instance->getRenderedChildComponentTagName('3C8DkpN');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('3C8DkpN');
} else {
    $response = \Livewire\Livewire::mount('admin.inc.sidebar', []);
    $html = $response->html();
    $_instance->logRenderedChild('3C8DkpN', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
        <?php else: ?>
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('user.inc.header', [])->html();
} elseif ($_instance->childHasBeenRendered('rnZ1hSZ')) {
    $componentId = $_instance->getRenderedChildComponentId('rnZ1hSZ');
    $componentTag = $_instance->getRenderedChildComponentTagName('rnZ1hSZ');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('rnZ1hSZ');
} else {
    $response = \Livewire\Livewire::mount('user.inc.header', []);
    $html = $response->html();
    $_instance->logRenderedChild('rnZ1hSZ', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('user.inc.sidebar', [])->html();
} elseif ($_instance->childHasBeenRendered('FziABY3')) {
    $componentId = $_instance->getRenderedChildComponentId('FziABY3');
    $componentTag = $_instance->getRenderedChildComponentTagName('FziABY3');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('FziABY3');
} else {
    $response = \Livewire\Livewire::mount('user.inc.sidebar', []);
    $html = $response->html();
    $_instance->logRenderedChild('FziABY3', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
        <?php endif; ?>
        <?php echo e($slot); ?>

        <div class="container">
            <div class="row">
                <div class="col-md-2"></div>
                <div class="col-md-8">
                    <div class="footer">
                        <p class="footer-text-center">&copy;<b class="text-info"> <?php echo e(date('Y')); ?>.&nbsp;
                                <?php echo e(config('app.name')); ?>.</b> <a href="<?php echo e(route('index')); ?>">Todos os direitos reservados.</a>
                            &nbsp; &nbsp;COLÉGIO POLITÉCNICO DE MOÇAMBIQUE &nbsp; &nbsp;&nbsp; &nbsp; Desenvolvido por iFix, Lda</p>

                    </div>
                </div>
                <div class="col-md-2"></div>
            </div>

        </div>


    </div>

    <!-- Javascripts -->
    <script src="<?php echo e(asset('assets/plugins/jquery/jquery-3.4.1.min.js')); ?>"></script>
    <script src="https://unpkg.com/@popperjs/core@2"></script>
    <script src="<?php echo e(asset('assets/plugins/bootstrap/js/bootstrap.min.js')); ?>"></script>
    <script src="https://unpkg.com/feather-icons"></script>
    <script src="<?php echo e(asset('assets/plugins/perfectscroll/perfect-scrollbar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/apexcharts/apexcharts.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/main.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pages/dashboard.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pages/datatables.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/DataTables/datatables.min.js')); ?>"></script>
    <?php echo $__env->yieldContent('scripts'); ?>
    <script src="<?php echo e(asset('assets/js/sweetalert.js')); ?>"></script>
    <?php if (isset($component)) { $__componentOriginal71c6471fa76ce19017edc287b6f4508c = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'livewire-alert::components.scripts','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('livewire-alert::scripts'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal71c6471fa76ce19017edc287b6f4508c)): ?>
<?php $component = $__componentOriginal71c6471fa76ce19017edc287b6f4508c; ?>
<?php unset($__componentOriginal71c6471fa76ce19017edc287b6f4508c); ?>
<?php endif; ?>
    <?php echo \Livewire\Livewire::scripts(); ?>

</body>

</html>
<?php /**PATH /home/1165120.cloudwaysapps.com/ttmjqktapb/public_html/resources/views/layouts/app.blade.php ENDPATH**/ ?>