<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use Illuminate\Support\Facades\Log;
use Twilio\Rest\Client;
use Carbon\Carbon;

class SendBirthdayMessages extends Command
{
    protected $signature = 'send:birthday-messages';
    protected $description = 'Envia mensagens de feliz aniversário aos estudantes';

    public function handle()
    {
        $today = Carbon::today()->format('m-d'); // Obtém MM-DD
        $students = User::whereRaw("DATE_FORMAT(dob, '%m-%d') = ?", [$today])->get();

        if ($students->isEmpty()) {
            Log::info('Nenhum estudante faz aniversário hoje.');
            return;
        }

        $twilio_sid = env('TWILIO_SID');
        $twilio_token = env('TWILIO_TOKEN');
        $twilio_number = env('TWILIO_FROM');
        $client = new Client($twilio_sid, $twilio_token);

        foreach ($students as $student) {
            $message = "🎉 Feliz Aniversário, {$student->name}! 🎂🎁 Que sua trajetória acadêmica seja repleta de conquistas e sucesso. Votos do COPMOZ";
            
            try {
                $client->messages->create(
                    '+258' . $student->phone_number,
                    [
                        'from' => $twilio_number,
                        'body' => $message,
                    ]
                );
                Log::info("Mensagem enviada para {$student->name} ({$student->phone_number})");
            } catch (\Exception $e) {
                Log::error("Erro ao enviar mensagem para {$student->name}: " . $e->getMessage());
            }
        }
    }
}

