<?php

namespace App\Http\Livewire\Admin\Classes;

use App\Jobs\MailJob;
use App\Models\Account;
use App\Models\Admin;
use App\Models\Classroom;
use App\Models\Exam;
use App\Models\Student;
use App\Models\Subject;
use App\Models\Trimester;
use App\Models\User;
use Illuminate\Validation\Rule;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;

class ClassesModalTest extends Component
{
    protected $lazy = false;
    use FindGuard, LivewireAlert;

    public bool $readyToLoad = false;
    public $search, $model, $user;
    public $ACS1a, $ACS2a, $MACS, $AT, $classroom_id, $subject_id;
    public $phone;
    public $plan_id;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];
    protected array $rules = [
        'ACS1a' => ['required', 'numeric', 'min:0', 'max:20'],
        'ACS2a' => ['required', 'numeric', 'min:0', 'max:20'],
        'AT' => ['required', 'numeric', 'min:0', 'max:20'],
    ];
    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }
    public function mount($id){
        $this->model=Exam::query()->where('id', $id)->first();
        $this->AT=$this->model->AT;
        $this->ACS1a=$this->model->ACS1a;
        $this->ACS2a=$this->model->ACS2a;
        $this->subject_id=$this->model->subject->name;
        $this->classroom_id=$this->model->class->name;
    }
    public function submit()
    {
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        Exam::query()->where('id', $this->model->id)->update([
            'ACS1a' => $this->ACS1a,
            'ACS2a' => $this->ACS2a,
            'AT' => $this->AT,
        ]);
        Note::createSystemNotification(Admin::class, 'Notas do aluno', 'Editadas com sucesso');
        $this->emit('noteAdded');
        $this->alert('success', 'Notas do aluno editadas com sucesso');
        return redirect()->route('admin.edit.class.students.academic', $this->model->student->slug);
   }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        $this->user = $this->findGuardType()->user();
        return view('livewire.admin.classes.classes-modal-test', [
            'classes' => Classroom::query()->orderBy('name')->get(),
            'trimesters' => Trimester::query()->orderBy('name')->get(),
            'subjects' => Subject::query()->orderBy('name')->whereRelation('teachersubject', 'teacher_id', '=', $this->user->id)->get(),
            'students' => Student::query()->orderBy('name')->get(),
        ]);
    }
}
