<?php

namespace App\Http\Livewire\Admin\Exams;

use App\Jobs\MailJob;
use App\Models\Account;
use App\Models\Classroom;
use App\Models\Exam;
use App\Models\Student;
use App\Models\Subject;
use App\Models\Trimester;
use App\Models\User;
use Illuminate\Validation\Rule;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;

class AddExam extends Component
{
    use FindGuard, LivewireAlert;

    public $student_id, $subject_id, $trimester_id, $MACS;
    public $validatedData;
    public $updateMode = false;

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    protected array $rules = [
        'student_id' => ['required', 'string', 'max:255'],
        'subject_id' => ['required', 'string', 'max:255'],
        'trimester_id' => ['required', 'string', 'max:255'],
        'MACS' => ['required', 'string', 'max:255'],
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function submit()
    {
        $this->validatedData = $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
         // check if the student is existing
       $check=Exam::query()->where('student_id', $this->student_id)->where('trimester_id', $this->trimester_id)
        ->where('subject_id', $this->subject_id)->first();
        if ($check) {
                   //check if ACS2a is greater than 0
             if ($check->MACS) {
                    //calculate macs
                    $macs = ($check->MACS + $this->MACS) / 2;
                    Exam::query()->updateOrCreate([
                        'student_id' => $this->student_id,
                    ], [
                        'subject_id' => $this->subject_id,
                        'trimester_id' => $this->trimester_id,
                        'classroom_id' => Student::query()->where('id', $this->student_id)->first()->classroom_id,
                        'ACS1a' => $this->MACS,
                        'MT' => $macs,
                    ]);
                }
            Exam::query()->updateOrCreate([
                'student_id' => $this->student_id,
            ], [
                'subject_id' => $this->subject_id,
                'trimester_id' => $this->trimester_id,
                'classroom_id' => Student::query()->where('id', $this->student_id)->first()->classroom_id,
                'AT' => $this->MACS,
            ]);
            Note::createSystemNotification(Admin::class, 'MACS', 'Criado com sucesso ' . $this->MACS);
            $this->emit('noteAdded');
            $this->alert('success', 'Criado com sucesso ' . $this->MACS);
            return back();
        }

        Exam::query()->Create([
            'student_id' => $this->student_id,
            'subject_id' => $this->subject_id,
            'trimester_id' => $this->trimester_id,
            'classroom_id' => Student::query()->where('id', $this->student_id)->first()->classroom_id,
            'AT' => $this->MACS,
        ]);
        Note::createSystemNotification(Admin::class, 'MACS', 'Criado com sucesso ' . $this->MACS);
        $this->emit('noteAdded');
        $this->alert('success', 'Criado com sucesso ' . $this->MACS);
        $this->reset();
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        return view('livewire.admin.exams.add-exam', [
            'classes' => Classroom::query()->orderBy('name')->get(),
            'trimesters' => Trimester::query()->orderBy('name')->get(),
            'subjects' => Subject::query()->orderBy('name')->get(),
            'students' => Student::query()->orderBy('name')->get(),
        ]);
    }
}
