<?php

namespace App\Http\Livewire\Admin\Paymentconformation;

use App\Models\PaymentConfirmation;
use App\Models\User;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;
use Auth;
use App\Models\Classroom;
class Payments extends Component
{
    use WithPagination, FindGuard, LivewireAlert;

    public $searchTerm = ''; // Definindo a propriedade searchTerm
    public $delete, $slug, $classes;
    public $selectedClass = null; // Holds the selected class ID
    protected $queryString = ['searchTerm'];
    protected string $paginationTheme = 'bootstrap';
    public bool $readyToLoad = true;

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function submit($id)
    {
        $this->delete = PaymentConfirmation::query()->firstWhere('slug', $id);
        $this->slug = $this->delete->slug;
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => "confirmed",
            'onDismissed' => 'cancelled',
            'slug'=>$id,
        ]);
    }

    public function confirmed()
    {
        PaymentConfirmation::where('slug', $this->slug)->delete();
        Note::createSystemNotification(Admin::class, 'Conf. de pagamento', 'Deletado com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Deletado com sucesso ');
        return back();
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }
    

    public function render()
    {
        $user = Auth::user();
        
        // Fetch the list of classes
        $this->classes = Classroom::where('is_active', 1)->orderByRaw('CAST(class AS UNSIGNED) ASC')->get();

        // Base query
        $query = PaymentConfirmation::query()
            ->where(function ($q) use ($user) {
                    if (isset($user->role) && ($user->role == 0 || $user->role == 3))  { // Check if the user's role is 0
                    // Show all if the role is 0 (assumed to be admin)
                    $q->where('type', '<>', ''); // This line can simply be left out if you want to show all records
                } else {
                    // Otherwise, show records posted to 'all' or specifically for the user
                    $q->where('type', 'all')
                      ->orWhere('student_id', $user->id);
                }
            });
        
        // Apply class filter if selected
          if (!empty($this->selectedClass)) {
              $query->where('class_id', $this->selectedClass);
          }
        
        // Aplicar busca se $searchTerm não for vazio
         if (!empty($this->searchTerm)) {
             $query->where(function ($q) {
                 $q->where('title', 'like', '%' . $this->searchTerm . '%')
                   ->orWhere('media_name', 'like', '%' . $this->searchTerm . '%');
             });
         }

        // Fetch data
        $models = $this->readyToLoad
            ? $query->orderBy('created_at', 'desc')->paginate(10)
            : [];

        // Process data after fetching
        if (!empty($models)) {
            $models->getCollection()->transform(function ($model) {
                $processed = [];
                $processed['id'] = $model->id;
                $processed['title'] = $model->title;

                // Determine type title
                $processed['typeTitle'] = match ($model->type) {
                    'all' => 'Todos',
                    'student' => 'Estudante',
                    'class' => 'Classe',
                    default => 'Outro',
                };

                // Class details
                if (!empty($model->class_id)) {
                    $class = Classroom::find($model->class_id);
                    $processed['classDetails'] = $class ? "{$class->class} class {$class->name}" : null;
                } else {
                    $processed['classDetails'] = null;
                }

                // Student details
                if (!empty($model->student_id)) {
                    $student = User::find($model->student_id);
                    $processed['studentName'] = $student ? $student->name : null;
                } else {
                    $processed['studentName'] = null;
                }

                // Media details
                $processed['mediaUrl'] = $model->media_url;
                $processed['mediaName'] = $model->media_name;

                return $processed;
            });
        }

        return view('livewire.admin.paymentconfirmation.payments', [
            'models' => $models,
            'classes' => $this->classes, // Pass classes to the view
        ]);
    }

}
