<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FeeMaster1 extends Model
{
    use HasFactory;

    // Specify the table name
    protected $table = 'fee_master1s';

    // Specify the fillable fields with correct column names
    protected $fillable = [
        'fee_group_id',  
        'fee_type_id',   
        'due_date',
        'amount',
        'fine_type',
        'percentage',
        'fixed_amount',
    ];

    // Define the relationship with FeeGroup
    public function feeGroup()
    {
        return $this->belongsTo(FeeGroup::class, 'fee_group_id'); 
    }

    // Define the relationship with FeeType
    public function feeType()
    {
        return $this->belongsTo(FeeType::class, 'fee_type_id');
    }
}
