<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Http\Resources\Json\JsonResource;



class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot()
    {
        JsonResource::withoutWrapping();

        // Set global JSON response behavior
        response()->macro('json', function ($value = null, $status = 200, array $headers = [], $options = 0) {
            return response()->json($value, $status, $headers, $options | JSON_UNESCAPED_UNICODE);
        });
    }
}
