<?php

namespace App\Services;

class PaymentReferenceService
{
    public function generate(string $entityCode, string $invoiceId, int $month, float $amount): string
    {
        // O montante não deve ter ponto/vírgula decimal.
        // Os dois últimos dígitos correspondem às casas decimais.
        $formattedAmount = number_format($amount, 2, '', '');
        
        $formattedMonth = str_pad($month, 2, '0', STR_PAD_LEFT);

        // A junção de "Entidade + Número Factura/Código Estudante + Mês de Pagamento + Montante".
        $baseString = $entityCode . $invoiceId . $formattedMonth . $formattedAmount;

        $pi = 0;
        // O cálculo do Pi inicia com 0 para i=1.
        for ($i = 0; $i < strlen($baseString); $i++) {
            $digit = (int)$baseString[$i];
            // Si = digito(i) + Pi
            $si = $digit + $pi;
            // Pi = (Si * 10) mod 97
            $pi = ($si * 10) % 97;
        }

        // Calcular "Pn".
        // Pn = (Pi * 10) mod 97
        $pn = ($pi * 10) % 97;
        
        // Calcular check digit.
        // Check digit = 98 – Pn
        $checkDigit = 98 - $pn;
        $formattedCheckDigit = str_pad($checkDigit, 2, '0', STR_PAD_LEFT);

        // Referência = Número factura + Mês + Check digit.
        $finalReference = $invoiceId . $formattedMonth . $formattedCheckDigit;

        return $finalReference;
    }
}

