<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Editar matriz</h5>
                            <form class="row g-3" wire:submit.prevent="submit">
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Titulo</label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror"
                                        id="title" required placeholder="Insira o titulo..."  name="title" wire:model="title" >
                                    @error('title')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                    <div class="col-md-6">
                                    <label for="author" class="form-label">Autor</label>
                                    <input type="text" class="form-control @error('author') is-invalid @enderror"
                                        id="author" required placeholder="Insira o autor..."  name="author" wire:model="author" >
                                    @error('author')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                
                                <div class="col-md-12" >
                                    <label for="description" class="form-label"><b>Descrição</b></label>
                                    <input class="form-control" wire:model="description" id="description"
                                           value="{{ $description }}"
                                           type="text"
                                           name="description">
                                    <!---trix-editor
                                        input="description"></trix-editor------>
                                    @error('description')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div wire:loading wire:target="photo"><span
                                    class="spinner-border spinner-border-sm"></span> Carregando...
                            </div>
                            <div class="col-md-12">
                                <label for="photo" class="form-label"> Ficheiro</label>
                                <input type="file" class="form-control @error('photo') is-invalid @enderror"
                                    name="photo"   wire:model ="photo" placeholder="Carregar ficheiro...">
                                @error('photo')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                              
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary btn-lg float-end"
                                            wire:loading.class="disabled"
                                            wire:offline.attr="disabled"><span wire:target="submit"
                                                                               wire:loading.class="spinner-border spinner-border-lg"></span>
                                        Guardar
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
