<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Adicionar Plano de Taxas</h5>
                            <form class="row g-3" wire:submit.prevent="submit" style="display:none">
                                
                                <!-- Fees Group -->
                                <div class="col-md-12">
                                    <label for="fees_group" class="form-label">Grupo de Taxas</label>
                                    <select class="form-control @error('fees_group') is-invalid @enderror" id="fees_group" wire:model.lazy="fees_group">
                                        <option value="">Selecionar o grupo de taxas</option>
                                        @foreach ($FeeGroups as $group)
                                            <option value="{{ $group->id }}">{{ $group->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('fees_group')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror 
                                </div>

                                <!-- Fees Type -->
                                <div class="col-md-12">
                                    <label for="fees_type" class="form-label">Tipo de Taxa</label>
                                    <select class="form-control @error('fees_type') is-invalid @enderror" id="fees_type" wire:model.lazy="fees_type">
                                        <option value="">Selecionar o tipo de taxa</option>
                                        @foreach ($FeeTypes as $type)
                                            <option value="{{ $type->id }}">{{ $type->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('fees_type')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <!-- Due Date -->
                                <div class="col-md-12">
                                    <label for="due_date" class="form-label">Data de Vencimento</label>
                                    <input type="date" class="form-control @error('due_date') is-invalid @enderror"
                                           id="due_date" wire:model.lazy="due_date">
                                    @error('due_date')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <!-- Amount -->
                                <div class="col-md-12">
                                    <label for="amount" class="form-label">Montante</label>
                                    <input type="number" class="form-control @error('amount') is-invalid @enderror"
                                           id="amount" placeholder="Insira o montante..." wire:model.lazy="amount">
                                    @error('amount')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <!-- Fine Types -->
                                <div class="col-md-12">
                                    <label class="form-label">Tipo de Multas</label><br>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" wire:model="fine_type" value="none" id="fineNone" checked>
                                        <label class="form-check-label" for="fineNone">Nenhum</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" wire:model="fine_type" value="percentage" id="finePercentage">
                                        <label class="form-check-label" for="finePercentage">Percentagem</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" wire:model="fine_type" value="amount" id="fineAmount">
                                        <label class="form-check-label" for="fineAmount">Valor fixo</label>
                                    </div>
                                    @error('fine_type')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <!-- Percentage and Fixed Amount Row -->
                                <div class="row">
                                    @if($fine_type === 'percentage')
                                    <!-- Percentage Field -->
                                    <div class="col-md-6">
                                        <label for="percentage" class="form-label">Percentagem</label>
                                        <input type="number" class="form-control @error('percentage') is-invalid @enderror"
                                            id="percentage" placeholder="Insira o valor (%)..." wire:model.lazy="percentage">
                                        @error('percentage')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                    @endif

                                    @if($fine_type === 'amount')
                                    <!-- Fixed Amount Field -->
                                    <div class="col-md-6">
                                        <label for="fixed_amount" class="form-label">Valor fixo</label>
                                        <input type="number" class="form-control @error('fixed_amount') is-invalid @enderror"
                                            id="fixed_amount" placeholder="Insira o valor fixo..." wire:model.lazy="fixed_amount">
                                        @error('fixed_amount')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                    @endif
                                </div>


                                <!-- Submit Button -->
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary btn-lg float-end"
                                            wire:loading.attr="disabled">
                                        <span wire:loading.class="spinner-border spinner-border-sm"></span>
                                        Guardar
                                    </button>
                                </div>
                            </form>

                            <div class="fee-management-form">
                                <div class="card border-0 shadow">
                                    <div class="card-header bg-primary text-white py-3">
                                        <h2 class="h5 mb-0">
                                            <i class="fas fa-file-invoice-dollar me-2"></i>
                                            Plano de Taxas Escolares
                                        </h2>
                                    </div>
                                    
                                    <div class="card-body p-4">
                                        <form wire:submit.prevent="store" class="needs-validation" novalidate>
                                            <!-- Section 1: Basic Information -->
                                            <div class="row mb-4">
                                                <div class="col-md-6 mb-3">
                                                    <label for="fee_name" class="form-label fw-semibold">Designação da Taxa <span class="text-danger">*</span></label>
                                                    <div class="input-group">
                                                        <span class="input-group-text bg-light">
                                                            <i class="fas fa-tag"></i>
                                                        </span>
                                                        <input type="text" class="form-control form-control-lg" id="fee_name"
                                                               wire:model="fee_name" placeholder="Ex: Propina, Transporte..." required>
                                                    </div>
                                                    @error('fee_name') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                </div>
                                                
                                                <div class="col-md-6 mb-3">
                                                    <label for="monthly_fee_grade_7_12" class="form-label fw-semibold">Valor Mensal <span class="text-danger">*</span></label>
                                                    <div class="input-group">
                                                        <span class="input-group-text bg-light">MT</span>
                                                        <input type="number" class="form-control form-control-lg" id="monthly_fee_grade_7_12"
                                                               wire:model="monthly_fee_grade_7_12" required>
                                                        <span class="input-group-text bg-light">,00</span>
                                                    </div>
                                                    @error('monthly_fee_grade_7_12') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                </div>
                                            </div>

                                            <!-- Section 2: Payment Settings -->
                                            <div class="row mb-4">
                                                <div class="col-md-3 mb-3">
                                                    <label for="payment_start_day" class="form-label fw-semibold">Dia de Início <span class="text-danger">*</span></label>
                                                    <div class="input-group">
                                                        <span class="input-group-text bg-light">
                                                            <i class="fas fa-calendar-day"></i>
                                                        </span>
                                                        <input type="number" class="form-control form-control-lg" id="payment_start_day"
                                                               wire:model="payment_start_day" min="1" max="31" required>
                                                    </div>
                                                    @error('payment_start_day') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                </div>
                                                
                                                <div class="col-md-3 mb-3">
                                                    <label for="payment_due_day" class="form-label fw-semibold">Dia de Vencimento <span class="text-danger">*</span></label>
                                                    <div class="input-group">
                                                        <span class="input-group-text bg-light">
                                                            <i class="fas fa-calendar-check"></i>
                                                        </span>
                                                        <input type="number" class="form-control form-control-lg" id="payment_due_day"
                                                               wire:model="payment_due_day" min="1" max="31" required>
                                                    </div>
                                                    @error('payment_due_day') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                </div>
                                                
                                                <div class="col-md-6 mb-3">
                                                    <label class="form-label fw-semibold">Tipo de Multa <span class="text-danger">*</span></label>
                                                    <div class="btn-group w-100 shadow-sm" role="group">
                                                        <input type="radio" class="btn-check" wire:model="penalty_type"
                                                               value="percentage" id="percentage" required>
                                                        <label class="btn btn-outline-primary" for="percentage">
                                                            <i class="fas fa-percent me-2"></i> Porcentagem
                                                        </label>
                                                        
                                                        <input type="radio" class="btn-check" wire:model="penalty_type"
                                                               value="fixed" id="fixed" required>
                                                        <label class="btn btn-outline-primary" for="fixed">
                                                            <i class="fas fa-money-bill-wave me-2"></i> Valor Fixo
                                                        </label>
                                                    </div>
                                                    @error('penalty_type') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                </div>
                                            </div>

                                            <!-- Conditional Late Fee Field -->
                                            <div class="row mb-4">
                                                @if($penalty_type === 'percentage')
                                                <div class="col-md-6 mb-3">
                                                    <label for="late_penalty_percentage" class="form-label fw-semibold">Percentual de Multa <span class="text-danger">*</span></label>
                                                    <div class="input-group">
                                                        <span class="input-group-text bg-light">%</span>
                                                        <input type="number" class="form-control form-control-lg" id="late_penalty_percentage"
                                                               wire:model="late_penalty_percentage" required>
                                                    </div>
                                                    @error('late_penalty_percentage') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                </div>
                                                @endif
                                                
                                                @if($penalty_type === 'fixed')
                                                <div class="col-md-6 mb-3">
                                                    <label for="late_penalty_fixed" class="form-label fw-semibold">Valor Fixo da Multa <span class="text-danger">*</span></label>
                                                    <div class="input-group">
                                                        <span class="input-group-text bg-light">MT</span>
                                                        <input type="number" class="form-control form-control-lg" id="late_penalty_fixed"
                                                               wire:model="late_penalty_fixed" required>
                                                        <span class="input-group-text bg-light">,00</span>
                                                    </div>
                                                    @error('late_penalty_fixed') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                </div>
                                                @endif
                                            </div>

                                            <!-- Section 3: Application Period -->
                                            <div class="row mb-4">
                                                <div class="col-md-6 mb-3">
                                                    <label class="form-label fw-semibold">Meses de Cobrança <span class="text-danger">*</span></label>
                                                    <div class="card border-0 shadow-sm">
                                                        <div class="card-body p-3">
                                                            <div class="row">
                                                                @foreach([
                                                                    'January' => 'Janeiro',
                                                                    'February' => 'Fevereiro',
                                                                    'March' => 'Março',
                                                                    'April' => 'Abril',
                                                                    'May' => 'Maio',
                                                                    'June' => 'Junho',
                                                                    'July' => 'Julho',
                                                                    'August' => 'Agosto',
                                                                    'September' => 'Setembro',
                                                                    'October' => 'Outubro',
                                                                    'November' => 'Novembro',
                                                                    'December' => 'Dezembro'
                                                                ] as $engMonth => $ptMonth)
                                                                    <div class="col-4 mb-2">
                                                                        <div class="form-check">
                                                                            <input class="form-check-input" type="checkbox"
                                                                                   wire:model="months" value="{{ $engMonth }}"
                                                                                   id="month_{{ $engMonth }}">
                                                                            <label class="form-check-label" for="month_{{ $engMonth }}">
                                                                                {{ $ptMonth }}
                                                                            </label>
                                                                        </div>
                                                                    </div>
                                                                @endforeach
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @error('months') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                </div>
                                                
                                                <div class="col-md-6 mb-3">
                                                    <label class="form-label fw-semibold">Classes Aplicáveis <span class="text-danger">*</span></label>
                                                    <div class="card border-0 shadow-sm">
                                                        <div class="card-body p-3">
                                                            <div class="row">
                                                                @for($i = 1; $i <= 12; $i++)
                                                                    <div class="col-4 mb-2">
                                                                        <div class="form-check">
                                                                            <input class="form-check-input" type="checkbox"
                                                                                   wire:model="grades" value="{{ $i }}"
                                                                                   id="grade_{{ $i }}">
                                                                            <label class="form-check-label" for="grade_{{ $i }}">
                                                                                {{ $i }}ª Classe
                                                                            </label>
                                                                        </div>
                                                                    </div>
                                                                @endfor
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @error('grades') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                    
                                                    <div class="mt-4">
                                                        <label class="form-label fw-semibold">Estado do Plano <span class="text-danger">*</span></label>
                                                        <div class="btn-group w-100 shadow-sm" role="group">
                                                            <input type="radio" class="btn-check" wire:model="active"
                                                                   value="1" id="active_1" required>
                                                            <label class="btn btn-outline-success" for="active_1">
                                                                <i class="fas fa-check-circle me-2"></i> Ativo
                                                            </label>
                                                            
                                                            <input type="radio" class="btn-check" wire:model="active"
                                                                   value="0" id="active_0" required>
                                                            <label class="btn btn-outline-danger" for="active_0">
                                                                <i class="fas fa-times-circle me-2"></i> Inativo
                                                            </label>
                                                        </div>
                                                        @error('active') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Submit Section -->
                                            <div class="d-flex justify-content-between border-top pt-4">
                                                <button type="button" class="btn btn-outline-secondary px-4" wire:click="cancel">
                                                    <i class="fas fa-times me-2"></i> Cancelar
                                                </button>
                                                
                                                <button type="submit" class="btn btn-primary px-4" wire:loading.attr="disabled">
                                                    <span wire:loading.class="spinner-border spinner-border-sm" wire:loading.remove.class="fas fa-save"></span>
                                                    <span class="ms-2">Guardar Plano</span>
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            <style>
                                .fee-management-form {
                                    max-width: 1200px;
                                    margin: 0 auto;
                                }
                                
                                .card {
                                    border-radius: 0.5rem;
                                    overflow: hidden;
                                }
                                
                                .form-control, .btn, .input-group-text {
                                    border-radius: 0.375rem;
                                }
                                
                                .btn-check:checked + .btn-outline-primary {
                                    background-color: var(--bs-primary);
                                    color: white;
                                }
                                
                                .btn-check:checked + .btn-outline-success {
                                    background-color: var(--bs-success);
                                    color: white;
                                }
                                
                                .btn-check:checked + .btn-outline-danger {
                                    background-color: var(--bs-danger);
                                    color: white;
                                }
                                
                                .form-check-input:checked {
                                    background-color: var(--bs-primary);
                                    border-color: var(--bs-primary);
                                }
                                
                                .input-group-text {
                                    transition: all 0.2s;
                                }
                                
                                .form-control:focus, .form-check-input:focus {
                                    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
                                }
                            </style>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
