<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title">Lista de Grupos de Taxas</h5>
                            <div class="row">
                                <div class="col-md-10">
                                    <input type="search" wire:model="search" placeholder="Pesquisar Tipos de Taxas..."
                                           class="form-control">
                                </div>
                                 <div class="col-md-2">
                                    <a class=" btn-primary btn bg-info " href="{{ route('admin.add.feegroup') }}">Adicionar</a>
                                </div>
                            </div>
                            <div class="table-responsive" wire:init="loadData">
                                @if(count($FeeGroups))
                                    <table class="table table-hover">
                                        <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">Nome</th>
                                            <th scope="col">Descrição</th>
                                            <th scope="col">Editar</th>
                                            <th scope="col">Eliminar</th>
                                            <th scope="col">Data/Hora</th>>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @php($count = 1)
                                        @foreach($FeeGroups as $feeGroup)
                                            <tr>
                                                <th scope="row">{{ $count++ }}</th>
                                                <td>{{ $feeGroup->name }}</td>
                                                <td>{{ $feeGroup->description }}</td>
                                                <td>
                                                    <a href="{{ route('admin.edit.feegroup', $feeGroup->id) }}"
                                                       class="btn btn-outline-primary">
                                                        <span class="fa fa-edit"></span>
                                                    </a>
                                                </td>
                                                <td>
                                                    <button wire:click="submit('{{ $feeGroup->id }}')"
                                                            class="btn btn-danger btn-sm">Deletar
                                                    </button>
                                                </td>
                                                <td>{{ date('F d, Y h:i a', strtotime($feeGroup->created_at)) }}</td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                    <div class="row float-end">
                                        {{ $FeeGroups->links() }}
                                    </div>
                                @else
                                    <br><br>
                                    <div class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><b>Não foram encontrados dados neste momento.</b></p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
