<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title"> Lista de Confirmações de Pagamento</h5>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <input type="search" wire:model="searchTerm" placeholder="Pesquisar..." class="form-control">
                                </div>

                                @if(Auth::check() && Auth::user()->role == 0) <!-- Show Only For Admin -->
                                    <div class="col-md-6 mb-3">
                                        <div class="form-group">
                                            <select id="classFilter" wire:model="selectedClass" class="form-control">
                                                <option value="">Todas classes</option>
                                                @foreach($classes as $class)
                                                    <option value="{{ $class->id }}">{{ $class->class }} - {{ $class->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                @endif
                            </div>

                            <div class="table-responsive" wire:init="loadData">
                                @if(count($models))
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th scope="col">#</th>
                                                <th scope="col">Para</th>
                                                <th scope="col">Classe</th>
                                                <th scope="col">Estudante</th>
                                                <th scope="col">Descrição</th>
                                                <th scope="col">Ficheiro</th>
                                                <th scope="col">Acção</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php($count = 1)
                                            @foreach ($models as $model)
                                                @if ($model) {{-- Ensure the model is not null --}}
                                                    <tr>
                                                        <th scope="row">{{ $count++ }}</th>
                                                        <td>{{ $model['typeTitle'] }}</td>
                                                        <td>{{ $model['classDetails'] ?? 'N/A' }}</td>
                                                        <td>{{ $model['studentName'] ?? 'N/A' }}</td>
                                                        <td>{{ $model['title'] }}</td>
                                                        <td><a href="{{ $model['mediaUrl'] }}">{{ $model['mediaName'] }}</a></td>
                                                        <td>
                                                            <a href="" class="btn btn-block btn-outline-primary btn-sm">
                                                                <span class="fa fa-edit"></span>
                                                            </a>
                                                            <a type="button" wire:click="submit('')" class="btn btn-outline-danger">
                                                                <span class="fa fa-trash"></span>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                @endif
                                            @endforeach
                                        </tbody>
                                    </table>
                                    <div class="d-flex justify-content-center">
                                        {{ $models->links() }}
                                    </div>
                                @else
                                    <br>
                                    <br>
                                    <div  class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
