<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Enviar notificação (Android/iOS)</h5>
                            <form class="row g-3" wire:submit.prevent="submit">
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Enviar para</label>
                                    <select class="form-control" wire:model="type">
                                        <option value="all">Todos</option>
                                        <option value="class">Classe ou Turma</option>
                                        <option value="student">Estudante</option>
                                    </select>
                                </div>

                                @if($type == "class" || $type == "student")
                                    <div class="col-md-6">
                                        <label for="title" class="form-label">Turma</label>
                                        <select class="form-control" wire:model="class_id">
                                            <option value="">Selecione a Turma</option>
                                            @foreach($classrooms as $class)
                                                <option value="{{ $class->id }}"> {{ $class->class }} - {{ $class->name }} </option>
                                            @endforeach
                                        </select>
                                        @error('class_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                @endif

                                @if($type == "student")
                                    <div class="col-md-6">
                                        <label for="title" class="form-label">Estudante</label>
                                        <select class="form-control" wire:model="student_id">
                                            <option value="">Selecione o Estudante</option>
                                            @foreach($students as $student)
                                                <option value="{{ $student->id }}"> {{ $student->name }} </option>
                                            @endforeach
                                        </select>
                                        @error('student_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                @endif

                                <div class="col-md-6">
                                    <label for="title" class="form-label">Enviar para estudantes:</label>
                                    Regulares
                                    <input type="radio" class="@error('student_type') is-invalid @enderror" id="student_type_regular" checked required placeholder="" name="student_type" value="1" wire:model="student_type">
                                    Irregulares
                                    <input type="radio" class="@error('student_type') is-invalid @enderror" required placeholder="" name="student_type" value="0" wire:model="student_type">
                                    @error('student_type')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label for="message" class="form-label">Mensagem (notificação)</label>
                                    <textarea class="form-control @error('message') is-invalid @enderror" id="message" required placeholder="Escreva a mensagem (notificação)..." name="message" wire:model="message"></textarea>
                                    @error('message')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary btn-lg float-end" wire:loading.attr="disabled" wire:target="submit">
                                        <span wire:loading wire:target="submit" class="spinner-border spinner-border-lg"></span>
                                        Enviar
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>