<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title"> Lista de disciplinas</h5>
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="search" wire:model="search" placeholder="Pesquisar..."
                                           class="form-control">
                                </div>
                            </div>
                            <div class="table-responsive" wire:init="loadData">
                                <?php if(count($models)): ?>
                                    <table class="table table-hover">
                                        <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">Nome</th>
                                            <th scope="col">Editar</th>
                                            <th scope="col">Deletar</th>
                                            <th scope="col">Data/Hora</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php ($count = 1); ?>
                                        <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th scope="row"><?php echo e($count++); ?></th>
                                                <td><?php echo e($model->name); ?></td>
                                                <td>
                                                    <a href="<?php echo e(route('admin.edit.subject',$model->slug)); ?>"
                                                       class="btn btn-outline-primary"><span
                                                            class="fa fa-edit"></span>
                                                    </a>
                                                </td>
                                                <td>
                                                    <button wire:click="submit('<?php echo e($model->id); ?>')"
                                                            class="btn btn-danger btn-sm">Deletar
                                                    </button>
                                                </td>
                                                <td><?php echo e(date('F d, Y h:i a', strtotime($model->created_at))); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                    <div class="row float-end">
                                        <?php echo e($models->links()); ?>

                                    </div>
                                <?php else: ?>
                                    <br>
                                    <br>
                                    <div  class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
<?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/livewire/admin/subjects/list-subjects.blade.php ENDPATH**/ ?>