<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title"> Lista de Confirmações de Pagamento</h5>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <input type="search" wire:model="searchTerm" placeholder="Pesquisar..." class="form-control">
                                </div>

                                <?php if(Auth::check() && Auth::user()->role == 0): ?> <!-- Show Only For Admin -->
                                    <div class="col-md-6 mb-3">
                                        <div class="form-group">
                                            <select id="classFilter" wire:model="selectedClass" class="form-control">
                                                <option value="">Todas classes</option>
                                                <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($class->id); ?>"><?php echo e($class->class); ?> - <?php echo e($class->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <div class="table-responsive" wire:init="loadData">
                                <?php if(count($models)): ?>
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th scope="col">#</th>
                                                <th scope="col">Para</th>
                                                <th scope="col">Classe</th>
                                                <th scope="col">Estudante</th>
                                                <th scope="col">Descrição</th>
                                                <th scope="col">Ficheiro</th>
                                                <th scope="col">Acção</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php ($count = 1); ?>
                                            <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($model): ?> 
                                                    <tr>
                                                        <th scope="row"><?php echo e($count++); ?></th>
                                                        <td><?php echo e($model['typeTitle']); ?></td>
                                                        <td><?php echo e($model['classDetails'] ?? 'N/A'); ?></td>
                                                        <td><?php echo e($model['studentName'] ?? 'N/A'); ?></td>
                                                        <td><?php echo e($model['title']); ?></td>
                                                        <td><a href="<?php echo e($model['mediaUrl']); ?>"><?php echo e($model['mediaName']); ?></a></td>
                                                        <td>
                                                            <a href="" class="btn btn-block btn-outline-primary btn-sm">
                                                                <span class="fa fa-edit"></span>
                                                            </a>
                                                            <a type="button" wire:click="submit('')" class="btn btn-outline-danger">
                                                                <span class="fa fa-trash"></span>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                    <div class="d-flex justify-content-center">
                                        <?php echo e($models->links()); ?>

                                    </div>
                                <?php else: ?>
                                    <br>
                                    <br>
                                    <div  class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/livewire/admin/paymentconfirmation/payments.blade.php ENDPATH**/ ?>