<?php
$class_id = '';
$mfd_count = 0;
$get_class = '';
$subjects_get = [];
$showThirdTrimesterColumns = false; // Inicializa a variável

// Carregar disciplinas e classes apenas uma vez para evitar duplicação
foreach ($models as $model) {
    $classroom = \App\Models\Classroom::find($model->classroom_id);
    if ($classroom) {
        $get_class = $classroom->class ?? 0;
        
        // Verifica se é o terceiro trimestre
                if ($model->trimester_id == 3) {
                    $showThirdTrimesterColumns = true;
                }


        // Carregar disciplinas relacionadas
        $query_subjects = \App\Models\TeacherSubject::where('classroom_id', $model->classroom_id)->pluck('subject_id');
        $subjects = \App\Models\Subject::whereIn('id', $query_subjects)->pluck('name', 'id')->toArray();

        $subjects_get = array_merge($subjects_get, $subjects);
    }

    $class_id = $get_class;
    if ($get_class != 0) {
        break;
    }
}

// Ordenar disciplinas por ordem alfabética
ksort($subjects_get);

// Arrays de disciplinas específicas para NE/AF
$ne_subjects3 = ['Português', 'Matemática'];
$ne_subjects6 = ['Português', 'Matemática', 'História', 'Geografia', 'Física', 'Química', 'Biologia', 'Ciências naturais', 'Ciências sociais', 'Filosofia'];
$ne_subjects = ['Português', 'Matemática', 'Inglês', 'História', 'Geografia', 'Física', 'Química', 'Biologia', 'Ciências naturais', 'Ciências sociais', 'Filosofia'];

$subjects = $subjects_get;
$divide = count($subjects);

/**
 * Função para calcular valores de trimestre
 */
function getTrimesterValues($student_id, $classroom_id, $subject_id, $trimester_id)
{
    static $exam_cache = [];

    $key = "{$student_id}_{$classroom_id}_{$subject_id}_{$trimester_id}";
    if (!isset($exam_cache[$key])) {
        $exam = \App\Models\Exam::where([
            ['trimester_id', $trimester_id],
            ['classroom_id', $classroom_id],
            ['subject_id', $subject_id],
            ['student_id', $student_id],
        ])->first();

        $exam_cache[$key] = [
            (float) ($exam->ACS1a ?? 0),
            (float) ($exam->ACS2a ?? 0),
            (float) ($exam->AT ?? 0),
            (float) ($exam->NE ?? 0),
        ];
    }

    return $exam_cache[$key];
}
?>

<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:poll.keep-alive>
                            <h5 class="card-title">Notas do estudante</h5>
                            <div class="row">
                                <div class="col-md-12"></div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="table-responsive" wire:init="loadData">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th colspan="4"></th>
                                                    <?php foreach ($subjects as $key => $name): ?>
                                                        <?php
                                                        $current_ne_subjects = ($class_id == 3) ? $ne_subjects3 : (($class_id == 6) ? $ne_subjects6 : $ne_subjects);
                                                        if ($class_id == 6 || $class_id == 10 || $class_id == 12 || $class_id == 3): ?>
                                                            <th colspan="<?= ($showThirdTrimesterColumns && in_array($name, $current_ne_subjects)) ? 6 : 5 ?>" style="border: 1px solid #000; text-align: center;">
                                                                <?= $name ?>
                                                            </th>
                                                        <?php else: ?>
                                                            <th colspan="5" style="border: 1px solid #000; text-align: center;">
                                                                <?= $name ?>
                                                            </th>
                                                        <?php endif; ?>
                                                    <?php endforeach; ?>
                                                </tr>
                                                <tr>
                                                    <th style="background-color: #2596be; color: #fff; padding: 10px;">#</th>
                                                    <th style="background-color: #2596be; color: #fff; padding: 10px;">Nome Completo</th>
                                                    <th style="background-color: #2596be; color: #fff; padding: 10px;">ID do Estudante</th>
                                                    <th style="background-color: #2596be; color: #fff; padding: 10px;">Sexo</th>
                                                    <?php foreach ($subjects as $key => $name): ?>
                                                        <th style="font-weight: bold; font-size:10px; background-color: #2596be; color: white;">ACS1</th>
                                                        <th style="font-weight: bold; font-size:10px; background-color: #2596be; color: white;">ACS2</th>
                                                        <th style="font-weight: bold; font-size:10px; background-color: #2596be; color: white;">MACS</th>
                                                        <th style="font-weight: bold; font-size:10px; background-color: #2596be; color: white;">AT</th>
                                                        <th style="font-weight: bold; font-size:10px; background-color: #2596be; color: white;">MT</th>
                                                        <?php if ($showThirdTrimesterColumns && in_array($name, $current_ne_subjects)): ?>
                                                            <th style="font-weight: bold; font-size:10px; background-color: #2596be; color: white;">
                                                                <?= $class_id == 3 ? 'AF' : 'NE' ?>
                                                            </th>
                                                        <?php endif; ?>
                                                    <?php endforeach; ?>
                                                    <th style="background-color: #2596be; color: white; text-align: center; padding: 10px;">MFD</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php ($count = 1); ?>
                                                <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php $mfd_count = 0; ?>
                                                    <tr>
                                                        <th><?php echo e($count++); ?></th>
                                                        <td><?php echo e($model->student->name); ?></td>
                                                        <td><?php echo e($model->student->student_id); ?></td>
                                                        <td><?php echo e($model->student->sex); ?></td>

                                                        <?php foreach ($subjects as $key => $name): ?>
                                                        <?php
                                                        // Use o trimestre atual da exportação em vez de sempre o trimestre 1
                                                        $current_trim = getTrimesterValues($model->student_id, $model->classroom_id, $key, $model->trimester_id);
                                                        $trim3 = getTrimesterValues($model->student_id, $model->classroom_id, $key, 3);

                                                        $acs1 = $current_trim[0];
                                                        $acs2 = $current_trim[1];
                                                        $macs = round(($acs1 + $acs2) / 2, 2);
                                                        $at = $current_trim[2];
                                                        $mt = round(($acs1 + $acs2 + $at) / 3, 2);
                                                        $ne = $trim3[3];

                                                        $mfd = in_array($name, $current_ne_subjects) && $showThirdTrimesterColumns
                                                            ? round(($mt * 2 + $ne) / 3, 2)
                                                            : $mt;

                                                        $mfd_count += $mfd;
                                                        ?>
                                                        <td><?php echo e(number_format($acs1, 2)); ?></td>
                                                        <td><?php echo e(number_format($acs2, 2)); ?></td>
                                                        <td><?php echo e(number_format($macs, 2)); ?></td>
                                                        <td><?php echo e(number_format($at, 2)); ?></td>
                                                        <td><?php echo e(round($mt)); ?></td>
                                                        <?php if ($showThirdTrimesterColumns && in_array($name, $current_ne_subjects)): ?>
                                                            <td><?php echo e(number_format($ne, 2)); ?></td>
                                                        <?php endif; ?>
                                                    <?php endforeach; ?>
                                                    
                                                    <td>
                                                        <?php echo e($divide > 0 ? round($mfd_count / $divide) : '0'); ?>

                                                    </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/exports/allsubject.blade.php ENDPATH**/ ?>