<div>
    <div class="page-header">
        <nav class="navbar navbar-expand-lg d-flex justify-content-between">
            <!-- Left Navigation Menu -->
            <div id="navbarNav">
                <ul class="navbar-nav" id="leftNav">
                    <li class="nav-item">
                        <a class="nav-link" id="sidebar-toggle" href="#"><i class="fa fa-arrow-left"></i></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('user.home')); ?>">Inicio</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Ajuda</a>
                    </li>
                </ul>
            </div>

            <!-- Logo Section -->
            <div>
                <a href="<?php echo e(route('user.home')); ?>">
                    <img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="Logo" style="width:80px;height:50px;">
                </a>
            </div>

            <!-- Right Navigation Menu with Notifications and Profile -->
            <div id="headerNav" wire:init="loadData">
                <ul class="navbar-nav" wire:poll.3m>
                    
                    <!-- Chat Icon -->
                    <li class="nav-item">
                        <a href="<?php echo e(url('/chat')); ?>">
                            <svg xmlns="http://www.w3.org/2000/svg" width="66" height="36" fill="currentColor" class="bi bi-whatsapp">
                                <path d="M13.601 2.326A7.85 7.85 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.9 7.9 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.9 7.9 0 0 0 13.6 2.326zM7.994 14.521a6.6 6.6 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.56 6.56 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592m3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.73.73 0 0 0-.529.247c-.182.198-.691.677-.691 1.654s.71 1.916.81 2.049c.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232"/>
                            </svg>
                        </a>
                    </li>

                    <!-- Notifications Dropdown -->
                    <li class="nav-item dropdown">
                        <a class="nav-link notifications-dropdown" href="#" id="notificationsDropDown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <?php echo e(number_format(count($notifications))); ?>

                        </a>
                        <div class="dropdown-menu dropdown-menu-end notif-drop-menu" aria-labelledby="notificationsDropDown">
                            <?php if(count($notifications)): ?>
                                <h6 class="dropdown-header">
                                    Notificações
                                    <a href="#" wire:click.debounce.500ms="markAsRead" class="float-end">Marcar tudo como lido</a>
                                </h6>
                                <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="#" wire:key="notification-<?php echo e($notification->id); ?>">
                                        <div class="header-notif">
                                            <div class="notif-image">
                                                <span class="notification-badge">
                                                    <img src="<?php echo e(\App\Http\Controllers\SystemController::generateAvatars($notification->subject,200)); ?>" alt="">
                                                </span>
                                            </div>
                                            <div class="notif-text">
                                                <p><?php echo e($notification->description); ?></p>
                                                <small><?php echo e(\App\Http\Controllers\SystemController::elapsedTime($notification->created_at)); ?></small>
                                            </div>
                                        </div>
                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <h1 class="text-center text-danger"><i class="fa fa-bell-slash"></i></h1>
                            <?php endif; ?>
                        </div>
                    </li>

                    <!-- Profile Dropdown -->
                    <li class="nav-item dropdown">
                        <a class="nav-link profile-dropdown" href="#" id="profileDropDown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <img src="<?php echo e(\App\Http\Controllers\SystemController::generateAvatars($user->name,200)); ?>" alt="User Avatar">
                        </a>
                        <div class="dropdown-menu dropdown-menu-end profile-drop-menu" aria-labelledby="profileDropDown">
                            <a class="dropdown-item" href="<?php echo e(route('user.profile')); ?>">
                                <i class="far fa-user"></i> <?php echo e($user->name); ?>

                            </a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item" href="#" wire:click="logout">
                                <i class="fa fa-lock"></i> Sair
                            </a>
                        </div>
                    </li>
                </ul>
            </div>
        </nav>
    </div>
</div>

<?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/livewire/user/inc/header.blade.php ENDPATH**/ ?>